<?php

class DateHelper
{
  const FILE_DATETIME = 'YmdHis';
  
  const ISO9075_DATETIME = 'Y-m-d H:i:s';
  const ISO9075_DATE = 'Y-m-d';
  const ISO9075_TIME = 'H:i:s';

  const LOCAL_DATE = 'x';
  
  const KRIA_DATETIME = 'H:i:s:u - d/m/Y';
  
  static public function roundToNearestMinutes(DateTime $dateTime, $roundMinutes)
  {
    list($hours, $minutes, $seconds) = explode(":", $dateTime->format("H:i:s"));
    $minutes = round($minutes/$roundMinutes)*$roundMinutes;
    $dateTime->setTime($hours, $minutes, $seconds);
  }

  static public function removeSeconds(DateTime $dateTime)
  {
    list($hours, $minutes, $seconds) = explode(":", $dateTime->format("H:i:s"));
    $dateTime->setTime($hours, $minutes, 0);
  }

  static public function format(DateTime $dateTime = null, $format = "")
  {
    if (!isset($dateTime))
      $dateTime = new DateTime();

    return Yii::app()->dateFormatter->format($format, $dateTime->getTimestamp());
  }

  static public function formatDateTime(DateTime $dateTime = null, $format = "full")
  {
    if (!isset($dateTime))
      $dateTime = new DateTime();

    return Yii::app()->dateFormatter->formatDateTime($dateTime->getTimestamp(), $format, "short");
  }

  static public function formatDate(DateTime $dateTime = null, $format = "full")
  {
  	if (!isset($dateTime))
  		$dateTime = new DateTime();
  
  	return Yii::app()->dateFormatter->formatDateTime($dateTime->getTimestamp(), $format, null);
  }
  
  static public function formatTime(DateTime $dateTime = null, $format = "full")
  {
  	if (!isset($dateTime))
  		$dateTime = new DateTime();
  
  	return Yii::app()->dateFormatter->formatDateTime($dateTime->getTimestamp(), null, $format);
  }
  
  static public function formatLong($dateTime = null)
  {
    return self::formatDateTime($dateTime, "full");
  }

  static public function formatMedium($dateTime = null)
  {
    $dateFormat = Yii::app()->locale->getDateFormat('short');
    $timeFormat = Yii::app()->locale->getTimeFormat('short');

    return self::format($dateTime, "E, $dateFormat $timeFormat");
  }

  static public function formatShort($dateTime = null)
  {
    return self::formatDateTime($dateTime, "short");
  }

  static public function formatISO9075Date($dateTime = null)
  {
    $dateTime = self::ensureObject($dateTime);
          
    return $dateTime->format(self::ISO9075_DATE);
  }

  static public function formatISO9075Time($dateTime = null)
  {
    $dateTime = self::ensureObject($dateTime);
  
    return $dateTime->format(self::ISO9075_TIME);
  }

  static public function formatFileDateTime($dateTime = null)
  {    
    $dateTime = self::ensureObject($dateTime);
  
    return $dateTime->format(self::FILE_DATETIME);
  }

  public static function parse($time, $format= self::ISO9075_DATETIME)
  {
    return self::ensureObject(DateTime::createFromFormat($format, $time));
  }

  public static function parseEx($time, $format= self::ISO9075_DATETIME)
  {
    return self::ensureObjectEx(DateTime::createFromFormat($format, $time));
  }
  
  /**
   * @param mixed $dateTime
   * could be:
   *     - DateTime
   *     - DateTimeEx
   *     - string
   *     - unix integer timestamp
   *     - NULL or anything else will produce current date/time
   * @return DateTimeEx
   */
  public static function ensureObjectEx($dateTime=null)
  {
    return new DateTimeEx(DateHelper::ensureObject($dateTime));
  }
  
  /**
   * @param mixed $dateTime
   * could be:
   *     - DateTime
   *     - DateTimeEx
   *     - string 
   *     - unix integer timestamp
   *     - NULL or anything else will produce current date/time
   * @return DateTime
   */
  public static function ensureObject($dateTime=null)
  {
    if (!isset($dateTime))
      $dateTime = new DateTime();
    else if(is_string($dateTime))
      $dateTime = new DateTime($dateTime);
    else if(is_int($dateTime))
    {
      $dateTime2 = new DateTime();
      $dateTime2->setTimestamp($dateTime);
      $dateTime = $dateTime2;
    }
      else if(is_object($dateTime) && get_class($dateTime)=='DateTime')
    {      
    }
    else if(is_object($dateTime) && get_class($dateTime)=='DateTimeEx')
    {      
      $dateTime = $dateTime->toDateTime();
    }
    else
    {      /*
      if(is_object($dateTime)) 
        echo("|".get_class($dateTime)."|<br>\n");
      else  
        echo("|".gettype($dateTime)."|<br>\n");
      if(is_array($dateTime))
      {
        echo(_2str($dateTime));
        //CCallStack::printStack();
      }*/
      $dateTime = new DateTime();  
    }    
    return $dateTime;
  }
  
  static public function formatISO9075DateTime($dateTime = null)
  {
    $dateTime = self::ensureObject($dateTime);

    return self::formatISO9075Date($dateTime)." ".self::formatISO9075Time($dateTime);
  }
  
  static public function formatLocalDate($dateTime = null)
  {
  	$dateTime = self::ensureObject($dateTime);
  	
  	return Yii::app()->dateFormatter->formatDateTime($dateTime->getTimestamp(), 'short', null);
  
  	return strftime('%x', $dateTime->getTimestamp());
  }
  
  static public function formatLocalDateTime($dateTime = null)
  {
  	$dateTime = self::ensureObject($dateTime);
  
  	return strftime('%x', $dateTime->getTimestamp())." ".self::formatISO9075Time($dateTime);
  }
  
  static public function composeDateTime($dateStr, $hours=0, $minutes=0, $seconds=0)
  {
  	$dateTime = new DateTime($dateStr);
  	$dateTime->setTime($hours, $minutes, $seconds);
  	
  	return self::formatISO9075DateTime($dateTime);
  }
  static public function hourList($step = 1)
  {
  	$hours = array();
  	for($h = 0; $h < 23; $h += $step)
  	{
  		$hours[$h]['value'] = $h;
  		$hours[$h]['label'] = $h;
  	}
  	$hours[$h]['value'] = 23;
  	$hours[$h]['label'] = 23;
  	
  	return $hours;
  }
  
  static public function minuteList($step = 10)
  {
  	$minutes = array();
  	for($h = 0; $h < 59; $h += $step)
  	{
  		$minutes[$h]['value'] = $h;
  		$minutes[$h]['label'] = $h;

  	}
  	$minutes[$h]['value'] = 59;
  	$minutes[$h]['label'] = 59;

  	 
  	return $minutes;
  }
  
  static public function dayList($bNullChoice = false)
  {
  	$days = array();
  	for($h = 1; $h <= 31; $h++)
  	{
  		$days[$h]['value'] = $h;
  		$days[$h]['label'] = $h;
  	}
  	 
  	if($bNullChoice)
  	{
  		$daysN = array();
  	
  		$daysN[0]['value'] = null;
  		$daysN[0]['label'] = "-";
  	
  		$days = array_merge($daysN, $days);
  	}
  	
  	
  	return $days;
  }
  static public function monthList($bNullChoice = false)
  {
  	$months = array();
  		
   	$months[0]['value'] = 1;
	  $months[0]['label'] = DateHelper::getMonthName(1);
	  $months[1]['value'] = 2;
	  $months[1]['label'] = DateHelper::getMonthName(2);
	  $months[2]['value'] = 3;
	  $months[2]['label'] = DateHelper::getMonthName(3);
	  $months[3]['value'] = 4;
	  $months[3]['label'] = DateHelper::getMonthName(4);
	  $months[4]['value'] = 5;
	  $months[4]['label'] = DateHelper::getMonthName(5);
	  $months[5]['value'] = 6;
	  $months[5]['label'] = DateHelper::getMonthName(6);
	  $months[6]['value'] = 7;
	  $months[6]['label'] = DateHelper::getMonthName(7);
	  $months[7]['value'] = 8;
	  $months[7]['label'] = DateHelper::getMonthName(8);
	  $months[8]['value'] = 9;
	  $months[8]['label'] = DateHelper::getMonthName(9);
	  $months[9]['value'] = 10;
	  $months[9]['label'] = DateHelper::getMonthName(10);
	  $months[10]['value'] = 11;
	  $months[10]['label'] = DateHelper::getMonthName(11);
	  $months[11]['value'] = 12;
	  $months[11]['label'] = DateHelper::getMonthName(12);
	  
	  if($bNullChoice)
	  {
	  	$monthsN = array();
	  	
	  	$monthsN[0]['value'] = null;
	  	$monthsN[0]['label'] = "-";
	  	
	  	$months = array_merge($monthsN, $months);
	  }	  
	  
  	return $months;
  }

  static public function getMonthName($monthNumber)
  {
    switch ($monthNumber)
    {
    		case 1:
    		  return t('january');
    		case 2:
    		  return t('february');
    		case 3:
    		  return t('march');
    		case 4:
    		  return t('april');
    		case 5:
    		  return t('may');
    		case 6:
    		  return t('june');
    		case 7:
    		  return t('july');
    		case 8:
    		  return t('august');
    		case 9:
    		  return t('september');
    		case 10:
    		  return t('october');
    		case 11:
    		  return t('november');
    		case 12:
    		  return t('december');
    }
  }

  static public function getDayName($dayNumber)
  {
    switch ($dayNumber)
    {
    		case 1:
    		  return t('Monday');
    		case 2:
    		  return t('Tuesday');
    		case 3:
    		  return t('Wednesday');
    		case 4:
    		  return t('Thursday');
    		case 5:
    		  return t('Friday');
    		case 6:
    		  return t('Saturday');
    		case 7:
    		  return t('Sunday');
    }
  }
}
