<?php

class m130829_055350_adding_indexes_and_suff_for_plate_list extends MyDbMigration
{
	public function up()
	{
		$this->createIndex('list_code_index', 'whitelisttable', 'list_code');
		
		$this->createTable('vehicle_category',
				array(
						'id' => 'pk',
						'tag' => 'string',
						'name' => 'string',
						'description' => 'string',
						'color' => 'string',
						'priority' => 'integer',
				),
				'ENGINE=MyISAM');
		
		$this->execute('insert into vehicle_category(tag) (select distinct(category) as tag from vehicletable where category is not null)');

		$this->execute('update vehicle_category set name = tag, description = tag');
		
		if ($this->dbConnection->schema->getTable('event_reporting')->getColumn('extra_data') == null)
			$this->addColumn('event_reporting', 'extra_data', 'string');
	}

	public function down()
	{
    $this->dropIndex('list_code_index', 'whitelisttable');
    
    $this->dropTable('vehicle_category');
    
    if ($this->dbConnection->schema->getTable('event_reporting')->getColumn('extra_data') != null)
    	$this->dropColumn('event_reporting', 'extra_data');
    
		return true;
	}

	/*
	// Use safeUp/safeDown to do migration with transaction
	public function safeUp()
	{
	}

	public function safeDown()
	{
	}
	*/
}