<?php

class m130919_060940_behavior_alarm_mamagement extends MyDbMigration
{
	public function up()
	{
		if ($this->dbConnection->schema->getTable('behavior')->getColumn('priority') == null)
			$this->addColumn('behavior', 'priority', 'int');

		if ($this->dbConnection->schema->getTable('behavior')->getColumn('alarm_tag_name') == null)
			$this->addColumn('behavior', 'alarm_tag_name', 'string');
		
		$this->update('behavior', array('priority' => 0 , 'alarm_tag_name'=> 'blacklist'), 					 "tag='BlackList'");
		$this->update('behavior', array('priority' => 1 , 'alarm_tag_name'=> 'interesting vehicle'), "tag='InterestingVehicle'");
		$this->update('behavior', array('priority' => 2 , 'alarm_tag_name'=> 'vehicle stopped'), 		 "tag='StopVehicleViolation'");
		$this->update('behavior', array('priority' => 3 , 'alarm_tag_name'=> 'change of lane'), 		 "tag='ChangeOfLane'");
		$this->update('behavior', array('priority' => 4 , 'alarm_tag_name'=> 'abnormal behavior'), 	 "tag='AbnormalBehaviour'");
		$this->update('behavior', array('priority' => 5 , 'alarm_tag_name'=> 'left turn'), 					 "tag='LeftTurnVehicle'");
		$this->update('behavior', array('priority' => 6 , 'alarm_tag_name'=> 'right turn'), 				 "tag='RightTurnVehicle'");
		$this->update('behavior', array('priority' => 7 , 'alarm_tag_name'=> 'red violation'), 			 "tag='RedViolation'");
		$this->update('behavior', array('priority' => 8 , 'alarm_tag_name'=> 'dangerous good'), 		 "tag='DangerousGoods'");
		$this->update('behavior', array('priority' => 9 , 'alarm_tag_name'=> 'tailgating'), 				 "tag='InterdistanceAlarm'");
		$this->update('behavior', array('priority' => 10, 'alarm_tag_name'=> 'to check'), 					 "tag='VehicleToCheck'");
		$this->update('behavior', array('priority' => 11, 'alarm_tag_name'=> 'non stopping'), 			 "tag='NonStopVehicleViolation'");
		$this->update('behavior', array('priority' => 12, 'alarm_tag_name'=> 'non straight'), 			 "tag='NonStraightVehicle'");
		$this->update('behavior', array('priority' => 13, 'alarm_tag_name'=> 'whitelist violation'), "tag='WhiteListViolation'");
		$this->update('behavior', array('priority' => 14, 'alarm_tag_name'=> 'spot speed'), 				 "tag='Violation'");
		$this->update('behavior', array('priority' => 15, 'alarm_tag_name'=> 'mean speed'), 				 "tag='MeanSpeedViolation'");
		$this->update('behavior', array('priority' => 16, 'alarm_tag_name'=> 'wrong way'), 					 "tag='WrongWayAlarm'");
		$this->update('behavior', array('priority' => 17, 'alarm_tag_name'=> 'transit'), 						 "tag='GenericEvent'");
		$this->update('behavior', array('priority' => 18, 'alarm_tag_name'=> 'test'), 							 "tag='Test'");
		$this->update('behavior', array('priority' => 19, 'alarm_tag_name'=> 'statistics'), 				 "tag='Statistics'");
		
		
		if ($this->dbConnection->schema->getTable('event_reporting')->getColumn('behavior_tag') == null)
			$this->addColumn('event_reporting', 'behavior_tag', 'string');
		
		try {
			
			$this->createIndex('event_uuid_index', 'event_reporting', 'event_uuid');
				
		} catch (Exception $e) {
		}
	}

	public function down()
	{
		if ($this->dbConnection->schema->getTable('behavior')->getColumn('priority') != null)
			$this->dropColumn('behavior', 'priority');

		if ($this->dbConnection->schema->getTable('behavior')->getColumn('alarm_tag_name') != null)
			$this->dropColumn('behavior', 'alarm_tag_name');		

		if ($this->dbConnection->schema->getTable('event_reporting')->getColumn('behavior_tag') != null)
			$this->dropColumn('event_reporting', 'behavior_tag');
		
		$this->dropIndex('event_uuid_index', 'event_reporting');
		
		return true;
	}

	/*
	// Use safeUp/safeDown to do migration with transaction
	public function safeUp()
	{
	}

	public function safeDown()
	{
	}
	*/
}