<?php

class m141119_080943_create_notification_setting_table extends MyDbMigration
{
  public function up()
  {    
    $this->execute("
        CREATE TABLE notification_setting 
        (
          id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,

          description VARCHAR(255) DEFAULT 'new notification',

          enabled BIT NOT NULL DEFAULT 1,
        
          target_id INTEGER UNSIGNED NOT NULL COMMENT 'id of the user/etc',
          target_type VARCHAR(255) DEFAULT NULL COMMENT 'NULL/user for user, in future will be distribution lists etc',
  
          object_table VARCHAR(255) NOT NULL COMMENT 'table referenec for the object, eg event_reporting',
  
          endpoint_type VARCHAR(255) NOT NULL DEFAULT 'web' COMMENT 'web,mail,app,phone,http...',
          endpoint_address VARCHAR(255) DEFAULT NULL COMMENT 'a specific address, different from the default',
        
          sound BIT NOT NULL DEFAULT 1,
          popup BIT NOT NULL DEFAULT 1,
          level INTEGER NOT NULL DEFAULT 0 COMMENT '-2,-1,0=normal,1,2,3,...',
  
          filter TEXT COMMENT 'filter body,example SQL: plate=\"az123ew\" and id=101,example PHP: plate==\"az123ew\" && id==101',
          filter_type VARCHAR(255) DEFAULT NULL COMMENT 'filter type ---- sql, php, ...?',
        
          epoch DATETIME NOT NULL COMMENT 'insert time',
  
          PRIMARY KEY (id)
        )
        ");
  }

  public function down()
  {
    $this->dropTable("notification_setting");
    return true;
  }

  /*
   // Use safeUp/safeDown to do migration with transaction
  public function safeUp()
  {
  }

  public function safeDown()
  {
  }
  */
}