<?php

class m141119_081026_create_event_reporting_notification_trigger extends MyDbMigration
{

  public function up()
  {    
    $this->execute("
        CREATE TRIGGER event_reporting_notification_trigger AFTER INSERT ON event_reporting
        FOR EACH ROW
        BEGIN
          INSERT INTO notification (setting_id, object_id, status, epoch)
          SELECT n.id, NEW.Id, 'loading', now()
          FROM
          notification_setting n
          WHERE 
          object_table='event_reporting'
          AND
          enabled=1
          ;
        END
        ");
  }

  public function down()
  {
    $this->execute("DROP TRIGGER IF EXISTS event_reporting_notification_trigger");
    return true;
  }

	/*
	// Use safeUp/safeDown to do migration with transaction
	public function safeUp()
	{
	}

	public function safeDown()
	{
	}
	*/
}