<?php

/**
 * This is the model class for table "custom_property_type".
 *
 * The followings are the available columns in table 'custom_property_type':
 * @property integer $id
 * @property string $type
 * @property string $label
 * @property string $description
 * @property integer $is_default
 */
class CustomPropertyType extends ActiveRecord
{

  /**
   * Returns the static model of the specified AR class.
   * 
   * @param string $className
   *          active record class name.
   * @return CustomPropertyType the static model class
   */
  public static function model($className = __CLASS__)
  {
    return parent::model ( $className );
  }

  /**
   *
   * @return string the associated database table name
   */
  public function tableName()
  {
    return 'custom_property_type';
  }

  /**
   *
   * @return array validation rules for model attributes.
   */
  public function rules()
  {
    // NOTE: you should only define rules for those attributes that
    // will receive user inputs.
    return array (
        array (
            'is_default',
            'numerical',
            'integerOnly' => true 
        ),
        array (
            'type, label, description',
            'length',
            'max' => 255 
        ),
        // The following rule is used by search().
        // Please remove those attributes that should not be searched.
        array (
            'id, type, label, description, is_default',
            'safe',
            'on' => 'search' 
        ) 
    );
  }

  /**
   *
   * @return array relational rules.
   */
  public function relations()
  {
    // NOTE: you may need to adjust the relation name and the related
    // class name for the relations automatically generated below.
    return array ();
  }

  /**
   *
   * @return array customized attribute labels (name=>label)
   */
  public function myAttributeLabels()
  {
    return array (
        'id' => 'ID',
        'type' => t ( 'Type' ),
        'label' => t ( 'Label' ),
        'description' => t ( 'Description' ),
        'is_default' => t ( 'Is Default' ) 
    );
  }

  /**
   * Retrieves a list of models based on the current search/filter conditions.
   * 
   * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
   */
  public function search()
  {
    // Warning: Please modify the following code to remove attributes that
    // should not be searched.
    $criteria = new CDbCriteria ();
    
    $criteria->compare ( 'id', $this->id );
    $criteria->compare ( 'type', $this->type, true );
    $criteria->compare ( 'label', $this->label, true );
    $criteria->compare ( 'description', $this->description, true );
    $criteria->compare ( 'is_default', $this->is_default );
    
    return new CActiveDataProvider ( $this, array (
        'criteria' => $criteria 
    ) );
  }
}