<?php

/**
 * This is the model class for table "user_tracking_table".
 *
 * The followings are the available columns in table 'user_tracking_table':
 * @property integer $id
 * @property string $epoch
 * @property string $action
 * @property integer $id_user
 * @property string $table_name
 * @property string $primary_key
 * @property string $controller
 * @property string $data
 * 
 * @property mixed DataValue
 * @property mixed DataValueOld
 */
class UserTrackingTable extends ActiveRecord
{

  public $search_sorting = null;

  /**
   * Returns the static model of the specified AR class.
   *
   * @param string $className
   *          active record class name.
   * @return UserTrackingTable the static model class
   */
  public static function model($className = __CLASS__)
  {
    return parent::model ( $className );
  }

  /**
   *
   * @return string the associated database table name
   */
  public function tableName()
  {
    return 'user_tracking_table';
  }

  /**
   *
   * @return array validation rules for model attributes.
   */
  public function rules()
  {
    // NOTE: you should only define rules for those attributes that
    // will receive user inputs.
    return array (
        array (
            'id_user',
            'numerical',
            'integerOnly' => true 
        ),
        array (
            'action, table_name, primary_key, controller',
            'length',
            'max' => 255 
        ),
        array (
            'data',
            'length',
            'max' => 63000 
        ),
        array (
            'epoch',
            'safe' 
        ),
        // The following rule is used by search().
        // Please remove those attributes that should not be searched.
        array (
            'id, epoch, action, id_user, table_name, primary_key, controller, data',
            'safe',
            'on' => 'search' 
        ) 
    );
  }

  /**
   *
   * @return array relational rules.
   */
  public function relations()
  {
    // NOTE: you may need to adjust the relation name and the related
    // class name for the relations automatically generated below.
    return array ();
  }

  /**
   *
   * @return array customized attribute labels (name=>label)
   */
  public function myAttributeLabels()
  {
    return array (
        'id' => t ( 'ID' ),
        'epoch' => t ( 'Epoch' ),
        'action' => t ( 'Action' ),
        'id_user' => t ( 'Id User' ),
        'table_name' => t ( 'Table name' ),
        'primary_key' => t ( 'Primary Key' ),
        'controller' => t ( 'Controller' ),
        'data' => t ( 'Data' ) 
    );
  }

  /**
   *
   * @return CDbCriteria the data provider that can return the models based on the search/filter conditions.
   */
  public function getSearchCriteria()
  {
    // Warning: Please modify the following code to remove attributes that
    // should not be searched.
    $criteria = new CDbCriteria ();
    
    $criteria->compare ( 'id', $this->id );
    $criteria->compare ( 'epoch', $this->epoch, true );
    $criteria->compare ( 'action', $this->action, true );
    $criteria->compare ( 'id_user', $this->id_user );
    $criteria->compare ( 'table_name', $this->table_name, true );
    $criteria->compare ( 'primary_key', $this->primary_key, true );
    $criteria->compare ( 'controller', $this->controller, true );
    $criteria->compare ( 'data', $this->data, true );
    
    if (! isEmptyOrWhitespace ( $this->search_sorting ))
      $criteria->order = $this->search_sorting;
    
    return $criteria;
  }

  public function search()
  {
    return new CActiveDataProvider ( $this, array (
        'criteria' => $this->getSearchCriteria () 
    ) );
  }

  public function __toString()
  {
    return "USER $this->id_user DO $this->action IN $this->controller TO $this->table_name ITEM $this->primary_key AT $this->epoch";
  }

  public function setDataValue($data)
  {
    $this->data = base64_encode ( gzcompress ( serialize ( $data ) ) );
  }

  public function getDataValue()
  {
    if (isEmpty ( $this->data ))
      return null;
    return unserialize ( gzuncompress ( base64_decode ( $this->data ) ) );
  }

  public function setDataValueOld($data)
  {
    if (isEmpty ( $data ))
      $this->data = null;
    else
      $this->data = base64_encode ( gzcompress ( _2str ( $data ) ) );
  }

  public function getDataValueOld()
  {
    if (isEmpty ( $this->data ))
      return null;
    $code = gzuncompress ( base64_decode ( $this->data ) );
    return eval ( "return $code;" );
  }
}