<?php

/**
 * This is the model class for table "vehicle_category".
 *
 * The followings are the available columns in table 'vehicle_category':
 * @property integer $id
 * @property string $tag
 * @property string $name
 * @property string $description
 * @property string $color
 * @property integer $priority
 */
class VehicleCategory extends ActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VehicleCategory the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vehicle_category';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('priority', 'numerical', 'integerOnly'=>true),
			array('tag, name, description, color', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, tag, name, description, color, priority', 'safe', 'on'=>'search'),
		);
	}
	
	
	
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function myAttributeLabels()
	{
		return array(
			'id' => 'ID',
			'tag' => 'Tag',
			'name' => 'Name',
			'description' => 'Description',
			'color' => 'Color',
			'priority' => 'Priority',
		);
	}
	public function scopes()
	{
		return array(
				'withColor'       => array('condition' => 'color is not null'),
		);
	}
	public function byCategory($categories)
	{
		if(!is_array($categories))
			$categories = array($categories);
		
		$this->getDbCriteria()->addInCondition('tag', $categories);
		
		return $this;	
	}
	
	public function orderByPriority()
	{
		$this->getDbCriteria()->order = 'priority asc';
		 
		return $this;
	}

	public static function getBestColorForCategories($categories)
	{
		
		$res = VehicleCategory::model()->byCategory($categories)->orderByPriority()->withColor()->find();
				if(is_null($res))
			return null;

		return $res->color;
	}
	public function getCategoryList()
	{
	
		$res = VehicleCategory::model()->findAll();
		if(is_null($res))
			return null;
		
		$arr = array();
		if(!is_array($res))
			$res = array($res);
			
		foreach($res as $cV)
			$arr[$cV->tag] = $cV->name;
		
		return $arr;
	}
	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('tag',$this->tag,true);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('color',$this->color,true);
		$criteria->compare('priority',$this->priority);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}