<?php 

$gates = Gate::getGateList();
$yesno = array('0' => t('No'),'1' => t('Yes'));
$speedUnits = array('km/h' => t('km/h'),'mph' => t('mph'));

$form=$this->beginWidget('bootstrap.widgets.TbActiveForm',array(
    'id'=>'section-form',
    'enableAjaxValidation'=>false,
)); ?>

<p class="help-block">
  <?php echo(t('Fields with <span class="required">*</span> are required.')); ?>
</p>

<?php

//$form = new TbActiveForm();

echo $form->errorSummary($model);

echo $form->textFieldRow($model,'name',array('class'=>'span5','maxlength'=>45));

echo $form->textFieldRow($model,'description',array('class'=>'span5','maxlength'=>255));

echo $form->dropDownListRow($model,'id_gate_start',$gates, array('class'=>'span5','maxlength'=>20));

echo $form->dropDownListRow($model,'id_gate_end',$gates, array('class'=>'span5','maxlength'=>20));

echo $form->dropDownListRow($model,'enabled',$yesno,array('class'=>'span5'));

echo $form->textFieldRow($model,'road_length',array('class'=>'span5'));

echo $form->textFieldRow($model,'road_speed_limit',array('class'=>'span5'));

echo $form->textFieldRow($model,'road_speed_threshold',array('class'=>'span5'));

echo $form->dropDownListRow($model,'road_speed_limit_unit',$speedUnits,array('class'=>'span5','maxlength'=>30));
/*
 echo $form->textFieldRow($model,'filter_gate_start',array('class'=>'span5','maxlength'=>10));

echo $form->textFieldRow($model,'filter_gate_end',array('class'=>'span5','maxlength'=>10));
*/
echo $form->textFieldRow($model,'discard_delta',array('class'=>'span5'));

echo $form->textFieldRow($model,'final_discard_delta',array('class'=>'span5'));
/*
 echo $form->textFieldRow($model,'last_event_time',array('class'=>'span5'));

echo $form->textFieldRow($model,'last_event_id',array('class'=>'span5','maxlength'=>20));

echo $form->textFieldRow($model,'epoch',array('class'=>'span5'));
*/

$classes = paramdeep('section','classLimits');

if($classes !== false)
{

  if(!is_array_ex($classes))
    $classes = VehicleTypes::localizedMotored();

  ?>

<h3>
  <?php echo t('Limits for class'); ?>
</h3>
<?php echo(t("(leaving the empty value = limit not considered)")); ?>
<table class="table table.condensed">
  <thead>
    <tr>
      <th><?php echo t('Class'); ?></th>
      <th><?php echo t('Road Speed Limit'); ?></th>
      <th><?php echo t('Road Speed Threshold'); ?></th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <?php 
    foreach($classes as $className => $classLabel)
    {
      $htmlid = createVarName($className);
      echo("<tr>");
      echo("<td>$classLabel</td>");
      echo("<td>".CHtml::textField("ClassLimit[{$className}]", $classLimit[$className], array('class'=>'span1', 'id'=>"limit_$htmlid"))."</td>");
      echo("<td>".CHtml::textField("ClassThreshold[{$className}]", $classThreshold[$className], array('class'=>'span1', 'id'=>"threshold_$htmlid"))."</td>");
      echo("<td><a onclick=\"$('#limit_$htmlid').val(''); $('#threshold_$htmlid').val('');\">x</a></td>");
      echo("</tr>");
    }
    ?>
  </tbody>
</table>

<?php 
}
?>

<div class="form-actions">
  <?php $this->widget('bootstrap.widgets.TbButton', array(
      'buttonType'=>'submit',
      'type'=>'primary',
      'label'=>$model->isNewRecord ? 'Create' : 'Save',
		)); ?>
</div>

<?php $this->endWidget(); ?>
