<?php
$this->breadcrumbs=array(
    'Sections'=>array('index'),
    $model->name,
);

$this->menu=array(
    array('label'=>'List Section','url'=>array('index')),
    array('label'=>'Create Section','url'=>array('create')),
    array('label'=>'Update Section','url'=>array('update','id'=>$model->id)),
    array('label'=>'Delete Section','url'=>'#','linkOptions'=>array('submit'=>array('delete','id'=>$model->id),'confirm'=>'Are you sure you want to delete this item?')),
    array('label'=>'Manage Section','url'=>array('admin')),
);
?>

<h1>
  View Section #
  <?php echo $model->id; ?>
</h1>

<?php $this->widget('bootstrap.widgets.TbDetailView',array(
    'data'=>$model,
    'attributes'=>array(
        'id',
        'name',
        'description',
        array('name'=>'id_gate_start','type'=>'raw','value'=>SystemInfoHelper::getGateCoolName($model->id_gate_start,true,true,true,true)),
        array('name'=>'id_gate_end','type'=>'raw','value'=>SystemInfoHelper::getGateCoolName($model->id_gate_end,true,true,true,true)),
        array('name'=>'enabled','type'=>'raw','value'=>SystemInfoHelper::getFullSwitchButtonLabel("section", "switchEnabled", $model->id, $model->enabled, "Yes","No","green","red",app()->controller->getAbsoluteUrl(),"icon-off")),
        array('name'=>'road_length','type'=>'raw','value'=>$model->road_length." ".($model->road_speed_limit_unit=="km/h" ? "km" : "mi")),
        array('name'=>'road_speed_limit','type'=>'raw','value'=>$model->road_speed_limit." ".$model->road_speed_limit_unit),
        array('name'=>'road_speed_threshold','type'=>'raw','value'=>$model->road_speed_threshold." ".$model->road_speed_limit_unit),
        array('name'=>'Tolerance', 'type'=>'raw','value'=>$model->Tolerance." %"),
        array('name'=>'discard_delta', 'type'=>'raw','value'=>DateIntervalEnhanced::getFormattedFromString('+'.intval($model->discard_delta*60*60).' seconds')),
        array('name'=>'final_discard_delta', 'type'=>'raw','value'=>DateIntervalEnhanced::getFormattedFromString('+'.intval($model->final_discard_delta*60*60).' seconds')),
        'filter_gate_start',
        'filter_gate_end',
        'last_event_time',
        'last_event_id',
        'epoch',
    ),
)); ?>

<h3>
  <?php echo t('Limits'); ?>
</h3>
<table class="table table.condensed">
  <thead>
    <tr>
      <th><?php echo t('Class'); ?></th>
      <th><?php echo t('Road Speed Limit'); ?></th>
      <th><?php echo t('Road Speed Threshold'); ?></th>
      <th><?php echo t('Tolerance'); ?></th>
    </tr>
  </thead>
  <tbody>
    <?php 
    foreach($model->limits as $limit)
    {
      echo("<tr>");
      echo("<td>".t($limit->class)."</td>");
      echo("<td>$limit->road_speed_limit</td>");
      echo("<td>$limit->road_speed_threshold</td>");
      echo("<td>$limit->Tolerance %</td>");      
      echo("</tr>");
    }
    ?>
  </tbody>
</table>
