<?php

require_once 'globals.php';

class InstallCheckCommand extends CConsoleCommand
{
    private $bck_dir = "d:/backupGUI";
    private $main;
    private $mode_development;
    private $mode_production;
    private $mode_staging;
    private $mode_test;
   
    private $local;
    private $runtime;

    private $match_template;
    private $match = [];
    private $path = [];

    private $error_report;
    private $date ;

    public function run($args)
    {

        echo "\n########################################################################################";
        echo "\n##                                                                                    ##";
        echo "\n##                                     Install Check                                  ##";
        echo "\n##                              rev 0.1 date 13.02.2019                               ##";
        echo "\n##                                                                                    ##";
        echo "\n########################################################################################";
        echo "\n";
        echo "\n";

        //var_dump($args);
        $this->date = new DateTime;
        if (sizeof($args) < 1) {
					echo "Usage:\n";
					echo "\n\tyiic installcheck --config --user";
					echo "\n\tyiic installcheck --config=all --user\n\n";
				}
				
        foreach ($args as $arg) {
            switch ($arg) {
                case "--config":
                    echo "\nStart Config Diff Check\n";
                    $this->config(false);
                    $this->backupConfig(array("main","mode_development","mode_production","mode_staging","mode_test","local"));
                    break;
                case "--config=all":
                    echo "\nStart Config Diff Check\n";
                    $this->config(true);
                    break;
                case "--user":
                    echo "\n\nStart Config User Assignment Check\n";
                    $this->configUser();
                    break;
                default:
					echo "Usage:\n";
					echo "\n\tyiic installcheck --config --user";
                    echo "\n\tyiic installcheck --config=all --user\n\n";
                    break;
            }
        }

    }

    private function createDirBackup(){
    if(!is_dir($this->bck_dir."/".$this->date->format('YmdHis'))){
        
        if(!is_dir($this->bck_dir)){

            if(mkdir($this->bck_dir))
            {
                echo "\nCreated directory ".$this->bck_dir;

            }else{
                echo "\n\nUnable to create directory ".$this->bck_dir;
                die;
            }

        }
        if(mkdir($this->bck_dir."/".$this->date->format('YmdHis'))){
            echo "\nCreated directory ".$this->bck_dir."/".$this->date->format('YmdHis');
        }else{
            echo "\n\nUnable to create directory". $this->date->format('YmdHis');
                die;
        }
        return 1;
    }else{
        return 1;
    }

    }

    private function configUser(){
        if($this->createDirBackup()){
        
        echo("\nPlease Insert Db Password\n");
        exec("mysqldump --user kria -p eventserverdb authitemchild authitem > ".$this->bck_dir."/".$this->date->format('YmdHis')."/authitemchild.bck.sql");

        /*exec("mysqlimport.exe -user kria -p eventserverdb authitemchild_bck.sql");*/
        //Yii::app()->db->createCommand($sql)->execute();
        }

    }

    private function backupConfig($list_of_file){
        echo "\n\nBackup Config File\n";
        
        if($this->createDirBackup()){

        foreach($list_of_file as $filename){
            
            

            echo "\nCopying ".dirname(__FILE__)."/../config/".$filename.".php to ".$this->bck_dir."/".$this->date->format('YmdHis')."/".$filename.".php";
            if(!copy(dirname(__FILE__)."/../config/".$filename.".php",$this->bck_dir."/".$this->date->format('YmdHis')."/".$filename.".php")){
                echo "\nError writing ".$filename.".php to ".$this->bck_dir."/".$this->date->format('YmdHis')."/".$filename.".php";
                die;
            }
            echo "\nDone...";
            
            $string ="<?php /*Automatic Generated [".$filename.".php] Process: yiic installcheck ".$this->date->format('Y-m-d H:i:s')."*/";
            $string .="\n return ";
            switch($filename) {
                
                case "main":
                $string .= var_export($this->main,true);
                break;
                case "mode_development":
                $string .= var_export($this->mode_development,true);
                break;
                case "mode_production":
                $string .= var_export($this->mode_production,true);
                break;
                case "mode_staging":
                $string .= var_export($this->mode_staging,true);
                break;
                case "mode_test":
                $string .= var_export($this->mode_test,true);
                break;
                case "local":
                $string .= var_export($this->local,true);
                break;
            }
            
            $string .= ";";
            $string = str_replace('\'C:\\\KRIA\\\htdocs\\\evserv\\\protected\\\config',"dirname(__FILE__).'",$string);
            $string = str_replace('/C:\\\KRIA\\\htdocs\\\evserv\\\protected\\\config',"/'.dirname(__FILE__).'",$string);
            //echo $string;
            $string ="";

        }
        }
    }

    private function config($param)
    {
        $main_filename = Yii::app()->getBasePath() . "/config/main.php";
        $mode_development_filename = Yii::app()->getBasePath() . "/config/mode_development.php";
        $mode_production_filename = Yii::app()->getBasePath() . "/config/mode_production.php";
        $mode_staging_filename = Yii::app()->getBasePath() . "/config/mode_staging.php";
        $mode_test_filename = Yii::app()->getBasePath() . "/config/mode_test.php";
        $local_filename = Yii::app()->getBasePath() . "/config/local.php";
        $runtime_filename = Yii::app()->getBasePath() . "/config/runtime.php";

        $this->def_config_array();

        if (file_exists($main_filename)) {
            $main = (include $main_filename);
            echo "\n-------------------------\t**************************************************************\t-------------------------\n";
            echo "\nLoading Main Config file: OK\n";

            $this->match($main, $this->main, "main.php", true);

        } else { $str = "\n-------------------------\t[Error]" . $main_filename . " doesn't exist. IMMEDIATELY REPORT ISSUE\t-------------------------\n";
            $this->error_report['main.php'][] = $str;
            echo $str;
        }

        if (file_exists($mode_development_filename)) {
            $mode_development = (include $mode_development_filename);
            echo "\n-------------------------\t**************************************************************\t-------------------------\n";
            echo "\nLoading Mode Development Config file: OK\n";

            $this->match($mode_development, $this->mode_development, "mode_development.php", true);

        } else { $str = "\n-------------------------\t[Error]" . $mode_development_filename . " doesn't exist.\t-------------------------\n";
            $this->error_report['mode_development.php'][] = $str;
            echo $str;
        }

        if (file_exists($mode_production_filename)) {
            $mode_production = (include $mode_production_filename);
            echo "\n-------------------------\t**************************************************************\t-------------------------\n";
            echo "\nLoading Mode Production Config file: OK\n";

            $this->match($mode_production, $this->mode_production, "mode_production.php", true);

        } else { $str = "\n-------------------------\t[Error]" . $mode_production_filename . " doesn't exist. IMMEDIATELY REPORT ISSUE\t-------------------------\n";
            $this->error_report['mode_production.php'][] = $str;
            echo $str;}

        if (file_exists($mode_staging_filename)) {
            $mode_staging = (include $mode_staging_filename);
            echo "\n-------------------------\t**************************************************************\t-------------------------\n";
            echo "\nLoading Mode Staging Config file: OK\n";

            $this->match($mode_staging, $this->mode_staging, "mode_staging.php", true);

        } else { $str = "\n-------------------------\t[Error]" . $mode_staging_filename . " doesn't exist\t-------------------------\n";
            $this->error_report['mode_staging.php'][] = $str;
            echo $str;}

        if (file_exists($mode_test_filename)) {
            $mode_test = (include $mode_test_filename);
            echo "\n-------------------------\t**************************************************************\t-------------------------\n";
            echo "\nLoading Mode Test Config file: OK\n";

            $this->match($mode_test, $this->mode_test, "mode_test.php", true);

        } else { $str = "\n-------------------------\t[Error]" . $mode_test_filename . " doesn't exist\t-------------------------\n";
            $this->error_report['mode_test.php'][] = $str;
            echo $str;}

        if (file_exists($local_filename)) {
            $local = (include $local_filename);
            echo "\n-------------------------\t**************************************************************\t-------------------------\n";
            echo "\nLoading Config file: OK\n";

            $this->match($local, $this->local, "local.php", true);

        } else { $str = "\n-------------------------\t[Error] " . $local_filename . " doesn't exist.\t-------------------------\n";
            $this->error_report['local.php'][] = $str;
            echo $str;}

        if (file_exists($runtime_filename)) {
            $runtime = (include $runtime_filename);
            echo "\n-------------------------\t**************************************************************\t-------------------------\n";
            echo "\nLoading Runtime Config file: OK\n";

            $this->match($runtime, $this->runtime, "runtime.php", $param);

        } else { $str = "\n-------------------------\t[Error]" . $runtime_filename . " doesn't exist. IMMEDIATELY REPORT ISSUE\t-------------------------\n";
            $this->error_report['runtime.php'][] = $str;
            echo $str;}

            echo "\n\n\t\tConfig File Merge and Execution Order";
            echo "\n\nmain.php -> mode_XXXX.php [XXXX - YII_ENVIRONMENT] -> local.php -> logger_*.php -> runtime.php -> debug.php \n\n";
            echo "\n\nScript Summary\n\n";
            print_r($this->error_report);

    }

    private function match($conf1, $conf2, $filestring, $print)
    {

        echo "\n-------------------------\t" . $filestring . " File Comparison from Original to Template\t-------------------------\n";

        $obj = $this->compare($conf1, $conf2, $filestring);
        $obj1 = $this->compare($conf2, $conf1, $filestring, "[Template]", "[Local]");
        if (is_array($obj) && is_array($obj1)) {

            if ($obj == $obj1) {

                echo "\nFiles have the same schema but some value are different.\n";
                if ($filestring === "main.php" || $filestring === "mode_production.php" || $filestring === "mode_development.php") {
                    echo "\nThis file shouldn't be different from template. REPORT ISSUE\n\n";
                    $this->error_report[$filestring][] = "\t\t --------- Priority High - Error: This file shouldn't be different from template. REPORT ISSUE";
                }
                if ($print) {
                    echo "Original = Local Config File , Template = Template Config File\n\n";

                    $this->print_compare($obj);
                }
                $this->error_report[$filestring][] = "\t\t --------- Priority Low - Values are different, check it according to system behavior";

            } else {
                echo "\nFiles don't have the same schema, please check the file\n";
                if ($print) {
                    echo "\nOriginal = Local Config File , Template = Template Config File\n\n";
                    echo "\nLocal Match printing\n\n";
                    $this->print_compare($obj);
                    echo "\nTemplate Match print\n\n";
                    $this->print_compare($obj1);
                }
                $this->error_report[$filestring][] = "\t\t --------- Priority High - Both Values and Schemas are different, check it according to system behavior and REPORT ISSUE";
            }

        } else {

            echo "\nFiles have the same schema and all values are the same.\n\n";

        }

    }

    private function compare($original, $destination, $filestring, $or = "[Local]", $dest = "[Template]")
    {
        $this->match = [];
        $obj = $this->compare_two_object_recursive($original, $destination, $or, $dest);
        //    print_r($obj);
        $this->onlyDiff($obj);
        $match_temp = $this->match;

        foreach ($match_temp as $ke => $val) {
            $str = "";

            $diff[$ke] = $this->array_search_path($val, $obj);

            if (is_array($diff[$ke])) {

                foreach ($diff[$ke] as $path) {

                    $str .= "['$path']";

                }
                $str = 'unset($obj' . $str . ');';
                //echo "\n".$str."\n";
                eval($str);

            }

            if ($val === "NULL") {
                $diff[$ke][] = " |----------------------> MISSED";

                $this->error_report[$filestring][$diff[$ke][(sizeof($diff[$ke]) - 4)]] = "Missed Values found, check it according to system behavior and REPORT ISSUE";

            } else {
                $diff[$ke][] = $val;
            }
            //print_r($diff[$ke]);
        }

        return $diff;

    }

    private function print_compare($diff)
    {
        foreach ($diff as $values) {
            $string = "";
            foreach ($values as $value) {
                if ($value !== "diff") {
                    if (!isset($value)) {
                        // echo " -> MISSED\t----------------------------------------\n";
                    } else {
                        echo " -> " . $value;
                    }

                }
            }
            echo "\n";
        }
    }

    private function onlyDiff($obj)
    {
        if (!is_array($obj)) {
            //    echo '|--->OnlyDiff: '.strval($obj)."\t\t";

            $this->match[] = $obj;

            return;
        }

        foreach ($obj as $k => $value) {
            //if (strval($k) != "match") {
            //printAll($k);
            $this->onlyDiff($value);
            //}
        }

    }

    private function array_search_path($needle, array $haystack, array $path = [])
    {
        foreach ($haystack as $key => $value) {
            $currentPath = array_merge($path, [$key]);
            if (is_array($value) && $result = $this->array_search_path($needle, $value, $currentPath)) {

                return $result;
            } else if ($value === $needle) {
                //echo $result;
                return $currentPath;
            }
        }

        return false;
    }

    private function compare_two_object_recursive($object_1, $object_2, $object_1_Identifier = false, $object_2_Identifier = false)
    {
        $object1 = (array) $object_1;
        $object2 = (array) $object_2;
        $object3 = array();

        $o1i = $object_1_Identifier ? $object_1_Identifier : 1;
        $o2i = $object_2_Identifier ? $object_2_Identifier : 2;

        foreach ($object1 as $key => $value) {
            if (is_object($object1[$key])) {
                $object1[$key] = (array) $object1[$key];
                $object2[$key] = (array) $object2[$key];
                $object3[$key] = (object) $this->compare_two_object_recursive($object1[$key], $object2[$key], $o1i, $o2i);
            } elseif (is_array($object1[$key])) {
                $object3[$key] = $this->compare_two_object_recursive($object1[$key], $object2[$key], $o1i, $o2i);
            } else {
                if ($object1[$key] == $object2[$key]) {
                    //$object3[$key]['match'] = $object1[$key];
                } else {
                    if ($o1i === "[Local]") {
                        $object3[$key]['diff'][$o1i] = var_export($object1[$key], true);
                        $object3[$key]['diff'][$o2i] = var_export($object2[$key], true);
                    } else {
                        $object3[$key]['diff'][$o2i] = var_export($object2[$key], true);
                        $object3[$key]['diff'][$o1i] = var_export($object1[$key], true);

                    }

                }
            }
        }
        return $object3;
    }

    private function def_config_array()
    {

        $this->main = array(
            'yiiPath' => 'C:\KRIA\htdocs\evserv\protected\config/../../../yii/framework/yii.php',
            'yiicPath' => 'C:\KRIA\htdocs\evserv\protected\config/../../../yii/framework/yiic.php',
            'yiitPath' => 'C:\KRIA\htdocs\evserv\protected\config/../../../yii/framework/yiit.php',
            'yiiDebug' => true,
            'yiiTraceLevel' => 0,
            // Static function Yii::setPathOfAlias()
            'yiiSetPathOfAlias' => array(
                'bootstrap' => 'C:\KRIA\htdocs\evserv\protected\config/../extensions/bootstrap',
                'protected' => 'C:\KRIA\htdocs\evserv\protected\config/../',
            ),

            'configWeb' => array(
                'basePath' => 'C:\KRIA\htdocs\evserv\protected\config/..',
                'name' => 'Event Server',
                'sourceLanguage' => 'en',
                'language' => 'it',
                'defaultController' => 'dashboard',
                'preload' => array(
                    'log',
                ),
                // autoloading model and component classes
                'import' => array(
                    'application.enums.*',
                    'application.models.*',
                    'application.controllers.*',
                    'application.presenters.*',
                    'application.services.*',
                    'application.repositories.*',
                    'application.queries.*',
                    'application.components.*',
                    'application.helpers.*',
                    'application.vendor.*',
                    'ext.PHPExcelLib.*',
                    'ext.JsTrans.*',
                    'ext.ECSVExport.*',
                    'ext.bootstrap.widgets*',
                    'ext.efeed.*',
                    'ext.dynamictabularform.*',
                ),

                'modules' => array(
                    'auth' => array(
                        'strictMode' => true, // when enabled authorization items cannot be assigned children of the same type.
                        'userClass' => 'User', // the name of the user model class.
                        'userIdColumn' => 'id', // the name of the user id column.
                        'userNameColumn' => 'username', // the name of the user name column.
                        'appLayout' => 'application.views.layouts.main', // the layout used by the module.
                        'viewDir' => null,
                    ),
                ), // the path to view files to use with this module.
                'components' => array(
                    'user' => array(
                        'class' => 'auth.components.AuthWebUser',
                        'allowAutoLogin' => false,
                        'autoUpdateFlash' => false,
                        'loginUrl' => array(
                            'session/login',
                        ),
                        'loginRequiredAjaxResponse' => 'Error, login required',
                    ),
                    'viewRenderer' => array(
                        'class' => 'ext.yii-mthaml.CMtHamlViewRenderer',
                    ),
                    'bootstrap' => array(
                        'class' => 'bootstrap.components.Bootstrap',
                    ),
                    'urlManager' => array(
                        'urlFormat' => 'path',
                        'showScriptName' => false,
                        'rules' => array(
                            '<controller:\w+>/<id:\d+>' => '<controller>/view',
                            '<controller:\w+>/<action:\w+>/<id:\d+>' => '<controller>/<action>',
                            '<controller:\w+>/<action:\w+>' => '<controller>/<action>',
                        ),
                    ),
                    'authManager' => array(
                        'class' => 'CDbAuthManager',
                        'connectionID' => 'db',
                        'itemTable' => 'authitem',
                        'itemChildTable' => 'authitemchild',
                        'assignmentTable' => 'authassignment',
                        'behaviors' => array(
                            'auth' => array(
                                'class' => 'auth.components.AuthBehavior',
                                'admins' => array(),
                            ),
                        ),
                    ), // users with full access
                    'errorHandler' => array(
                        'errorAction' => 'site/error',
                    ),
                    'mutex' => array(
                        'class' => 'ext.EMutex',
                    ),

                    'log' => array(
                        'class' => 'CLogRouter',
                        'routes' => array(
                            "application" => array(
                                'class' => 'CFileLogRoute',
                                'levels' => 'error, warning, profile',
                            ),
                            "info" => array(
                                'class' => 'CFileLogRoute',
                                'logFile' => 'info.log',
                                'levels' => 'info',
                            ),
                            "db" => array(
                                'class' => 'CFileLogRoute',
                                'levels' => 'info',
                                'categories' => 'system.db.*',
                                'logFile' => 'sql.log',
                            ),
                            //                    "debugtoolbar" => array(
                            //                        'class' => 'ext.yii-debug-toolbar.YiiDebugToolbarRoute',
                            //                    ),
                        ),
                    ),
                    'request' => array(
                        'enableCookieValidation' => true,
                        'class' => 'HttpRequest',
                    ),
                    'session' => array(
                        'class' => 'CDbHttpSession',
                        'connectionID' => 'db',
                        'autoCreateSessionTable' => false,
                        'sessionTableName' => 'yii_session',
                        'timeout' => (60 * 60 * 8), // 8 ore
                        'cookieMode' => 'only',
                    ),
                    'currentWorkPeriod' => array(
                        'class' => 'CurrentWorkPeriod',
                    ),
                    'currentSession' => array(
                        'class' => 'CurrentSession',
                    ),
                    'curl' => array(
                        'class' => 'ext.Curl',
                    ),
                    // 'options' => array(/.. additional curl options ../)
                    'messages' => array(
                        'class' => 'P3PhpMessageSource',
                        'mappings' => array(
                            'de_de' => 'de',
                            'de_at' => 'de',
                            'de_ch' => 'de',
                            'fr_ch' => 'fr',
                            'it_ch' => 'it',
                        ),
                    ),
                ),
                'params' => array(
                    'db' => array(
                        'cache' => array(
                            'enabled' => false,
                            'types' => array(
                                'Bookmark',
                                'PlateCountry',
                                'Service',
                                'Gate',
                                'Ztl',
                                'PlateList',
                                'PlateAuthInsertProfile',
                                'TimeSchedule',
                                'GateSet',
                                'GateGroup',
                                'MediaAttachment',
                                'Event',
                            ),
                        ),
                    ),
                    'translator' => array(
                        'enabled' => true,
                    ),
                    'payslip' => array(
                        'showButton' => false,
                    ),
                    'report' => array(
                        'showPreviewButton' => true,
                        'byWorkPeriod' => true,
                        'completeService' => false,
                        'events' => array(
                            'order' => ' id_group ASC, StartTime ASC ',
                            'removeDefaultScope' => true,
                        ),
                    ),
                    'classes' => array(
                        'vehicles' => array('c1' => 'Vehicle', 'c2' => 'Truck', 'c3' => 'Articulated lorry', 'c4' => 'Bus', 'c5' => 'Motorcycle', 'c6' => 'Motor-scooter'),
                        'others' => array('c1' => 'Person'),
                        'forValidation' => array('c1' => 'Vehicle', 'c2' => 'Truck', 'c3' => 'Articulated lorry', 'c4' => 'Bus', 'c5' => 'Motorcycle', 'c6' => 'Motor-scooter'),
                    ),
                    'section' => array(
                        'classLimits' => 'default',
                    ), // false=disabled, 'default'=default classes, array('class1','class2',...)=specified classes
                    'video' => array(
                        'enabledRefreshDivButton' => false,
                    ),
                    'service' => array(
                        'paginationSize' => 20,
                    ),
                    'security' => array(
                        'user_tracking' => array(
                            'enabled' => true,
                            'pagination' => 50,
                            'exclude_tables' => array(
                                'user_tracking_table',
                                'work_periods',
                            ),
                            'data_tracked_table' => array(),
                        ),
                        'ipFilter' => array(
                            'enabled' => false,
                            'allow' => array(), // empty = all
                            'deny' => array(), // empty = none/*=all
                            'allowOverDeny' => true,
                        ), // false=deny overrides allow - true=allow overrides deny
                        'logFile' => 'C:\KRIA\htdocs\evserv\protected\config/../runtime/security.log',
                        'logContext' => array(
                            'app',
                            'login',
                            '401',
                        ), // VALORI: app login 401 actions
                        'logStack' => true,
                        'logActions' => array(
                            'bypass' => array(
                                'alert/summary',
                                'gatesstatus/viewviolationsstable',
                                'gatesstatus/viewgatelist',
                                'stats/statusbox',
                                'gatesstatus/viewalertstable',
                                'system/statusbox',
                                'event/statusbox',
                                'dashboard/viewservices',
                            ), // LOWERCASE - le azioni da non loggare (ovvero quelle di aggiornamento dati)
                            'specific' => array(), // LOWERCASE - se contiene elementi 'logActionsBypass' viene ignorato e vengono loggate SOLO le azioni specificate
                            'requestData' => array(
                                'search/index',
                                'event/admin',
                                'vehicletrace/admin',
                                'alert/search',
                                'plateauthorization/index',
                                'plateauthorization/whiteliststatus',
                                'plateList/*',
                                'plateauthorization/newblacklist',
                                'plateauthorization/newwhitelist',
                                'plateauthorization/whitelistwizard',
                                'plateauthorization/whitelistwizarddelete',
                                'vehicleowner/*',
                                'vehicle/*',
                                'plateauthorization/revoke',
                                'plateauthorization/renew',
                                'user/*',
                                'fastassign/*',
                                'assignment/*',
                                'role/*',
                                'operation/*',
                                'task/*',
                                'configuration/*',
                            ),
                        ),
                        'send_export_registration' => false,
                        'export_expiry_date_check' => false,
                    ), // LOWERCASE - dice quando vanno loggati i dati delle richieste
                    'photoBaseLocationByUrl' => false,
                    'photoBaseUrl' => '/kria-photos',
                    'photoBasePath' => 'D:\mysql\data',
                    'support' => array(
                        'visible_to_guest' => true,
                        'visible_to_user' => true,
                        'email' => array(
                            'general' => 'info@kria.biz',
                            'commercial' => 'sales@kria.biz',
                            'support' => 'support@kria.biz',
                            'admin' => 'admin@kria.biz',
                        ),
                    ),
                    'plateList' => array(),
                    'plateAuthorizations' => array(
                        'scheduler' => array(
                            'hotelMode' => true,
                            'softMode' => true,
                            'additionalWeeksBeforeMonth' => 2,
                            'additionalWeeksAfterMonth' => 2,
                        ),
                        'expirationTimeoutWarning' => '7 days',
                        'expirationTimeoutCritical' => '12 hours',
                        'aboutToExpireTimeout' => '1 month',
                        'tabularasa' => array(
                            'password' => 'ab173b7560cf37726aee0b47440ea1af',
                            'allowed' => true,
                        ),
                        'viewGoToWizardLink' => true,
                        'print' => array(
                            'link' => array(
                                'direct' => false, // default: false, se diretta newPage e popup vengono ignorate
                                'newPage' => true, // default: true, se false popup viene ignorato
                                'popup' => true,
                            ),
                        ), // default: true, se true apre un popup altrimenti una nuova finestra del browser altrimenti
                        'customValidityPeriods' => array(),
                        'vehicleSources' => array(), // se vuota, campo libero
                        'printLayout' => '',
                        'validityPeriodType' => array(
                            'Fisso' => 'Fisso',
                        ),
                        'types' => array(),
                        'default' => array(
                            'name' => '',
                            'surname' => '',
                            'gate' => '-1',
                            'time' => '-1',
                            'validityPeriodDescription' => '',
                            'validityPeriodType' => 'Fisso',
                            'plateAuthDescription' => '',
                            'plateAuthType' => '-',
                            'plateAuthAction' => '',
                            'plateAuthNote' => '',
                            'vehicleSource' => '',
                        ),
                        'rapidInsert' => array(
                            // veicolo
                            'hideVehicleModel' => false,
                            'hideVehicleType' => false,
                            // permit
                            'hideAuthType' => false,
                            // contatto
                            'hideEmail' => false,
                            'hidePhone' => false,
                            'hideAddress' => false,
                            'hideCity' => false,
                            // altre info
                            'hideSource' => false,
                            'hideAction' => false,
                            'hideNote' => false,
                        ),
                        'autocomplete' => array(
                            'note' => array(
                                'enabled' => true,
                                'table' => true,
                                'custom' => array(),
                            ),
                        ),
                    ),
                    'datetimeselect_format' => array(
                        'it' => array(
                            'view' => 'dd/MM/yyyy hh:mm',
                            'php' => 'd/m/Y H:i',
                        ),
                        'it_ch' => array(
                            'view' => 'dd/MM/yyyy hh:mm',
                            'php' => 'd/m/Y H:i',
                        ),
                        'en' => array(
                            'view' => 'MM/dd/yyyy hh:mm',
                            'php' => 'm/d/Y H:i',
                        ),
                    ),
                    'dateselect_format' => array(
                        'it' => array(
                            'view' => 'dd/MM/yyyy',
                            'php' => 'd/m/Y',
                        ),
                        'it_ch' => array(
                            'view' => 'dd/MM/yyyy',
                            'php' => 'd/m/Y',
                        ),
                        'en' => array(
                            'view' => 'MM/dd/yyyy',
                            'php' => 'm/d/Y',
                        ),
                    ),
                    'dayoftheyearselect_format' => array(
                        'it' => array(
                            'view' => 'dd/MM',
                            'php' => 'd/m',
                        ),
                        'it_ch' => array(
                            'view' => 'dd/MM',
                            'php' => 'd/m',
                        ),
                        'en' => array(
                            'view' => 'MM/dd',
                            'php' => 'm/d',
                        ),
                    ),
                    'timeselect_format' => array(
                        'it' => array(
                            'view' => 'hh:mm',
                            'php' => 'H:i',
                        ),
                        'it_ch' => array(
                            'view' => 'hh:mm',
                            'php' => 'H:i',
                        ),
                        'en' => array(
                            'view' => 'hh:mm',
                            'php' => 'H:i',
                        ),
                    ),
                    'pdfRepositoryBaseFolder' => 'D:\PDF\\',
                    'imageExportBaseFolder' => 'D:\EXPORTED_IMAGES\\',
                    'gate_status_refresh_time' => 60000,
                    'system_status_refresh_time' => 60000,
                    // To create self-signed signature: openssl req -x509 -nodes -days 365000 -newkey rsa:1024 -keyout tcpdf.crt -out tcpdf.crt
                    // file:// DEVE ESSERCI!
                    'exportPdfCertificate' => 'file://C:\KRIA\htdocs\evserv\protected\config/cert/kria.crt', // file://C:\temp\tmpcrt\tcpdf.crt',
                    'exportPdfCertificatePassword' => kria_load_secret('exportPdfCertificatePassword'),
                    'passwordExpirationNotification' => 7,
                    'publicPages' => array(
                        'system/setup',
                        'system/repair',
                        'site/error',
                        'alert/rss',
                        'session/login',
                        'session/refreshpassword',
                        'webImageAccess/Index',
                        'webImageAccess/EventInfo',
                        'webImageAccess/EventImage',
                        'api/*',
                        'ws/*',
                        'support/*',
                        'maintenanceMode/*',
                    ),
                    'webImageAccess' => array(
                        'BaseFolder' => 'D:\ES_WEB_SERVICE\\',
                        'defaultTopMargin' => 500,
                        'defaultBottomMargin' => 300,
                        'defaultLeftMargin' => 400,
                        'defaultRightMargin' => 400,
                        'defaultBottomBandSize' => 48,
                    ),
                    'logos' => array(
                        'login' => 'logo-kria-high.gif',
                        'report' => '',
                    ),
                    'logosStyles' => array(
                        'login' => '',
                        'report' => '',
                    ),
                    'appTitles' => array(
                        'main_title' => null,
                        'main_title_is_html' => false,
                        'sub_title' => 'Sistema video di rilevamento e identificazione dei veicoli',
                        'sub_title_is_html' => false,
                    ),
                    'spotSpeedViolation' => array(
                        'fixedTolerance' => 5,
                        'percentageTolerance' => 0.05,
                        'toleranceTable' => array(),
                    ),
                    // array('minSpeed'=> 0, 'maxSpeed'=> 100, 'tolerance' => 5),
                    // array('minSpeed'=> 100, 'maxSpeed'=> 150, 'tolerance' => 6),
                    // array('minSpeed'=> 150, 'maxSpeed'=> 500, 'tolerance' => 7),
                    'features' => array(
                        'alertManagement' => true,
                        'eventReporting' => false,
                    ),
                    'menuTitles' => array(
                        'dashboard' => null,
                        'gateStatus' => null,
                        'map' => null,
                        'live' => null,
                        'services' => null,
                        'ztl' => null,
                        'admin' => null,
                        'search' => null,
                        'stats' => null,
                        'diagnostic' => null,
                        'alerts' => null,
                        'plateAuthorizationWL' => null,
                        'plateAuthorizationBL' => null,
                        'plateAuthorizationBWL' => null,
                    ),
                    'statusBar' => array(
                        'showPoweredBy' => true,
                        'showAlerts' => true,
                        'showSystemStatus' => true,
                        'showTransits' => true,
                        'showViolations' => true,
                        'showClock' => true,
                    ),
                    'footer' => array(
                        'showPoweredBy' => true,
                    ),
                    'gateStatus' => array(
                        'lastViolationMinutes' => 60 * 24 * 60,
                        'showViolations' => true,
                        'showTransits' => true,
                        'showViolationsList' => true,
                        'showAlertsList' => true,
                        'showZtlStatus' => false,
                        'newEvents_TimeField' => 'StartTime',
                        'validatedEvents_TimeField' => 'ValidationTime',
                        'exportedEvents_TimeField' => 'ext_code_time',
                    ),
                    'ztl' => array(
                        'active' => true, // se off dovrebbero sparire tutti i riferimenti specifici alla ZTL! controller, link, etc... (permessi e liste esclusi)
                        'showZtlOnGateStatus' => true,
                    ),
                    'modelLabelsOverride' => array(),
                    'hideSystemStatus' => array(
                        'SCNTT' => true,
                    ),
                    'adminPanel' => array(
                        'showMeanSpeed' => true,
                        'showPlateAuthProfile' => false,
                        'showDeug' => true,
                    ),
                    'debug' => array(
                        'showViewLink' => false,
                        'showMissingMigrations' => false,
                        'autoEnable' => false,
                        'password' => '7496c4c241310446201ca21feb5e60a7',
                        'strictCheck' => true,
                    ), // strictCheck: say if a user MUST own directly the 'debug' auth or can be and admin or inherited
                    'gateFunctions' => array(
                        'ANY' => 'Any',
                    ),
                    'configurationEditor' => array(
                        'password' => 'ab7f30d27b5c365a07b433e59cf61706',
                    ),
                    'map' => array(
                        'index' => 'index2', // valori possibili: index index2 ...
                        'options' => array(
                            'index' => array(),
                            'index2' => array(),
                        ),
                    ),
                    'events' => array(
                        'deleteEnabled' => true,
                        'nationality' => array(
                            'required' => true,
                            'default' => false,
                        ),
                    ), // or IT,EN,...
                    'validation' => array(
                        'viewAllViolationDocuments' => true,
                        'voidButton' => array(
                            'enabled' => false,
                        ),
                        'viewOtherViolations' => true,
                        'plate' => array(
                            'alphanumeric' => true,
                            'suggestions' => true,
                        ),
                        'comment' => array(
                            'autocomplete' => array(
                                'enabled' => true,
                                'table' => true,
                                'dropdown' => false,
                                'custom' => array(),
                            ),
                        ),
                        'showSaveAndReleaseButton' => true,
                        'disableApproveButtonOnWhitelistedEvent' => true,
                    ),
                    'media' => array(
                        'enableEnhancedMode' => false,
                        'plateRectFix' => array(
                            'top' => 10,
                            'left' => 10,
                            'right' => 10,
                            'bottom' => 10,
                        ),
                    ),
                    'search' => array(
                        'advanced' => array(
                            'pagination' => 30,
                            'colorSensitivity' => 80, // in percentuale
                            'servicesCount' => 30, // in percentuale
                            'fields' => array(
                                'color' => array(
                                    'show' => true,
                                    'default' => 'no-color',
                                ),
                            ),
                        ),
                    ),
                    // 'colors'=>array('no-color','#000000','#FFFFFF'),
                    'users' => array(
                        'password' => array(
                            'strength' => array(
                                'minLength' => 8, // lunghezza minima
                                'min1Upper' => true, // almeno una maiuscola
                                'min1Lower' => true, // almeno una minuscola
                                'min1Digit' => true, // almeno un numero
                                'min1Symbol' => true,
                            ),
                        ),
                    ), // almeno un simbolo, ad esempio: !()/\|,.-;:_ .... etc
                    'alerts' => array(
                        'rss' => array(
                            'version' => 'RSS1', // see EFeed::RSS1
                            'size' => 20,
                            'auth' => array(
                                'type' => 'open',
                            ),
                        ), // see AlertController::RSS_AUTH_* constants
                        'photoPreviewOnPlate' => false,
                        'search' => array(
                            'dropdown_show_only_existent_tags' => true,
                        ),
                    ),
                    'notification' => array(
                        'enabled' => true, // main switch!
                        'max_per_stream' => 5, //
                        'deleteFiltered' => false,
                        'hideFlashMessage' => false,
                    ), // delete the notification filtered by NotificationController::filterNotification, otherwise they will be marked as 'dumped'
                    'ocr' => array(
                        'quality_threshold_good' => 60.0,
                        'quality_threshold_bad' => 30.0,
                    ),
                    // solo log4php
                    'log4php' => array(
                        'rootLogger' => array(
                            'appenders' => array(),
                        ), // aggiungere 'socket' per splunk
                        'eventserver-gui' => array(
                            'appenders' => array(
                                'default',
                                'socket',
                            ),
                        ), // aggiungere 'socket' per splunk
                        'appenders' => array(
                            'default' => array(
                                'class' => 'LoggerAppenderFile',
                                'layout' => array(
                                    'class' => 'LoggerLayoutSimple',
                                ),
                                'params' => array(
                                    'file' => 'c:/testlog4php.log',
                                    'append' => true,
                                ),
                            ),
                            'socket' => array( // splunk
                                'class' => 'LoggerAppenderSocket',
                                'layout' => array(
                                    'class' => 'LoggerLayoutPattern',
                                    'params' => array(
                                        'conversionPattern' => '%date %logger %-5level %msg%n',
                                    ),
                                ),
                                'params' => array(
                                    'remoteHost' => '127.0.0.1', // '192.168.2.3',
                                    'port' => 6101,
                                ),
                            ),
                            'syslog' => array(
                                'class' => 'LoggerAppenderSyslog',
                                'layout' => array(
                                    'class' => 'LoggerLayoutSimple',
                                ),
                                'params' => array(
                                    'ident' => 'eventserver-gui',
                                    'facility' => 'USER',
                                    'option' => 'NDELAY|PID',
                                ),
                            ),
                        ),
                    ),
                ),
            ), // fine log4php
            'mail' => array(
                'class' => 'ext.yii-mail.YiiMail',
                'transportType' => 'smtp',
                'transportOptions' => array(
                    'host' => 'smtp.gmail.com',
                    'username' => 'noreply@kria.biz',
                    'password' => 'kriaadmin',
                    'port' => '25',
                ),
                'viewPath' => 'application.views.mail',
            ),
            // fine params
            'configConsole' => array(
                'basePath' => 'C:\KRIA\htdocs\evserv\protected\config' . DIRECTORY_SEPARATOR . '..',
                'name' => 'Event Server 3.0 - Console',
                'preload' => 'inherit',
                'import' => 'inherit',
                'modules' => 'inherit',
                'components' => 'inherit',
                'params' => 'inherit',
                'commandMap' => array(
                    'database' => array(
                        'class' => 'application.vendor.database-command.EDatabaseCommand',
                    ),
                ),
            ),
        );
        $this->mode_development = array(
            'yiiDebug' => true,
            'yiiTraceLevel' => 0,

            'configWeb' => array(
                'modules' => array(
                    'gii' => array(
                        'class' => 'system.gii.GiiModule',
                        'password' => 'kria',
                        'ipFilters' => array('127.0.0.1', '::1'),
                        'generatorPaths' => array(
                            'bootstrap.gii',
                        ),
                    ),
                ),
                'components' => array(
                    'db' => array(
                        'connectionString' => 'mysql:host=127.0.0.1;dbname=eventserverdb',
                        'emulatePrepare' => true,
                        'username' => 'kria',
                        'password' => kria_load_secret('db'),
                        'charset' => 'utf8',
                        'tablePrefix' => '',
                        'enableProfiling' => true,
                        'enableParamLogging' => true,
                    ),
                    'registration_db' => array(
                        'connectionString' => 'mysql:host=31.14.140.159;dbname=eventserver_monitor',
                        'emulatePrepare' => true,
                        'username' => 'testuser',
                        'password' => kria_load_secret('registration_db'),
                        'charset' => 'utf8',
                        'tablePrefix' => '',
                        'enableProfiling' => false,
                        'enableParamLogging' => false,
                        'schemaCachingDuration' => 3600,
                        'class' => 'CDbConnection',
                    ),
                ),
                'params' => array(
                    'photoBaseUrl' => '/photos',
                    'photoBasePath' => 'C:\KRIA\htdocs\evserv\protected\config/../../../photos',

                    'log4php' => array(
                        'rootLogger' => array(
                            'appenders' => array(),
                        ),
                        'eventserver-gui' => array(
                            'appenders' => array('syslog'), // see main for log enabling
                        ),
                        'appenders' => array(
                            'file' => array(
                                'class' => 'LoggerAppenderFile',
                                'layout' => array(
                                    'class' => 'LoggerLayoutSimple',
                                ),
                                'params' => array(
                                    'file' => 'c:/testlog4php.log',
                                    'append' => true,
                                ),
                            ),
                            'socket' => array(
                                'class' => 'LoggerAppenderSocket',
                                'layout' => array(
                                    'class' => 'LoggerLayoutPattern',
                                    'params' => array(
                                        'conversionPattern' => '%date %logger %-5level %msg%n',
                                    ),
                                ),
                                'params' => array(
                                    'remoteHost' => '127.0.0.1',
                                    'port' => 6101,
                                ),
                            ),
                            'syslog' => array(
                                'class' => 'LoggerAppenderSyslog',
                                'layout' => array(
                                    'class' => 'LoggerLayoutSimple',
                                ),
                                'params' => array(
                                    'ident' => 'eventserver-gui',
                                    'facility' => 'USER',
                                    'option' => 'NDELAY|PID',
                                ),
                            ),
                        ),
                    ),

                ),
            ),
        );

        $this->mode_production = array(
            'yiiDebug' => false,
            'yiiTraceLevel' => 0,

            'configWeb' => array(
                'components' => array(
                    'db' => array(
                        'connectionString' => 'mysql:host=127.0.0.1;dbname=eventserverdb',
                        'emulatePrepare' => true,
                        'username' => 'kria',
                        'password' => kria_load_secret('db'),
                        'charset' => 'utf8',
                        'tablePrefix' => '',
                        'enableProfiling' => false,
                        'enableParamLogging' => false,
                        'schemaCachingDuration' => 3600,
                    ),
                    'registration_db' => array(
                        'connectionString' => 'mysql:host=31.14.140.159;dbname=eventserver_monitor',
                        'emulatePrepare' => true,
                        'username' => 'testuser',
                        'password' => kria_load_secret('registration_db'),
                        'charset' => 'utf8',
                        'tablePrefix' => '',
                        'enableProfiling' => false,
                        'enableParamLogging' => false,
                        'schemaCachingDuration' => 3600,
                        'class' => 'CDbConnection',
                    ),
                ),
                'params' => array(
                    'photoBaseUrl' => '/kria-photos',
                    'photoBasePath' => 'D:\mysql\data',
                ),
            ),
        );
        $this->mode_staging = array(
            'yiiDebug' => true,
            'yiiTraceLevel' => 3,

            'configWeb' => array(
                'modules' => array(
                    'gii' => array(
                        'class' => 'system.gii.GiiModule',
                        'password' => kria_load_secret('gii'),
                        'ipFilters' => array('127.0.0.1', '::1'),
                        'generatorPaths' => array(
                            'bootstrap.gii',
                        ),
                    ),
                ),
                'components' => array(
                    'db' => array(
                        'connectionString' => 'mysql:host=127.0.0.1;dbname=eventserverdb',
                        'emulatePrepare' => true,
                        'username' => 'kria',
                        'password' => kria_load_secret('db'),
                        'charset' => 'utf8',
                        'tablePrefix' => '',
                        'enableProfiling' => true,
                        'enableParamLogging' => true,
                    ),
                ),
                'params' => array(
                    'photoBaseUrl' => '/kria-photos',
                    'photoBasePath' => 'D:\mysql\data',

                    'log4php' => array(
                        'rootLogger' => array(
                            'appenders' => array('socket'),
                        ),
                        'eventserver-gui' => array(
                            'appenders' => array(), // see main for log enabling
                        ),
                        'appenders' => array(
                            'default' => array(
                                'class' => 'LoggerAppenderFile',
                                'layout' => array(
                                    'class' => 'LoggerLayoutSimple',
                                ),
                                'params' => array(
                                    'file' => 'c:/testlog4php.log',
                                    'append' => true,
                                ),
                            ),
                            'socket' => array(
                                'class' => 'LoggerAppenderSocket',
                                'layout' => array(
                                    'class' => 'LoggerLayoutPattern',
                                    'params' => array(
                                        'conversionPattern' => '%date %logger %-5level %msg%n',
                                    ),
                                ),
                                'params' => array(
                                    'remoteHost' => '127.0.0.1',
                                    'port' => 6101,
                                ),
                            ),
                            'syslog' => array(
                                'class' => 'LoggerAppenderSyslog',
                                'layout' => array(
                                    'class' => 'LoggerLayoutSimple',
                                ),
                                'params' => array(
                                    'ident' => 'eventserver-gui',
                                    'facility' => 'USER',
                                    'option' => 'NDELAY|PID',
                                ),
                            ),
                        ),
                    ),

                ),
            ),
        );

        $this->mode_test = array(
            'yiiDebug' => false,
            'yiiTraceLevel' => 0,

            'configWeb' => array(
                'language' => 'en',
                'components' => array(
                    'fixture' => array(
                        'class' => 'system.test.CDbFixtureManager',
                    ),
                    'db' => array(
                        'connectionString' => 'mysql:host=127.0.0.1;dbname=eventserverdb_test',
                        'emulatePrepare' => true,
                        'username' => 'kria',
                        'password' => kria_load_secret('db'),
                        'charset' => 'utf8',
                    ),
                ),
            ),
        );

        $this->local = array(
            'yiiDebug' => true,
            'yiiTraceLevel' => 1,
            'language' => 'it',
            'configWeb' => array(
                /*'modules' => array(
                // enable GII Web Code Generator
                'gii' => array(
                'class' => 'system.gii.GiiModule',
                'password' => 'development',
                'ipFilters' => array('127.0.0.1', '192.168.2.73'),
                ),
                ),*/
                'components' => array(
                    'db' => array(
                        'connectionString' => 'mysql:host=192.168.2.135;dbname=eventserverdb',
                        'username' => 'kria',
                        'emulatePrepare' => true,
                        'password' => 'kriaman',
                        'charset' => 'utf8',
                    ),
                    'cache'=>array(
                        'class'=>'system.caching.CFileCache',
                        'cachePath' => 'd:/cache',
                    ),
                ),
                'params' => array(
                    //Abilita il sistema di CFileCache
                    'cached_queries' => true,
                    //Abilita la selezione foto da parte dell'utente nel sistema obscure
                    'selectedbyuserid'=>false,
                    //introduced for Vercelli - defaults to none
                    'pdfPassword' => 'none', /*all, admin, view, none*/
                    //introduced for Peretto
                    'listsType' => 'black', /*both, black, white*/
                    //customization for questura
                    'eventsToShow' => 'all', /*all, warning, info, alarm*/
                    //supposed to go for ztl, ecc ecc but now works only for iceland (facecrop)
                    'photoEditingMode' => 'facecrop', /*all, none, select, facecrop (includes select), obscure (includes select)*/
                    //customization for iceland: removes the ocr quality tooltip
                    'showOcrTooltip' => 'false',
                    //customization for iceland: replaces the ocr quality tooltip with an icetra (iceland national database) one
                    'showICETRATooltip' => 'true',
                    //customization needed to activate the photo selection and editing - right now it works only for "section"
                    'deviceType' => 'section', /*section, speed, trafficlight, ztl*/
                    //'photoBasePath' => '\\\\192.168.2.135\\d\\MYSQL\\data',
                    // params for ReportPrinterFactory Component
                    'ReportPrinterFactory' => array(
                        // the printer to use to render event reports
                        'ReportPrinter' => 'ReportPrinterMilano',
                    ),
                    'event' => array(
                        'report' => array(
                            'logo' => '',
                            'text' => '',
                        ),
                    ),
                ),
            ), // configWeb
        );

        $this->runtime = array(
            'configWeb' => array(
                'language' => 'en',
                'params' => array(
                    'security' => array(
                        'user_tracking' => array(
                            'data_tracked_table' => array(
                            ),
                        ),
                        'send_export_registration' => true,
                        'export_expiry_date_check' => true,
                    ),
                    'notification' => array(
                        'enabled' => false,
                        'hideFlashMessage' => true,
                    ),
                    'events' => array(
                        'nationality' => array(
                            'required' => true,
                            'default' => 'IT',
                        ),
                    ),
                    'db' => array(
                        'cache' => array(
                            'enabled' => false,
                        ),
                    ),
                    'debug' => array(
                        'showViewLink' => false,
                    ),
                    'map' => array(
                        'index' => 'google',
                    ),
                    'plateAuthorizations' => array(
                        'default' => array(
                            'name' => 'X',
                            'surname' => 'X',
                        ),
                        'scheduler' => array(
                            'hotelMode' => true,
                        ),
                        'printLayout' => 'courmayeur',
                    ),
                    'adminPanel' => array(
                        'showPlateAuthProfile' => true,
                    ),
                    'logos' => array(
                        'login' => 'logo_spec_001.jpg',
                        'report' => 'logo_spec_001.jpg',
                    ),
                    'logosStyles' => array(
                        'login' => 'width: 80px; margin-bottom: 20px;',
                        'report' => 'width: 80px; margin-bottom: 20px;',
                    ),
                    'validation' => array(
                        'comment' => array(
                            'autocomplete' => array(
                                'table' => false,
                                'custom' => array(
                                    0 => 'LA VIOLAZIONE NON SUSSISTE',
                                    1 => 'VEICOLO OGGETTO DI FURTO',
                                    2 => 'VEICOLO IN ESCLUSIONE DELLA RESPONSABILITAâ€™ EX ART 4 L. 689/1981',
                                    3 => 'NAZIONALITAâ€™ TARGA NON INDIVIDUABILE',
                                    4 => 'CLASSIFICAZIONE DEL VEICOLO ERRONEAMENTE RILEVATA',
                                    5 => 'TARGA ILLEGIBILE',
                                    6 => 'IN ATTESA DI DEFINIZIONE CON IL RESPONSABILE DELL\'UFFICIO',
                                ),
                                'dropdown' => true,
                            ),
                        ),
                        0 => 's',
                        'plate' => array(
                            'alphanumeric' => false,
                        ),
                        'disableApproveButtonOnWhitelistedEvent' => true,
                        'viewAllViolationDocuments' => false,
                    ),
                    'classes' => array(
                        'vehicles' => array(
                            'c2' => '',
                            'c3' => '',
                        ),
                        'forValidation' => array(
                            'c2' => '',
                            'c3' => '',
                        ),
                    ),
                    'ocr' => array(
                        'quality_threshold_good' => 60,
                        'quality_threshold_bad' => 30,
                    ),
                    'report' => array(
                        'events' => array(
                            'order' => ' id_group ASC, StartTime ASC ',
                            'removeDefaultScope' => true,
                        ),
                        'byWorkPeriod' => false,
                        'completeService' => true,
                        'showReportPreviewPage' => true,
                    ),
                    'photoBaseLocationByUrl' => false,
                    'photoBasePath' => 'D:\\mysql\\data',
                ),
                'ztl' => array(
                    'name' => 'Gate Schedule',
                ),
                'name' => '',
                'components' => array(
                    'db' => array(
                        'enableProfiling' => false,
                        'connectionString' => 'mysql:host=192.168.2.135;dbname=eventserverdb',
                        'enableParamLogging' => true,
                    ),
                    'log' => array(
                        'routes' => array(
                            'db' => array(
                                'levels' => 'error,profile',
                            ),
                        ),
                    ),
                ),
            ),
            'yiiDebug' => false,
        );

    }

}
