<?php

class MaintenanceModeController extends Controller
{
  public static function maintenanceModeEnabled()
  {
    return paramdeep('debug','maintenance-mode') === true;
  }
  
  public static function userCanBypass()
  {
    return DebugController::canDebug();
  }
  
  public static function userCanSee()
  {
    return !self::maintenanceModeEnabled() || (self::maintenanceModeEnabled() && self::userCanBypass());
  }

  public function actionIndex()
  {
    $this->render('index');
  }
}