<?php

class ReportArchiveController extends Controller
{
	public function actionIndex() {
		
		$reportArchiveSearchForm = new ReportArchiveSearchForm();
		if (isset($_POST['ReportArchiveSearchForm'])) {
			$reportArchiveSearchForm->setAttributes($_POST['ReportArchiveSearchForm'], false);
			//$reportArchiveSearchForm->validate();
		}
		
		$reportDocument = ReportDocument::model();
		if (!empty($reportArchiveSearchForm->startDateTime)) {
			
			$theStartTime = DateTime::createFromFormat( Yii::app ()->params ['datetimeselect_format'] [Yii::app ()->language] ['php'],
				$reportArchiveSearchForm->startDateTime
			);
			$reportDocument->after($theStartTime);
			
		}
		if (!empty($reportArchiveSearchForm->endDateTime)) {
			
			$theEndTime = DateTime::createFromFormat( Yii::app ()->params ['datetimeselect_format'] [Yii::app ()->language] ['php'],
				$reportArchiveSearchForm->endDateTime
			);
			$reportDocument->before($theEndTime);
			
		}
		if (!empty($reportArchiveSearchForm->gateGroups)) {
			
			$reportDocument->byGateGroups($reportArchiveSearchForm->gateGroups);
			
		}

		if(!user ()->checkAccess ( 'report_archive_view_all' ))
		{
			$reportDocument->byUsers(user()->id);
		}
		else if (!empty($reportArchiveSearchForm->users))
		{
			$reportDocument->byUsers($reportArchiveSearchForm->users);
		}
		if (!empty($reportArchiveSearchForm->ADIcodeFrom)) {
		
			$reportDocument->fromADI($reportArchiveSearchForm->ADIcodeFrom);
		
		}
		if (!empty($reportArchiveSearchForm->ADIcodeTo)) {
			
			$reportDocument->toADI($reportArchiveSearchForm->ADIcodeTo);
			
		}
		
		
		$reportDocument->orderByCreationTime();
		
		$dataProvider = $reportDocument->search(10);
		
		$users = User::model()->findAll();
		
		$gateGroups = GateGroup::model()->findAll();
		
		$this->render('index', array(
			'reportArchiveSearchForm' => $reportArchiveSearchForm,
			'dataProvider' => $dataProvider,
			'users' => $users,
			'gateGroups' => $gateGroups
		));
	}
	
	public function actionShowReport($reportID)	{
		
		// search requested report
		$report = ReportDocument::model()->findByPk($reportID);
		
		// set download name
		$suggestedDownloadName = $report->getTitle();
		
		// set needed headers
		header("Content-type:application/pdf");
		header('Content-Disposition: inline; filename="' . $suggestedDownloadName . '.pdf"');

		// echo the PDF to the browser
		echo $report->Document;
	}

}

?>