<?php

class ImageHelper {

    /**
     * 
     * @param mixed $originalWidth
     * @param mixed $originalHeight
     * @param mixed $scaledWidth
     * @return double
     */
    public static function findScaledHeight($originalWidth, $originalHeight, $scaledWidth) {
        return (doubleval($scaledWidth) * doubleval($originalHeight)) / (doubleval($originalWidth) ?: 1);
    }

    /**
     * @param mixed $originalWidth
     * @param mixed $originalHeight
     * @param mixed $scaledHeight
     * @return double
     */
    public static function findScaledWidth($originalWidth, $originalHeight, $scaledHeight) {
        return (doubleval($scaledHeight) * doubleval($originalWidth)) / (doubleval($originalHeight) ?: 1);
    }

    /**
     * get the real path of an image in the 'images' folder
     * @param string $relativePath
     * @return string
     */
    public static function getImagePath($relativePath = '') {
        if ($relativePath !== null) {
            $path = dirname(Yii::app()->basePath) . '/images/' . $relativePath;
            if (file_exists($path))
                return $path;
        }
        return null;
    }

    /**
     * get the real path of an image in the 'images' folder
     * @param string $relativePath
     * @return string
     */
    public static function getImagesAt($relativePath = '') {
        $path = self::getImagePath($relativePath);
        if (!empty($path)) {
            $images = array();
            $dir = dir($path);
            while (($file = $dir->read()) != null)
                if (endsWith(strtolower($file), '.png'))
                    $images[] = $file;
            return $images;
        }
        return null;
    }

    /**
     * 
     * @param string $relativePath
     * @return string 
     */
    public static function getImageUrl($relativePath) {
        if (!empty($relativePath)) {
            return Yii::app()->createAbsoluteUrl('/images/' . $relativePath);
        }
        return null;
    }

    public static function getImageTag($relativePath, $description = null, $htmlOptions = null) {
        $src = self::getImageUrl($relativePath);
        if ($src == null)
            return "";
        $htmlOptions['title'] = $description;
        return HtmlHelper::img($src, $description, $htmlOptions); //CHtml::image($src, $description, $htmlOptions);    
    }

}
