<?php

class VehicleStatGraphEncoder
{

  static public function getGraphData (array $data, $xField, $yField, $granularity)
  {
    $graphData = array();
    foreach($data as $key => $row)
    {
      $graphData[$key]['x'] = self::granularityToLabel($row->$xField, $granularity);
      $graphData[$key]['y'] = $row->$yField;
    }
    return $graphData;
  }

  static public function encode (array $data, $xField, $yField, $granularity)
  {
    return CJSON::encode(self::getGraphData($data, $xField, $yField, $granularity));
  }
  
  static public function granularityToLabel(DateTime $dateTime, $granularity)
  {
    if ($granularity < 3600)
      return DateHelper::formatMedium($dateTime);
    if ($granularity >= 3600 && $granularity <= 2592000)
      return DateHelper::formatShort($dateTime);
    if ($granularity >= 2592000)
      return DateHelper::format($dateTime, "MMMM");
  }

}


