<?php
class NewPlateAuthorizationForm extends FormModel
{
	
	public $plates;
	public $startDateTime;
	public $endDateTime;
	public $gates;
	public $time;
	public $listGroup;

	public $source;
	
	public $name;
	public $surname;
	
	public $vehicleNationality;
	public $action;
	public $vehilceType;
	public $vehilceCategory;
	
	public $notes;
	
	function __construct()
	{
		$this->startDateTime = new DateTime();
		$this->endDateTime   = new DateTime();
	}
	
	
	
	/**
	 * Declares attribute labels.
	 */
	public function myAttributeLabels()
	{
		return array(
				'plates'=>t('Plate'),		
				'startDateTime'=>t('Start Date/Time'),
				'endDateTime'=>t('End Date/Time'),
				'gates'=>t('Gates'),
				'time'=>t('Schedule'),
				'listGroup'=>t('List'),
				'source'=>t('Source'),
				'name'=>t('Name'),
				'surname'=>t('Surname'),
				'vehicleNationality'=>t('Country'),
				'action'=>t('Action'),
				'vehilceType'=>t('Vehicle Type'),
				'vehilceCategory'=>t('Category'),
				'notes'=>t('Notes'),
				
		);
	}
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
				array('source, name, surname, vehicleNationality, action, vehilceType, vehilceCategory, notes', 'length', 'max'=>250),
				array('plates', 'match', 'pattern' =>'#^[A-Z0-9]*$#','message' => 'only capital letters and numbers','allowEmpty'=>false),
				array('plates, startDateTime, endDateTime','required'),
				array('startDateTime, endDateTime', 'date', 'format'=>'yyyy-M-d H:m:s'),
				array('endDateTime','compare','compareAttribute'=>'startDateTime','operator'=>'>', 'allowEmpty'=>false,'message'=>'{attribute} must be greater than "{compareValue}".'),
		);
	}
	
	public function getStartTimestamp()
	{
		return $this->startDateTime->getTimestamp();
	}
	public function getEndTimestamp()
	{
		return $this->endDateTime->getTimestamp();
	}
}