<?php foreach ($events as $event) { ?>
  <?php if ($event->ext_code != ExtCode::NULL_EXT_CODE) { ?>
    <?php $challengedSpeed = CalculateChallengedSpeed::run($event->Speed, Yii::app()->params['spotSpeedViolation']['percentageTolerance'], Yii::app()->params['spotSpeedViolation']['fixedTolerance'], Yii::app()->params['spotSpeedViolation']['toleranceTable']);; ?>
    <?php $challengedSpeed = number_format($challengedSpeed, 2); ?>
    <?php $validatingUser = User::model()->findByPk($event->id_validate_user); ?>
    <table class="report-event" cellpadding="4" nobr="true">
      <tbody>
        <tr>
          <td colspan="2">
            Il giorno
            <b><?php echo htmlspecialchars(DateHelper::formatISO9075Date($event->StartTime),ENT_QUOTES,'UTF-8'); ?></b>
            alle ore
            <b><?php echo htmlspecialchars(DateHelper::formatISO9075Time($event->StartTime),ENT_QUOTES,'UTF-8'); ?></b>
            nella località
            <b><?php echo htmlspecialchars($event->GateDescription,ENT_QUOTES,'UTF-8'); ?></b><span>,</span></td>
        </tr>
        <tr>
          <td colspan="2">
            matricola impianto
            <?php echo htmlspecialchars($event->Gate,ENT_QUOTES,'UTF-8'); ?><span>, </span>il conducente del veicolo targato
            <?php echo htmlspecialchars($event->Plate,ENT_QUOTES,'UTF-8'); ?>
            ha violato:
          </td>
        </tr>
        <?php foreach ($event->violationCodes as $code) { ?>
          <?php $violationCode = ViolationCode::model()->byName($code)->find(); ?>
          <tr>
            <td colspan="2">
              -
              <?php echo htmlspecialchars($violationCode->description,ENT_QUOTES,'UTF-8'); ?>
            </td>
          </tr>
          <tr>
            <td colspan="2">
              Velocità consentita
              <b><?php echo htmlspecialchars($event->speed_limit,ENT_QUOTES,'UTF-8'); ?></b><span>, </span>effettiva
              <b><?php echo htmlspecialchars($challengedSpeed,ENT_QUOTES,'UTF-8'); ?></b>
              già decurtata del 5% minimo di 5 Km/h come da disposizione di legge.
            </td>
          </tr>
        <?php } ?>
        <tr>
          <td>
            <b>Accertamento d'Infrazione N°:</b>
            <b><?php echo htmlspecialchars($event->ext_code,ENT_QUOTES,'UTF-8'); ?></b>
          </td>
          <td>
            Matricola:
            <?php echo htmlspecialchars($validatingUser->matriculation_number,ENT_QUOTES,'UTF-8'); ?>
          </td>
        </tr>
        <tr>
          <td>
            Data e Ora controllo:
            <b><?php echo htmlspecialchars(DateHelper::formatISO9075DateTime($event->ValidationTime),ENT_QUOTES,'UTF-8'); ?></b>
          </td>
          <td>
            Verbalizzante:
            <?php echo htmlspecialchars($user->fullName,ENT_QUOTES,'UTF-8'); ?>
          </td>
        </tr>
      </tbody>
    </table>
    <table class="blank-space" cellpadding="3">
      <tbody>
        <tr>
          <td colspan="2"></td>
        </tr>
      </tbody>
    </table>
  <?php } ?>
<?php } ?>
