<div class="page-header">
  <h2>
    <?php echo htmlspecialchars(Yii::t("app", "Translations").": ".strtoupper($language),ENT_QUOTES,'UTF-8'); ?>
    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/Translations')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(t('Back'),ENT_QUOTES,'UTF-8'); ?></a>
  </h2>
</div>
<form method="post">
  <input type="submit" />
  <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'language'), array('value', $language)), 'html5', 'UTF-8'); ?> />
  <input type="hidden" name="action" value="translate" />
  <table class="table table-condensed">
    <thead>
      <tr>
        <th style="width: 10%"><?php echo htmlspecialchars(t('Category'),ENT_QUOTES,'UTF-8'); ?></th>
        <th style="width: 40%"><?php echo htmlspecialchars(t('Source'),ENT_QUOTES,'UTF-8'); ?></th>
        <th style="width: 40%"><?php echo htmlspecialchars(t('Translation'),ENT_QUOTES,'UTF-8'); ?></th>
        <th style="width: 5%"><?php echo htmlspecialchars(t('Custom'),ENT_QUOTES,'UTF-8'); ?></th>
        <th style="width: 5%"><?php echo htmlspecialchars(t('Ignore'),ENT_QUOTES,'UTF-8'); ?></th>
        <th style="width: 5%"><?php echo htmlspecialchars(t('Remove'),ENT_QUOTES,'UTF-8'); ?></th>
        <th style="width: 5%"><?php echo htmlspecialchars(t('Nope'),ENT_QUOTES,'UTF-8'); ?></th>
      </tr>
    </thead>
    <tbody>
      <?php $index = 0; ?>
      <?php foreach($l->getCategories() as $category) { ?>
        <?php foreach($l->loadMessageType('untranslated',$category) as $source) { ?>
          <?php $msgid = "message_".uniqid().($index++); ?>
          <tr>
            <td style="width: 10%"><?php echo htmlspecialchars($category,ENT_QUOTES,'UTF-8'); ?></td>
            <td style="width: 40%"><?php echo htmlspecialchars($source,ENT_QUOTES,'UTF-8'); ?></td>
            <td style="width: 40%">
              <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', ($msgid . '[category]')), array('value', $category)), 'html5', 'UTF-8'); ?> />
              <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', ($msgid . '[message_original]')), array('value', $source)), 'html5', 'UTF-8'); ?> />
              <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'radio'), array('name', ($msgid . '[action]')), array('value', 'translate'), array('title', 'Translate')), 'html5', 'UTF-8'); ?> />
              <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'text'), array('name', ($msgid . '[message_translation]')), array('value', $source), array('style', 'width: 90%')), 'html5', 'UTF-8'); ?> />
            </td>
            <td style="width: 5%">
              <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'radio'), array('name', ($msgid . '[action]')), array('value', 'custom'), array('title', 'Custom')), 'html5', 'UTF-8'); ?> />
            </td>
            <td style="width: 5%">
              <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'radio'), array('name', ($msgid . '[action]')), array('value', 'ignore'), array('title', 'Ignore')), 'html5', 'UTF-8'); ?> />
            </td>
            <td style="width: 5%">
              <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'radio'), array('name', ($msgid . '[action]')), array('value', 'remove'), array('title', 'Remove')), 'html5', 'UTF-8'); ?> />
            </td>
            <td style="width: 5%">
              <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'radio'), array('name', ($msgid . '[action]')), array('value', 'nope'), array('title', 'Nope'), array('checked', 'checked')), 'html5', 'UTF-8'); ?> />
            </td>
          </tr>
        <?php } ?>
      <?php } ?>
    </tbody>
  </table>
  <input type="submit" />
</form>
