<?php $vehicleTypes = array('Truck', 'Vehicle', 'Motorcycle', 'Bus', 'Kemler'); ?>
<form id="stats-form">
  <div class="controls">
    <h4>
      <i class="icon-time"></i>
      <?php echo htmlspecialchars(t('When'),ENT_QUOTES,'UTF-8'); ?>
      <small><?php echo htmlspecialchars(t('Choose a date range'),ENT_QUOTES,'UTF-8'); ?></small>
    </h4>
    <div class="btn-group" id="when-buttons">
      <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DatePickSetter')), array('data-datepick-setter-range', ('7')), array('data-datepick-setter-start-target', '#datepicker-start-date'), array('data-datepick-setter-end-target', '#datepicker-end-date')), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(t('Last 7 days'),ENT_QUOTES,'UTF-8'); ?></button>
      <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DatePickSetter')), array('data-datepick-setter-range', ('30')), array('data-datepick-setter-start-target', '#datepicker-start-date'), array('data-datepick-setter-end-target', '#datepicker-end-date')), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(t('Last 30 days'),ENT_QUOTES,'UTF-8'); ?></button>
    </div>
  </div>
  <div class="controls">
    <div class="input-prepend input-append">
      <span class="add-on"><?php echo htmlspecialchars(t('From'),ENT_QUOTES,'UTF-8'); ?></span>
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'datepicker-start-date'), array('class', ('date-picker' . ' ' . 'span2')), array('type', ('text')), array('value', ('')), array('readonly', ('true'))), 'html5', 'UTF-8'); ?> />
      <input id="start-timestamp" type="hidden" name="startTimestamp" />
      <span class="add-on icon-calendar"></span>
    </div>
    <div class="input-prepend input-append">
      <span class="add-on"><?php echo htmlspecialchars(t('To'),ENT_QUOTES,'UTF-8'); ?></span>
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'datepicker-end-date'), array('class', ('date-picker' . ' ' . 'span2')), array('type', ('text')), array('value', ('')), array('readonly', ('true'))), 'html5', 'UTF-8'); ?> />
      <input id="end-timestamp" type="hidden" name="endTimestamp" />
      <span class="add-on icon-calendar"></span>
    </div>
    <div class="controls">
      <div id="datepicker-start-time" class="input-prepend input-append time-picker" data-time="00:00">
        <span class="add-on"><?php echo htmlspecialchars(t('From'),ENT_QUOTES,'UTF-8'); ?></span>
        <input <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'span1'), array('data-format', (Yii::app()->params['timeselect_format'][Yii::app()->language]['view'])), array('type', 'text'), array('name', 'startTime'), array('data-time', '00:00'), array('value', '00:00')), 'html5', 'UTF-8'); ?> />
        <span class="add-on">
          <i data-time-icon="icon-time" data-date-icon="icon-calendar"></i>
        </span>
      </div>
      <div id="datepicker-end-time" class="input-prepend input-append time-picker">
        <span class="add-on"><?php echo htmlspecialchars(t('To'),ENT_QUOTES,'UTF-8'); ?></span>
        <input <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'span1'), array('data-format', (Yii::app()->params['timeselect_format'][Yii::app()->language]['view'])), array('type', 'text'), array('name', 'endTime'), array('value', '23:59')), 'html5', 'UTF-8'); ?> />
        <span class="add-on">
          <i data-time-icon="icon-time" data-date-icon="icon-calendar"></i>
        </span>
      </div>
    </div>
  </div>
  <hr />
  <div class="controls">
    <h4>
      <i class="icon-map-marker"></i>
      <?php echo htmlspecialchars(t('Where'),ENT_QUOTES,'UTF-8'); ?>
      <small><?php echo htmlspecialchars(t('Gates'),ENT_QUOTES,'UTF-8'); ?></small>
      <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-mini')), array('type', ('button')), array('data-behavior', ('CheckboxMaster')), array('data-checkbox-master-btngroup-target', '#gates')), 'html5', 'UTF-8'); ?>>
        <i class="icon-check"></i>
      </button>
    </h4>
    <div <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'gates'), array('class', 'btn-group'), array('data-toggle', ('buttons-checkbox'))), 'html5', 'UTF-8'); ?>>
      <?php $gtcnt = 0; ?>
      <?php foreach($gates as $gate) { ?>
        <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-gate')), array('type', ('button'))), 'html5', 'UTF-8'); ?>>
          <?php echo htmlspecialchars("{$gate->short_name}",ENT_QUOTES,'UTF-8'); ?>
          <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', ('checkbox')), array('name', ('gates[]')), array('value', ($gate->Gate))), 'html5', 'UTF-8'); ?> />
        </button>
        <?php if(++$gtcnt % 2 == 0) { ?>
          <br />
        <?php } ?>
      <?php } ?>
    </div>
  </div>
  <hr />
  <div class="controls">
    <h4>
      <i class="icon-truck"></i>
      <?php echo htmlspecialchars(t('What'),ENT_QUOTES,'UTF-8'); ?>
      <small><?php echo htmlspecialchars(t('Vehicle Type'),ENT_QUOTES,'UTF-8'); ?></small>
      <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-mini')), array('type', ('button')), array('data-behavior', ('CheckboxMaster')), array('data-checkbox-master-btngroup-target', '#vehicles')), 'html5', 'UTF-8'); ?>>
        <i class="icon-check"></i>
      </button>
    </h4>
    <div <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'vehicles'), array('class', 'btn-group'), array('data-toggle', ('buttons-checkbox'))), 'html5', 'UTF-8'); ?>>
      <?php $vtcnt = 0; ?>
      <?php foreach ($vehicleTypes as $vehicleType) { ?>
        <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button'))), 'html5', 'UTF-8'); ?>>
          <?php echo htmlspecialchars(t($vehicleType),ENT_QUOTES,'UTF-8'); ?>
          <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', ('checkbox')), array('name', 'vehiclesClass[]'), array('value', $vehicleType)), 'html5', 'UTF-8'); ?> />
        </button>
        <?php if(++$vtcnt % 4 == 0) { ?>
          <br />
        <?php } ?>
      <?php } ?>
    </div>
  </div>
  <hr />
  <div class="controls">
    <h4>
      <i class="icon-dashboard"></i>
      <?php echo htmlspecialchars(t('Speed'),ENT_QUOTES,'UTF-8'); ?>
    </h4>
    <div id="slider-range"></div>
    <div class="form-inline controls">
      <div class="input-prepend input-append">
        <span class="add-on">
          <?php echo htmlspecialchars(t('Min'),ENT_QUOTES,'UTF-8'); ?>
        </span>
        <input id="min-speed" class="span1" type="text" name="minSpeed" readonly="readonly" />
        <span class="add-on">
          Km/h
        </span>
      </div>
      <div class="input-prepend input-append">
        <span class="add-on">
          <?php echo htmlspecialchars(t('Max'),ENT_QUOTES,'UTF-8'); ?>
        </span>
        <input id="max-speed" class="span1" type="text" name="maxSpeed" readonly="readonly" />
        <span class="add-on">
          Km/h
        </span>
      </div>
    </div>
  </div>
  <hr />
  <div class="controls">
    <h4>
      <i class="icon-sort-by-attributes"></i>
      <?php echo htmlspecialchars(t('Granularity'),ENT_QUOTES,'UTF-8'); ?>
    </h4>
    <select id="granularity" name="granularity">
      <option value="300"><?php echo htmlspecialchars(t("5 minutes"),ENT_QUOTES,'UTF-8'); ?></option>
      <option value="600"><?php echo htmlspecialchars(t("10 minutes"),ENT_QUOTES,'UTF-8'); ?></option>
      <option value="1800"><?php echo htmlspecialchars(t("30 minutes"),ENT_QUOTES,'UTF-8'); ?></option>
      <option value="3600"><?php echo htmlspecialchars(t("1 hour"),ENT_QUOTES,'UTF-8'); ?></option>
      <option value="7200"><?php echo htmlspecialchars(t("2 hours"),ENT_QUOTES,'UTF-8'); ?></option>
      <option value="86400"><?php echo htmlspecialchars(t("1 day"),ENT_QUOTES,'UTF-8'); ?></option>
      <option value="604800"><?php echo htmlspecialchars(t("1 solar week"),ENT_QUOTES,'UTF-8'); ?></option>
      <option value="2592000"><?php echo htmlspecialchars(t("1 solar month"),ENT_QUOTES,'UTF-8'); ?></option>
    </select>
  </div>
  <div class="controls">
    <button class="btn" type="submit"><?php echo htmlspecialchars(t('Compute'),ENT_QUOTES,'UTF-8'); ?></button>
    <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', 'export'), array('data-target', (Yii::app()->createUrl('stats/export')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(t('Export'),ENT_QUOTES,'UTF-8'); ?></button>
    <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', 'export'), array('data-target', (Yii::app()->createUrl('stats/exportDetailed')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(t('Detailed export'),ENT_QUOTES,'UTF-8'); ?></button>
  </div>
</form>
