<?php if(!is_bool($canEdit)) { ?>
  <?php $canEdit = $this->canEdit(); ?>
<?php } ?>
<?php $eventsVoidCount = user()->checkAccess('can_see_void_events') ? $service->eventsVoidCount : 0; ?>
<tr <?php echo MtHaml\Runtime::renderAttributes(array(array('id', ('service-' . ($service->ID))), array('class', ($service->isManageable()?"":"service-not-manageable")), array('data-service-id', ($service->ID))), 'html5', 'UTF-8'); ?>>
  <td>
    <a class="tooltipbox">
      <?php echo htmlspecialchars("$service->ID",ENT_QUOTES,'UTF-8'); ?>
      <span>
        <?php echo htmlspecialchars($service->gateGroup->name,ENT_QUOTES,'UTF-8'); ?>
      </span>
    </a>
  </td>
  <td><?php echo htmlspecialchars(DateHelper::formatMedium($service->start_time),ENT_QUOTES,'UTF-8'); ?></td>
  <td>
    <?php if($service->isTerminated()) { ?>
      <?php echo htmlspecialchars(DateHelper::formatMedium($service->termination_time),ENT_QUOTES,'UTF-8'); ?>
    <?php } else { ?>
      <?php echo htmlspecialchars(DateHelper::formatMedium($service->expected_end_time),ENT_QUOTES,'UTF-8'); ?>
    <?php } ?>
  </td>
  <td><?php echo htmlspecialchars($service->eventsCount,ENT_QUOTES,'UTF-8'); ?></td>
  <td><?php echo htmlspecialchars($service->eventsExaminedCount,ENT_QUOTES,'UTF-8'); ?></td>
  <td>
    <?php if (user()->checkAccess('verify_all_events') || user()->checkAccess('verify_all_events_view')) { ?>
      <span <?php echo MtHaml\Runtime::renderAttributes(array(array('title', (Yii::t("app", "Total Validated")))), 'html5', 'UTF-8'); ?>>
        <?php echo htmlspecialchars($service->eventsValidatedCount,ENT_QUOTES,'UTF-8'); ?>
      </span>
      <span <?php echo MtHaml\Runtime::renderAttributes(array(array('title', (Yii::t("app", "Approved")))), 'html5', 'UTF-8'); ?>>
        <?php echo htmlspecialchars("[",ENT_QUOTES,'UTF-8'); ?>
        <?php echo htmlspecialchars($service->eventsApprovedCount,ENT_QUOTES,'UTF-8'); ?>
        <?php echo htmlspecialchars(" / ",ENT_QUOTES,'UTF-8'); ?>
      </span>
      <span <?php echo MtHaml\Runtime::renderAttributes(array(array('title', (Yii::t("app", "Invalid")))), 'html5', 'UTF-8'); ?>>
        <?php echo htmlspecialchars($service->eventsInvalidCount,ENT_QUOTES,'UTF-8'); ?>
        <?php echo htmlspecialchars(" / ",ENT_QUOTES,'UTF-8'); ?>
      </span>
      <span <?php echo MtHaml\Runtime::renderAttributes(array(array('title', (Yii::t("app", "Pending")))), 'html5', 'UTF-8'); ?>>
        <?php echo htmlspecialchars($service->eventsPendingCount,ENT_QUOTES,'UTF-8'); ?>
        <?php echo htmlspecialchars("]",ENT_QUOTES,'UTF-8'); ?>
      </span>
    <?php } else { ?>
      <?php echo htmlspecialchars('-',ENT_QUOTES,'UTF-8'); ?>
    <?php } ?>
  </td>
  <td>
    <?php if (user()->checkAccess('verify_all_events') || user()->checkAccess('verify_all_events_view')) { ?>
      <span <?php echo MtHaml\Runtime::renderAttributes(array(array('title', (Yii::t("app", "Reported")))), 'html5', 'UTF-8'); ?>>
        <?php echo htmlspecialchars($service->eventsQueuedForExportCount,ENT_QUOTES,'UTF-8'); ?>
        <?php echo htmlspecialchars(" / ",ENT_QUOTES,'UTF-8'); ?>
      </span>
      <span <?php echo MtHaml\Runtime::renderAttributes(array(array('title', (Yii::t("app", "Queued for report")))), 'html5', 'UTF-8'); ?>>
        <?php echo htmlspecialchars($service->eventsApprovedCount,ENT_QUOTES,'UTF-8'); ?>
      </span>
    <?php } else { ?>
      <?php echo htmlspecialchars('-'  ,ENT_QUOTES,'UTF-8'); ?>
    <?php } ?>
  </td>
  <td>
    <?php if (user()->checkAccess('verify_all_events') || user()->checkAccess('verify_all_events_view')) { ?>
      <span <?php echo MtHaml\Runtime::renderAttributes(array(array('title', (Yii::t("app", "Exported")))), 'html5', 'UTF-8'); ?>>
        <?php echo htmlspecialchars($service->eventsExportedCount,ENT_QUOTES,'UTF-8'); ?>
        <?php echo htmlspecialchars(" / ",ENT_QUOTES,'UTF-8'); ?>
      </span>
      <span <?php echo MtHaml\Runtime::renderAttributes(array(array('title', (Yii::t("app", "Queued for export")))), 'html5', 'UTF-8'); ?>>
        <?php echo htmlspecialchars($service->eventsQueuedForExportCount,ENT_QUOTES,'UTF-8'); ?>
      </span>
      <?php if($service->report_user > 0) { ?>
        <span <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('tooltip-placemark' . ' ' . 'assigned-operator')), array('data-toggle', 'tooltip'), array('title', ($service->registerOperator->fullName))), 'html5', 'UTF-8'); ?>>
          <i class="icon-user"></i>
        </span>
      <?php } ?>
    <?php } else { ?>
      <?php echo htmlspecialchars('-'  ,ENT_QUOTES,'UTF-8'); ?>
    <?php } ?>
  </td>
  <td>
    <?php if($service->status == Service::STATUS_READY_TO_EVALUATE) { ?>
      <?php if($canEdit) { ?>
        <?php if (isset($service->assignedOperator)) { ?>
          <?php if($service->isAssignedTo(user()->id)) { ?>
            <?php if(paramdeep('report','byWorkPeriod') || ($service->id_user_validating <= 0))           { ?>
              <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('release-charge' . ' ' . 'btn' . ' ' . 'btn-small')), array('data-service-id', ($service->ID)), array('data-confirm-text', (Yii::t('app', 'Confirm?')))), 'html5', 'UTF-8'); ?>>
                <?php echo htmlspecialchars(Yii::t("app", "Release"),ENT_QUOTES,'UTF-8'); ?>
              </button>
            <?php } else { ?>
              <?php if(!paramdeep('report','byWorkPeriod') && ($service->id_user_validating > 0) && user()->checkAccess('reset-services-master'))   { ?>
                <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('reset-validation' . ' ' . 'btn' . ' ' . 'btn-small' . ' ' . 'btn-warning' . ' ' . 'pull-right')), array('data-service-id', ($service->ID)), array('data-confirm-text', (Yii::t('app', 'Confirm?')))), 'html5', 'UTF-8'); ?>>
                  <span <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('tooltip-placemark' . ' ' . 'assigned-operator')), array('data-toggle', 'tooltip'), array('title', ($service->validatingOperator->fullName))), 'html5', 'UTF-8'); ?>>
                    <?php echo htmlspecialchars(Yii::t("app", "validating")    ,ENT_QUOTES,'UTF-8'); ?>
                    <i class="icon-user"></i>
                  </span>
                  <?php echo htmlspecialchars(Yii::t("app", "Reset"),ENT_QUOTES,'UTF-8'); ?>
                </button>
              <?php } else { ?>
                <span <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('tooltip-placemark' . ' ' . 'assigned-operator')), array('data-toggle', 'tooltip'), array('title', ($service->assignedOperator->fullName))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(Yii::t("app", "me"),ENT_QUOTES,'UTF-8'); ?>
                  <i class="icon-user"></i>
                </span>
              <?php } ?>
            <?php } ?>
          <?php } else { ?>
            <?php if(!paramdeep('report','byWorkPeriod') && ($service->id_user_validating > 0) && user()->checkAccess('reset-services-master'))   { ?>
              <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('reset-validation' . ' ' . 'btn' . ' ' . 'btn-small' . ' ' . 'btn-warning' . ' ' . 'pull-right')), array('data-service-id', ($service->ID)), array('data-confirm-text', (Yii::t('app', 'Confirm?')))), 'html5', 'UTF-8'); ?>>
                <span <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('tooltip-placemark' . ' ' . 'assigned-operator')), array('data-toggle', 'tooltip'), array('title', ($service->validatingOperator->fullName))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(Yii::t("app", "validating")    ,ENT_QUOTES,'UTF-8'); ?>
                  <i class="icon-user"></i>
                </span>
                <?php echo htmlspecialchars(Yii::t("app", "Reset")          ,ENT_QUOTES,'UTF-8'); ?>
              </button>
            <?php } else if(user()->checkAccess('release-services-master'))   { ?>
              <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('release-charge' . ' ' . 'btn' . ' ' . 'btn-small' . ' ' . 'btn-warning' . ' ' . 'pull-right')), array('data-service-id', ($service->ID)), array('data-confirm-text', (Yii::t('app', 'Confirm?')))), 'html5', 'UTF-8'); ?>>
                <span <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('tooltip-placemark' . ' ' . 'assigned-operator')), array('data-toggle', 'tooltip'), array('title', ($service->assignedOperator->fullName))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(Yii::t("app", "Taken")    ,ENT_QUOTES,'UTF-8'); ?>
                  <i class="icon-user"></i>
                </span>
                <?php echo htmlspecialchars(Yii::t("app", "Release"),ENT_QUOTES,'UTF-8'); ?>
              </button>
            <?php } else    { ?>
              <span <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('tooltip-placemark' . ' ' . 'assigned-operator')), array('data-toggle', 'tooltip'), array('title', ($service->assignedOperator->fullName))), 'html5', 'UTF-8'); ?>>
                <?php if($service->assignedOperator == user()->id) { ?>
                  <?php echo htmlspecialchars(Yii::t("app", "By me"),ENT_QUOTES,'UTF-8'); ?>
                <?php } else { ?>
                  <?php echo htmlspecialchars(Yii::t("app", "Taken")  ,ENT_QUOTES,'UTF-8'); ?>
                <?php } ?>
                <i class="icon-user"></i>
              </span>
            <?php } ?>
          <?php } ?>
        <?php } else { ?>
          <?php if(paramdeep('report','byWorkPeriod') || ($service->id_user_validating <= 0)  ||  $service->isValidatingBy(user()->id)) { ?>
            <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('take-charge' . ' ' . 'btn' . ' ' . 'btn-small')), array('data-service-id', ($service->ID)), array('data-confirm-text', (Yii::t('app', 'Confirm?')))), 'html5', 'UTF-8'); ?>>
              <?php echo htmlspecialchars(Yii::t("app", "Take Charge"),ENT_QUOTES,'UTF-8'); ?>
            </button>
          <?php } else { ?>
            <?php if(!paramdeep('report','byWorkPeriod') && ($service->id_user_validating > 0) && user()->checkAccess('reset-services-master'))   { ?>
              <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('reset-validation' . ' ' . 'btn' . ' ' . 'btn-small' . ' ' . 'btn-warning' . ' ' . 'pull-right')), array('data-service-id', ($service->ID)), array('data-confirm-text', (Yii::t('app', 'Confirm?')))), 'html5', 'UTF-8'); ?>>
                <span <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('tooltip-placemark' . ' ' . 'assigned-operator')), array('data-toggle', 'tooltip'), array('title', ($service->validatingOperator->fullName))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(Yii::t("app", "validation in progress")    ,ENT_QUOTES,'UTF-8'); ?>
                  <i class="icon-user"></i>
                </span>
                <?php echo htmlspecialchars(Yii::t("app", "Reset"),ENT_QUOTES,'UTF-8'); ?>
              </button>
            <?php } else   { ?>
              <span <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('tooltip-placemark' . ' ' . 'assigned-operator')), array('data-toggle', 'tooltip'), array('title', ($service->validatingOperator->fullName))), 'html5', 'UTF-8'); ?>>
                <?php echo htmlspecialchars(Yii::t("app", "validating"),ENT_QUOTES,'UTF-8'); ?>
                <i class="icon-user"></i>
              </span>
            <?php } ?>
          <?php } ?>
        <?php } ?>
      <?php } else { ?>
        <?php if (isset($service->assignedOperator)) { ?>
          <span <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('tooltip-placemark' . ' ' . 'assigned-operator')), array('data-toggle', 'tooltip'), array('title', ($service->assignedOperator->fullName))), 'html5', 'UTF-8'); ?>>
            <?php echo htmlspecialchars(Yii::t("app", "Taken"),ENT_QUOTES,'UTF-8'); ?>
            <i class="icon-user"></i>
          </span>
        <?php } ?>
      <?php } ?>
    <?php } ?>
  </td>
  <td>
    <?php $this->renderPartial('_serviceButtons', get_defined_vars()); ?>
  </td>
</tr>
