<?php $allGates = array(); ?>
<div <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'cartography-page'), array('data-behavior', ('AostaCartography'))), 'html5', 'UTF-8'); ?>>
  <div class="page-header">
    <h2>
      <i class="icon-globe"></i>
      <?php echo htmlspecialchars(t('Maps'),ENT_QUOTES,'UTF-8'); ?>
      <small>
        <span id="cartography-update-time"></span>
      </small>
    </h2>
  </div>
  <div class="row">
    <div class="span3">
      <div class="sidebar">
        <h3><?php echo htmlspecialchars(t('Gates groups'),ENT_QUOTES,'UTF-8'); ?></h3>
        <?php foreach($gateGroups as $gateGroup) { ?>
          <?php $gateGroup = new GateGroupPresenter($gateGroup); ?>
          <div <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'gate-group-list'), array('data-behavior', 'NavigateToCoords'), array('data-navigate-to-target', '#big-map'), array('data-navigate-to-latitude', ($gateGroup->latitude)), array('data-navigate-to-longitude', ($gateGroup->longitude))), 'html5', 'UTF-8'); ?>>
            <span class="gate-group-name">
              <span <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('status-icon' . ' ' . 'icon-circle')), array('class', ($gateGroup->statusClass))), 'html5', 'UTF-8'); ?>></span>
              <?php echo htmlspecialchars($gateGroup->name,ENT_QUOTES,'UTF-8'); ?>
            </span>
            <ul class="unstyled">
              <?php foreach($gateGroup->gates as $gate) { ?>
                <?php $gate = new GatePresenter($gate); ?>
                <?php $allGates[] = $gate; ?>
                <li>
                  <span class="gate-name"><?php echo htmlspecialchars($gate->Descrizione,ENT_QUOTES,'UTF-8'); ?></span>
                </li>
              <?php } ?>
            </ul>
          </div>
        <?php } ?>
        <div class="small-map-section">
          <h3><?php echo htmlspecialchars(t('Generic map'),ENT_QUOTES,'UTF-8'); ?></h3>
          <div class="small-map-image-container">
            <img <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'small-map'), array('src', ((Yii::app()->baseUrl) . '/images/MapVDA.png'))), 'html5', 'UTF-8'); ?> />
          </div>
        </div>
      </div>
    </div>
    <div class="span9">
      <div class="big-map-container">
        <?php $this->renderPartial('index2_sub', array('gateGroups' => $gateGroups, 'gates'=>$allGates));; ?>
      </div>
    </div>
  </div>
</div>
