<?php $status = $gate->statusClass; ?>
<?php $features = param('features'); ?>
<?php $liveUrl = null; ?>
<?php if(strlen($gate->live_url) > 0 && user()->checkAccess('view_live')) { ?>
  <?php $liveUrl = Yii::app()->createUrl('live/direct',array('id'=>$gate->ID)); ?>
<?php } ?>
<div <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'gate-container'), array('data-behavior', ('GateStatus')), array('data-gate-id', ($gate->Gate)), array('data-alerts-container', ('#' . $viewMode . '-container')), array('data-alerts-mode', $viewMode)), 'html5', 'UTF-8'); ?>>
  <header>
    <div <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'gate-time'), array('class', $status)), 'html5', 'UTF-8'); ?>>
      <span class="last-signal-time"><?php echo htmlspecialchars($gate->lastSignalTime,ENT_QUOTES,'UTF-8'); ?></span>
      <span class="last-signal-date"><?php echo htmlspecialchars($gate->lastSignalDate,ENT_QUOTES,'UTF-8'); ?></span>
      <?php if(!$gate->isAlive()) { ?>
        <span class="last-signal-label"><?php echo htmlspecialchars(t('Last signal'),ENT_QUOTES,'UTF-8'); ?></span>
      <?php } ?>
    </div>
    <div class="gate-description">
      <div class="gate-name blacklink">
        <p>
          <a class="events-alert-link">
            <i class="icon-road"></i>
            <?php echo htmlspecialchars($gate->Descrizione,ENT_QUOTES,'UTF-8'); ?>
            <br />
            <?php if(paramdeep('gateStatus','showZtlStatus') && $gate->IsWhiteList) { ?>
              <?php if($gate->isZtlLimited()) { ?>
                <i <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'color-red'), array('style', 'font-size: smaller;'), array('title', (t('Limited access')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(' '.strtoupper(t('Limited access')),ENT_QUOTES,'UTF-8'); ?></i>
              <?php } else { ?>
                <i <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'color-green'), array('style', 'font-size: smaller;'), array('title', (t('Free access')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(' '.strtoupper(t('Free access')),ENT_QUOTES,'UTF-8'); ?></i>
              <?php } ?>
            <?php } ?>
          </a>
        </p>
        <div class="gate-type">
          <?php if(!empty($liveUrl)) { ?>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'icon-facetime-video'), array('href', $liveUrl), array('target', '_blank'), array('title', (t('Live')))), 'html5', 'UTF-8'); ?>>
              <?php echo htmlspecialchars(t($gate->DeviceModel),ENT_QUOTES,'UTF-8'); ?>
            </a>
          <?php } else { ?>
            <?php echo htmlspecialchars(t($gate->DeviceModel),ENT_QUOTES,'UTF-8'); ?>
          <?php } ?>
        </div>
        <div class="gate-matriculation-number">
          <?php echo htmlspecialchars('ID: '.$gate->Gate,ENT_QUOTES,'UTF-8'); ?>
        </div>
      </div>
    </div>
  </header>
  <article class="gate-data-container">
    <?php if ($features['alertManagement']===true && user()->checkAccess('gate_status_gates_view_alerts')) { ?>
      <section>
        <table>
          <tr>
            <td class="title" width="30%">
              <span class="icon-rss"></span>
              <?php echo htmlspecialchars('Stat. '.t('Events'),ENT_QUOTES,'UTF-8'); ?>
            </td>
            <td width="23%">
              <span class="event-summary blacklink">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createAbsoluteUrl('alert/search',  array('types' => Alert::TYPE_INFO, 'gates' => $gate->Gate))))), 'html5', 'UTF-8'); ?>>
                  <b <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'info-icon'), array('title', (t('Info')))), 'html5', 'UTF-8'); ?>>
                    <i class="icon-info"></i>
                    <?php echo htmlspecialchars($gate->getRecentlyAlertsCount(Alert::TYPE_INFO),ENT_QUOTES,'UTF-8'); ?>
                  </b>
                </a>
              </span>
            </td>
            <td width="23%">
              <span class="event-summary blacklink">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createAbsoluteUrl('alert/search',  array('types' => Alert::TYPE_WARNING, 'gates' => $gate->Gate))))), 'html5', 'UTF-8'); ?>>
                  <b <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'warning-icon'), array('title', (t('Warnings')))), 'html5', 'UTF-8'); ?>>
                    <i class="icon-warning-sign"></i>
                    <?php echo htmlspecialchars($gate->getRecentlyAlertsCount(Alert::TYPE_WARNING),ENT_QUOTES,'UTF-8'); ?>
                  </b>
                </a>
              </span>
            </td>
            <td width="23%">
              <span class="event-summary blacklink">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createAbsoluteUrl('alert/search',  array('types' => Alert::TYPE_ALARM, 'gates' => $gate->Gate))))), 'html5', 'UTF-8'); ?>>
                  <b <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'alarm-icon'), array('title', (t('Alarms')))), 'html5', 'UTF-8'); ?>>
                    <i class="icon-exclamation"></i>
                    <?php echo htmlspecialchars($gate->getRecentlyAlertsCount(Alert::TYPE_ALARM),ENT_QUOTES,'UTF-8'); ?>
                  </b>
                </a>
              </span>
            </td>
          </tr>
        </table>
      </section>
    <?php } ?>
    <?php if(paramdeep('gateStatus','showViolations') && user()->checkAccess('gate_status_gates_view_violations')) { ?>
      <section>
        <table>
          <tr>
            <td class="title" width="30%">
              <span class="icon-camera"></span>
              <?php echo htmlspecialchars('Stat. '.t('Violations'),ENT_QUOTES,'UTF-8'); ?>
            </td>
            <td width="23%">
              <b <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'alarm-icon'), array('title', (t('New').' ('.t('Last {0} days', array('{0}'=>$gate->lastViolationDays)).')'))), 'html5', 'UTF-8'); ?>>
                <span class="icon-check-empty"></span>
                <?php echo htmlspecialchars($gate->recentlyViolations_New,ENT_QUOTES,'UTF-8'); ?>
              </b>
            </td>
            <td width="23%">
              <b <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'warning-icon'), array('title', (t('Validated').' ('.t('Last {0} days', array('{0}'=>$gate->lastViolationDays)).')'))), 'html5', 'UTF-8'); ?>>
                <i class="icon-check"></i>
                <?php echo htmlspecialchars($gate->recentlyViolations_Validated,ENT_QUOTES,'UTF-8'); ?>
              </b>
            </td>
            <td width="23%">
              <b <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'info-icon'), array('title', (t('Exported').' ('.t('Last {0} days', array('{0}'=>$gate->lastViolationDays)).')'))), 'html5', 'UTF-8'); ?>>
                <i class="icon-signout"></i>
                <?php echo htmlspecialchars($gate->recentlyViolations_Exported,ENT_QUOTES,'UTF-8'); ?>
              </b>
            </td>
          </tr>
        </table>
      </section>
    <?php } ?>
    <?php if(paramdeep('gateStatus','showTransits') && user()->checkAccess('gate_status_gates_view_transits')) { ?>
      <?php $now = DateHelper::ensureObjectEx(); ?>
      <section>
        <table>
          <tr>
            <td class="title" width="30%">
              <span class="icon-bar-chart"></span>
              <?php echo htmlspecialchars('Stat. '.t('Transits'),ENT_QUOTES,'UTF-8'); ?>
            </td>
            <td width="23%">
              <?php $t = t("Today's transits").' ('.$now->getToday()->toDateString().')'; ?>
              <b <?php echo MtHaml\Runtime::renderAttributes(array(array('title', $t)), 'html5', 'UTF-8'); ?>>
                <?php echo htmlspecialchars(t('D',array(),'gateStatus').' ',ENT_QUOTES,'UTF-8'); ?>
                <?php echo htmlspecialchars($gate->recentTransitsDay,ENT_QUOTES,'UTF-8'); ?>
              </b>
            </td>
            <td width="23%">
              <?php $t = t("This week's transits")." (".($now->getFirstDayOfWeek()->toDateString())." -> ".($now->getLastDayOfWeek()->toDateString()).")"; ?>
              <b <?php echo MtHaml\Runtime::renderAttributes(array(array('title', $t)), 'html5', 'UTF-8'); ?>>
                <?php echo htmlspecialchars(t('W',array(),'gateStatus').' ',ENT_QUOTES,'UTF-8'); ?>
                <?php echo htmlspecialchars($gate->recentTransitsWeek,ENT_QUOTES,'UTF-8'); ?>
              </b>
            </td>
            <td width="23%">
              <?php $t = t("This month's transits")." (".ucwords($now->getMonthName())." $now->year)"; ?>
              <b <?php echo MtHaml\Runtime::renderAttributes(array(array('title', $t)), 'html5', 'UTF-8'); ?>>
                <?php echo htmlspecialchars(t('M',array(),'gateStatus').' ',ENT_QUOTES,'UTF-8'); ?>
                <?php echo htmlspecialchars($gate->recentTransitsMonth,ENT_QUOTES,'UTF-8'); ?>
              </b>
            </td>
          </tr>
        </table>
      </section>
    <?php } ?>
  </article>
</div>
