<?php $countryList = CountryList::localized(); ?>
<?php $globalMode = false; ?>
<?php $liste = array(); ?>
<?php if($plateList == null) { ?>
  <?php $isBlack = false; ?>
  <?php $globalMode = true; ?>
  <?php $liste = PlateList::getCurrentUserLists(); ?>
  <?php $liste = array_remap($liste, function($k, $v){ return $v->code; });; ?>
<?php } else { ?>
  <?php $isBlack = $plateList->mode == PlateList::MODE_BLACK_LIST; ?>
  <?php $liste[$plateList->code] = $plateList; ?>
<?php } ?>
<?php if(Yii::app()->params['listsType']=="black") { ?>
  <?php $isBlack = true; ?>
<?php } ?>
<?php if(!$globalMode) { ?>
  <?php if($isBlack) { ?>
    <?php $imgurl = $plateList->getImageUrl('/images/list_black.png'); ?>
  <?php } else { ?>
    <?php $imgurl = $plateList->getImageUrl('/images/list_white.png'); ?>
  <?php } ?>
<?php } ?>
<script type="text/javascript" src="../js/columnReorderer.js"></script>
<div id="plateauthsstatus-search-page">
  <?php $context = array('plateListId'=>$plateListId,'status'=>$status,'search'=>$search,'timeRange'=>$timeRange,'whitelistStatusDataProvider_page'=>$_REQUEST[whitelistStatusDataProvider_page],'sort'=>$sort,'category'=>$category); ?>
  <?php $currentUrl = Yii::app()->createAbsoluteUrl($this->route,$context); ?>
  <div class="page-header">
    <table width="100%">
      <tr>
        <td>
          <h2>
            <?php if(!$globalMode) { ?>
              <?php if($isBlack) { ?>
                <i class="icon-file-text"></i>
              <?php } else { ?>
                <i class="icon-file-text-alt"></i>
              <?php } ?>
            <?php } else { ?>
              <div class="icon-globe"></div>
            <?php } ?>
            <?php if($isBlack) { ?>
              <?php echo htmlspecialchars(t('Listed vehicles'),ENT_QUOTES,'UTF-8'); ?>
            <?php } else { ?>
              <?php echo htmlspecialchars(t('Manage plate authorizations')  ,ENT_QUOTES,'UTF-8'); ?>
            <?php } ?>
          </h2>
          <h4>
            <?php if(!$globalMode) { ?>
              <?php echo htmlspecialchars($plateList->getListTitleComplete(),ENT_QUOTES,'UTF-8'); ?>
            <?php } else { ?>
              <?php echo htmlspecialchars(t("All lists"),ENT_QUOTES,'UTF-8'); ?>
            <?php } ?>
          </h4>
        </td>
        <td>
          <?php if(!empty($imgurl)) { ?>
            <img <?php echo MtHaml\Runtime::renderAttributes(array(array('src', $imgurl), array('width', '100'), array('align', 'right')), 'html5', 'UTF-8'); ?> />
          <?php } ?>
        </td>
      </tr>
    </table>
  </div>
  <div class="row" style="margin-bottom: 20px;">
    <div class="form-box">
      <?php $form = $this->beginWidget('bootstrap.widgets.TbActiveForm',      array('id'=>'plateauthstatus-search-form','action' => Yii::app()->createUrl($this->route),'method'=>'GET','htmlOptions'=>array('style'=>'margin-bottom: 0px;'),)); ?>
      <span>
        <fieldset>
          <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'plateListId'), array('value', $plateListId)), 'html5', 'UTF-8'); ?> />
          <b><?php echo htmlspecialchars(t('Search'),ENT_QUOTES,'UTF-8'); ?></b>
          <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'text'), array('name', 'search'), array('value', $search), array('class', 'span2'), array('title', (t('You can use % as a wildcard')))), 'html5', 'UTF-8'); ?> />
          <?php if(!$isBlack) { ?>
            <b><?php echo htmlspecialchars(t('Time interval'),ENT_QUOTES,'UTF-8'); ?></b>
            <?php echo CHtml::dropDownList('timeRange', $timeRange, $timeRanges, array('style'=>'width: 120px;'));; ?>
            <b><?php echo htmlspecialchars(t('Status'),ENT_QUOTES,'UTF-8'); ?></b>
            <?php echo CHtml::dropDownList('status', $status, $statuses, array('style'=>'width: 120px;'));; ?>
          <?php } ?>
          <?php if($isBlack) { ?>
            <b><?php echo htmlspecialchars(t('Alert type'),ENT_QUOTES,'UTF-8'); ?></b>
            <?php echo CHtml::dropDownList('category', $category, $categories, array('style'=>'width: 120px;'));; ?>
          <?php } ?>
          <b><?php echo htmlspecialchars(t('Sort'),ENT_QUOTES,'UTF-8'); ?></b>
          <?php echo CHtml::dropDownList('sort', $sort, $sortList, array('class'=>'span2'));; ?>
          <b><?php echo htmlspecialchars(t('#'),ENT_QUOTES,'UTF-8'); ?></b>
          <?php echo CHtml::dropDownList('pagination', $pagination, array(20=>20,50=>50,100=>100,200=>200), array('style'=>'width: 70px;'));; ?>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-small')), array('href', (url('plateAuthorization/whitelistStatus', array('plateListId'=>$plateListId)))), array('title', (t('Remove filters'))), array('style', 'margin-bottom: 10px;')), 'html5', 'UTF-8'); ?>>
            <i class="icon-remove"></i>
          </a>
          <button class="btn btn-small" type="submit" name="submit_search" autofocus="autofocus" style="margin-bottom: 10px;">
            <?php echo htmlspecialchars(t("Search"),ENT_QUOTES,'UTF-8'); ?>
          </button>
          <?php if(user()->checkAccess('plate_auth_status_export') || user()->checkAccess('plate_auth_renew')) { ?>
            <div class="btn-group pull-right">
              <a class="btn btn-small dropdown-toggle" data-toggle="dropdown" href="#">
                <?php echo htmlspecialchars(Yii::t("app", "Actions"),ENT_QUOTES,'UTF-8'); ?>
                <span class="caret"></span>
              </a>
              <ul class="dropdown-menu" id="multi-plate-actions">
                <?php if (user()->checkAccess('plate_auth_status_export')) { ?>
                  <li>
                    <a href="#" id="multi-plate-action-export">
                      <?php echo htmlspecialchars(Yii::t("app", ("Export")),ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  </li>
                <?php } ?>
                <?php if (user()->checkAccess('plate_auth_renew')) { ?>
                  <li>
                    <a href="#" id="multi-plate-action-renew">
                      <?php echo htmlspecialchars(Yii::t("app", ("Renew")),ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  </li>
                <?php } ?>
              </ul>
            </div>
          <?php } ?>
          <?php if(user()->checkAccess('plate_auth_status_export')) { ?>
            <button class="pull-right btn btn-small" type="submit" id="submit_export" name="submit_export" style="margin-left: 5px;display: none;">
              <?php echo htmlspecialchars(t("Export"),ENT_QUOTES,'UTF-8'); ?>
            </button>
          <?php } ?>
          <?php if(user()->checkAccess('plate_auth_renew')) { ?>
            <button class="pull-right btn btn-small" type="submit" id="submit_renew_many" name="submit_renew_many" style="display: none;">
              <?php echo htmlspecialchars(t("Renew"),ENT_QUOTES,'UTF-8'); ?>
            </button>
          <?php } ?>
        </fieldset>
      </span>
      <?php $this->endWidget(); ?>
    </div>
  </div>
  <div class="row">
    <?php if (isset($dataProvider) && count($dataProvider->data)>0) { ?>
      <?php $permessi = $dataProvider->data; ?>
      <div class="tableContainer">
        <table class="table table-condensed span12" id="resultTable">
          <thead>
            <tr>
              <th></th>
              <th>
                <?php echo htmlspecialchars(t('List'),ENT_QUOTES,'UTF-8'); ?>
              </th>
              <th>
                <?php echo htmlspecialchars(t('Name'),ENT_QUOTES,'UTF-8'); ?>
              </th>
              <th>
                <?php echo htmlspecialchars(t('Surname'),ENT_QUOTES,'UTF-8'); ?>
              </th>
              <th></th>
              <th>
                <?php echo htmlspecialchars(t('Plate'),ENT_QUOTES,'UTF-8'); ?>
              </th>
              <?php if($isBlack)   { ?>
                <th>
                  <?php echo htmlspecialchars(t('Model'),ENT_QUOTES,'UTF-8'); ?>
                </th>
                <th>
                  <?php echo htmlspecialchars(t('Vehicle class'),ENT_QUOTES,'UTF-8'); ?>
                </th>
                <th>
                  <?php echo htmlspecialchars(t('Alert type'),ENT_QUOTES,'UTF-8'); ?>
                </th>
                <th>
                  <?php echo htmlspecialchars(t('Notes'),ENT_QUOTES,'UTF-8'); ?>
                </th>
              <?php } ?>
              <?php if(!$isBlack) { ?>
                <th>
                  <?php echo htmlspecialchars(t('Gate'),ENT_QUOTES,'UTF-8'); ?>
                </th>
                <th>
                  <?php echo htmlspecialchars(t('Time Schedule'),ENT_QUOTES,'UTF-8'); ?>
                </th>
                <th>
                  <?php echo htmlspecialchars(t('Start date'),ENT_QUOTES,'UTF-8'); ?>
                </th>
                <th>
                  <?php echo htmlspecialchars(t('End date'),ENT_QUOTES,'UTF-8'); ?>
                </th>
                <th>
                  <?php echo htmlspecialchars(t('Status'),ENT_QUOTES,'UTF-8'); ?>
                </th>
              <?php } ?>
              <th>
                <?php echo htmlspecialchars(t('Actions'),ENT_QUOTES,'UTF-8'); ?>
              </th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($permessi as $permessoRow) { ?>
              <?php $permesso = $this->createPermessoFromRow($permessoRow, $currentUrl); ?>
              <?php $lista = $liste[$permesso->IDLista]; ?>
              <tr>
                <td>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($permesso->url_view)), array('title', (t('View')))), 'html5', 'UTF-8'); ?>>
                    <i class="icon-eye-open"></i>
                  </a>
                </td>
                <td>
                  <?php if($permesso->ListaIsBlack) { ?>
                    <i class="icon-file-text"></i>
                  <?php } else { ?>
                    <i class="icon-file-text-alt"></i>
                  <?php } ?>
                  <?php echo htmlspecialchars($permesso->Lista,ENT_QUOTES,'UTF-8'); ?>
                </td>
                <td>
                  <?php if(user()->checkAccess('plate_auth_insert') && user()->checkAccess('plate_auth_insert_wizard')) { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('plateAuthorization/whiteListWizard',array('plateListId'=>$permesso->IDLista,'ownerId'=>$permesso->IDUtente,'step'=>2))))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars($permesso->Nome,ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  <?php } else { ?>
                    <?php echo htmlspecialchars($permesso->Nome,ENT_QUOTES,'UTF-8'); ?>
                  <?php } ?>
                </td>
                <td>
                  <?php if(user()->checkAccess('plate_auth_insert') && user()->checkAccess('plate_auth_insert_wizard')) { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('plateAuthorization/whiteListWizard',array('plateListId'=>$permesso->IDLista,'ownerId'=>$permesso->IDUtente,'step'=>2))))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars($permesso->Cognome,ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  <?php } else { ?>
                    <?php echo htmlspecialchars($permesso->Cognome,ENT_QUOTES,'UTF-8'); ?>
                  <?php } ?>
                </td>
                <td>
                  <?php $this->printCountryFlag($permesso->Nationality); ?>
                </td>
                <td>
                  <?php if(user()->checkAccess('plate_auth_insert') && user()->checkAccess('plate_auth_insert_wizard')) { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('plateAuthorization/whiteListWizard',array('plateListId'=>$permesso->IDLista,'ownerId'=>$permesso->IDUtente,'vehicleId'=>$permesso->IDVeicolo,'step'=>3))))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars($permesso->Targa,ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  <?php } else { ?>
                    <?php echo htmlspecialchars($permesso->Targa,ENT_QUOTES,'UTF-8'); ?>
                  <?php } ?>
                </td>
                <?php if($isBlack) { ?>
                  <td>
                    <?php echo htmlspecialchars($permesso->DescrizioneVeicolo,ENT_QUOTES,'UTF-8'); ?>
                  </td>
                  <td>
                    <img <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'vehicle-class-icon-small'), array('src', ((Yii::app()->baseUrl) . '/images/vehicle-classes/' . ($permesso->Classe != "" ? $permesso->Classe : "vehicle") . '.png'))), 'html5', 'UTF-8'); ?> />
                  </td>
                  <td>
                    <?php echo htmlspecialchars($permesso->Categoria,ENT_QUOTES,'UTF-8'); ?>
                  </td>
                  <td>
                    <?php echo htmlspecialchars($permesso->Note,ENT_QUOTES,'UTF-8'); ?>
                  </td>
                <?php } ?>
                <?php if(!$isBlack) { ?>
                  <td>
                    <?php echo SystemInfoHelper::getPlateAuthGateCoolName($permesso->IDGate,$permesso->IDGate_type); ?>
                  </td>
                  <td>
                    <?php echo SystemInfoHelper::getTimeScheduleCoolName($permesso->IDTime); ?>
                  </td>
                  <td>
                    <?php if(user()->checkAccess('plate_auth_insert') && user()->checkAccess('plate_auth_insert_wizard')) { ?>
                      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('plateAuthorization/whiteListWizard',array('plateListId'=>$permesso->IDLista,'ownerId'=>$permesso->IDUtente,'vehicleId'=>$permesso->IDVeicolo,'validityPeriodId'=>$permesso->IDAbbonamento,'step'=>4))))), 'html5', 'UTF-8'); ?>>
                        <?php echo htmlspecialchars($permesso->DataInizio,ENT_QUOTES,'UTF-8'); ?>
                      </a>
                    <?php } else { ?>
                      <?php echo htmlspecialchars($permesso->DataInizio,ENT_QUOTES,'UTF-8'); ?>
                    <?php } ?>
                  </td>
                  <td>
                    <?php if(user()->checkAccess('plate_auth_insert') && user()->checkAccess('plate_auth_insert_wizard')) { ?>
                      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('plateAuthorization/whiteListWizard',array('plateListId'=>$permesso->IDLista,'ownerId'=>$permesso->IDUtente,'vehicleId'=>$permesso->IDVeicolo,'validityPeriodId'=>$permesso->IDAbbonamento,'step'=>4))))), 'html5', 'UTF-8'); ?>>
                        <?php echo htmlspecialchars($permesso->DataFine,ENT_QUOTES,'UTF-8'); ?>
                      </a>
                    <?php } else { ?>
                      <?php echo htmlspecialchars($permesso->DataFine,ENT_QUOTES,'UTF-8'); ?>
                    <?php } ?>
                  </td>
                  <td>
                    <font <?php echo MtHaml\Runtime::renderAttributes(array(array('color', ($permesso->statusColor))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars($permesso->statusText,ENT_QUOTES,'UTF-8'); ?>
                    </font>
                  </td>
                <?php } ?>
                <td>
                  <?php $this->printPrintBtn($permesso); ?>
                  <?php if($lista->editable && Yii::app()->user->checkAccess('plate_auth_enable')) { ?>
                    <?php if($permesso->Enabled == 1) { ?>
                      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($permesso->url_revoke)), array('title', (t('Revoke')))), 'html5', 'UTF-8'); ?>>
                        <i class="icon-pause"></i>
                      </a>
                    <?php } else { ?>
                      <?php if($lista->editable && Yii::app()->user->checkAccess('plate_auth_activate'))  { ?>
                        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($permesso->url_activate)), array('title', (t('Activate')))), 'html5', 'UTF-8'); ?>>
                          <i class="icon-play"></i>
                        </a>
                      <?php } ?>
                    <?php } ?>
                  <?php } ?>
                  <?php if($lista->editable && $permesso->ToBeConfirmed == 1 && Yii::app()->user->checkAccess('plate_auth_confirmed')) { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($permesso->url_confirm)), array('title', (t('Confirm')))), 'html5', 'UTF-8'); ?>>
                      <i class="icon-unlock-alt"></i>
                    </a>
                  <?php } ?>
                  <?php if($lista->editable && ($permesso->aboutToExpire || $permesso->expired) && Yii::app()->user->checkAccess('plate_auth_renew')) { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($permesso->url_renew)), array('title', (t('Renew')))), 'html5', 'UTF-8'); ?>>
                      <i class="icon-repeat"></i>
                    </a>
                  <?php } ?>
                  <?php if($lista->editable && Yii::app()->user->checkAccess('plate_auth_delete')) { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($permesso->url_delete)), array('title', (t('Delete'))), array('onclick', ('return confirm(\'' . (t('Are you sure you want to delete this item?')) . '\')'))), 'html5', 'UTF-8'); ?>>
                      <i class="icon-trash"></i>
                    </a>
                  <?php } ?>
                </td>
              </tr>
            <?php } ?>
          </tbody>
        </table>
      </div>
      <?php if (isset($dataProvider->pagination)) { ?>
        <div class="pagination pagination-links-container">
          <?php $this->widget('bootstrap.widgets.TbPager', array('pages' => $dataProvider->pagination)); ?>
        </div>
        <?php echo htmlspecialchars(t("Results").": $totalResults",ENT_QUOTES,'UTF-8'); ?>
      <?php } ?>
    <?php } else { ?>
      <h4><?php echo htmlspecialchars(Yii::t("app", "No results"),ENT_QUOTES,'UTF-8'); ?></h4>
    <?php } ?>
  </div>
</div>
<?php if($isBlack) { ?>
  <script type="text/javascript">
    <?php echo "moveColumn($('#resultTable'), 2, 8);"; ?>
    <?php echo "moveColumn($('#resultTable'), 2, 8);"; ?>
  </script>
<?php } ?>
