<div id='vehicletrace-search-page'>

    <?php
    $controller = $this;
    $hourList = CHtml::listData(array_merge(array(array('value' => '', 'label' => '-')), DateHelper::hourList()), 'value', 'label');
    $minuteList = CHtml::listData(array_merge(array(array('value' => '', 'label' => '-')), DateHelper::minuteList()), 'value', 'label');
    $gateList = Gate::getGateList();
    $laneList = CHtml::listData(array(array('name' => t('-'), 'value' => ''), array('name' => t('1'), 'value' => '0'), array('name' => t('2'), 'value' => '1'), array('name' => t('3'), 'value' => '2')), 'value', 'name');
    ?>

    <div class="page-header">
        <h2><?php echo t('Transits') ?></h2>
    </div>
    <div class="form-box">
        <form id="search-vehicletrace-form">
            <div class="row">
                <?php if (user()->checkAccess('license_plate_visibility')) { ?>
                    <div class="span1">
                        <label><?php echo t('License plate'); ?></label>
                        <div class="controls">
                            <input type="text" class="span1" name="VehicleTrace[VehicleID]" />
                        </div>
                    </div>
                <?php } ?>
                <div id="date-time-range-search" class="span" data-behavior="DateRangeInput" data-date-range-start-target='#search-date-start' data-date-range-end-target='#search-date-end'>
                    <label><?php echo t("Date & Time"); ?></label>
                    <div class="date-time-range-block span">
                        <?php echo t("From"); ?>
                        <div id="search-date-start" class="input-append date datetime-picker">
                            <input data-format="<?php echo Yii::app()->params['datetimeselect_format'][Yii::app()->language]['view']; ?>" type="text" name="VehicleTrace[event_date_start]" >
                            <span class="add-on">
                                <i data-time-icon="icon-time" data-date-icon="icon-calendar"></i>
                            </span>  
                            </input>     
                        </div>
                    </div>        
                    <div class="date-time-range-block span">
                        <?php echo t("To"); ?>      
                        <div id="search-date-end" class="input-append date datetime-picker">
                            <input data-format="<?php echo Yii::app()->params['datetimeselect_format'][Yii::app()->language]['view']; ?>" type="text" name="VehicleTrace[event_date_end]; ?>">
                            <span class="add-on">
                                <i data-time-icon="icon-time" data-date-icon="icon-calendar"></i>
                            </span>  
                            </input>    
                        </div>
                    </div>        
                </div>     

                <div class="span">
                    <label><?php echo t('Speed') ?></label>
                    <div class="controls">
                        <?php echo t('From'); ?>
                        <?php echo CHtml::ActiveNumberField($model, 'search_speed_start', array('class' => 'span1', 'min' => 0, 'step' => 10)); ?>
                        <?php echo t('To'); ?>
                        <?php echo CHtml::ActiveNumberField($model, 'search_speed_end', array('class' => 'span1', 'min' => 0, 'step' => 10)); ?>
                    </div>
                </div>

                <div class="span1">
                    <label><?php echo t('Kemler'); ?></label>
                    <div class="controls">
                        <input type="text" class="span1" name="VehicleTrace[kemlerSearchString]" />
                    </div>
                </div>

                <div class="span">
                    <label><?php echo t('Flags'); ?> </label>
                    <div class="controls">
                        <input type="hidden" name="searchBookmarked" id="searchBookmarked" value="<?php echo($model->searchBookmarked ? 1 : 0); ?>" />
                        <button class="btn toggleBtn" type="button" data-target="#searchBookmarked">
                            <i class="icon-bookmark"></i>
                        </button>
                    </div>
                </div>

                <div class="span2">
                    <label><?php echo t('Nationality'); ?></label>
                    <div class="controls">
                        <?php echo $this->renderPartial('/shared/_countrySelection', array('selectName' => 'VehicleTrace[Nationality]', 'modelName' => 'VehicleTrace'), true); ?>
                    </div>
                </div>

            </div>

            <div class="row">

                <div class="span">
                    <label><?php echo t('Gate'); ?></label>
                    <div class="controls">
                        <?php echo CHtml::activeDropDownList($model, 'GateID', $gateList,array('multiple' => true, 'selected'=>2)); ?>
                    </div>
                </div>

                <div class="span">
                    <label><?php echo t('Lane'); ?></label>
                    <div class="controls">
                        <?php echo CHtml::activeDropDownList($model, 'LaneID', $laneList); ?>
                    </div>
                </div>

                <div class="span">
                    <label><?php echo t('Classe'); ?></label>
                    <div class="controls">
                        <?php echo $this->renderPartial('/shared/_vehicleClassSelection', array('selectName' => 'VehicleTrace[ClassName]'), true); ?>
                    </div>
                </div>

                <div class="span2">
                    <label>Ordinamento:</label>
                    <div class="controls">
                        <?php echo CHtml::dropDownList('startTimeSordOrder', "DESC", array("DESC" => t("Data più recente"), "ASC" => t("Data meno recente")), array("id" => "sortingfield")); ?>
                    </div>
                </div>
                <div class="span">
                    <label><br></label>
                    <div class="controls">
                        <button class="span" type="submit" id="search-vehicletrace-button"><?php echo t('Search'); ?></button>
                    </div>
                </div>
            </div>
        </form>
    </div>

    <?php
    $this->widget('bootstrap.widgets.TbGridView', array(
        'id' => 'vehicle-trace-grid',
        'dataProvider' => $model->search(),
        'emptyText' => '',
        'columns' => array(
            array(
                'name' => '',
                'type' => 'html',
                'value' => 'AlertPresenter::getProperty($data->alert, "getLevelIcon")',
            ),
            array(
                'name' => 'VehicleID',
                'value' => '$data->VehicleID',
                'visible' => user()->checkAccess('license_plate_visibility'),
            ),
            array(
                'name' => 'StartDate',
                'type' => 'raw',
                'value' => function($data, $row) {
                    return "<span class='trace-date'>" . DateHelper::formatDate($data->StartDateTime, 'medium') . "</span>&nbsp" .
                            "<span class='trace-time'>" . DateHelper::formatTime($data->StartDateTime, 'medium') . "</span>";
                },
                'headerHtmlOptions' => array('class' => 'trace-datetime-column'),
            ),
            array(
                'name' => 'GateID',
                'value' => '$data->gate->short_name',
                'headerHtmlOptions' => array('class' => 'gate-filter'),
            ),
            array(
                'name' => 'Speed',
                'type' => 'raw',
                'value' => '(($data->Speed >= 0)? sprintf("%.1f", $data->Speed) : "-")',
            ),
            array(
                'name' => 'LaneID',
                'value' => '$data->LaneID + 1',
            ),
            array(
                'name' => 'ClassName',
                'type' => 'raw',
                'value' => function($data, $row) use ($controller) {
                    return $controller->renderPartial('/shared/_vehicleClassBox', array('event' => $data), true);
                },
            ),
            array(
                'name' => 'Nationality',
                'type' => 'raw',
                'value' => function($data, $row) use ($controller) {
                    return $controller->renderPartial('/shared/_countryFlag', array('isoCode' => $data->nationalityCode), true);
                },
            ),
            array(
                'name' => 'kemlerSearchString',
                'value' => function($data, $row) use ($controller) {
                    return $controller->renderPartial('/shared/_kemlerCode', array('kemlerCode' => $data->kemlerCode), true);
                },
                'type' => 'raw',
            ),
            array(
                'name' => 'alert',
                'value' => 'AlertPresenter::getProperty($data->alert, "getHtmlEventDescription")',
                'type' => 'html',
            ),
            array(
                'class' => 'bootstrap.widgets.TbButtonColumn',
                'buttons' => array(
                    'view' => array(
                        'imageUrl' => 'aaa',
                        'url' => function($data, $row) use ($controller) {
                            return Yii::app()->createUrl("vehicleTrace/view", array('id' => $data->ID));
                        },
                        'icon' => false,
                        'options' => array('target' => '_blank', 'class' => 'icon-zoom-in'),
                    ),
                    'delete' => array('visible' => 'false'),
                    'update' => array('visible' => 'false'),
                ),
            ),
            array(
                'header' => '',
                'type' => 'raw',
                'value' => 'app()->controller->renderBookmark($data,true)',
            ),
        ),
    ));
    ?>
</div>
