# Event Server 3.0 - Kria

## Required PHP modules
* php5-curl
* php5-mcrypt
* php5-xdebug

## Special PHP.ini settings

```bash
[Date]
; Defines the default timezone used by the date functions
; http://php.net/date.timezone
date.timezone = "Europe/Rome"
```

## xdebug note (development)
Be sure xdebug is loaded with this configuration.
If you are using debian-based linux OS, probably a file
/etc/php5/apache2/conf.d/xdebug.ini already exists.

```bash
  zend_extension=/usr/lib/php5/20090626+lfs/xdebug.so #fixpath
  xdebug.remote_enable=1
  xdebug.remote_host=localhost
  xdebug.remote_port=9000
```

## Environment

Environment variable must be set.
Possible values are: DEVELOPMENT, TEST, STAGING, PRODUCTION

Example with DEVELOPMENT environment:
On unix based operating system you should add this line to your `/etc/apache2/envvars` AND in your `.bashrc`:

```bash
export YII_ENVIRONMENT=DEVELOPMENT
```

(Restart apache and `source .bashrc`)

On Windows you must create a new variable (`YII_ENVIRONMENT`) and set `DEVELOPMENT` as value. Restart.

## Required Apache modules
* rewrite

## Country List
To add a new language support for country list, go here https://github.com/umpirsky/country-list
and place the file in lib/countries

## Testing
* Install PEAR: `sudo apt-get install pear`
* Enable `auto_discover`: `sudo pear config-set auto_discover 1`

## Unit test
* Install phpunit:
  - `sudo pear install pear.phpunit.de/PHPUnit`
  - `sudo pear install phpunit/DbUnit`
  - `sudo pear install phpunit/PHP_Invoker`
  - `sudo pear install phpunit/PHPUnit_Story`

## Function test
* Install phpunit related class: `sudo pear install phpunit/PHPUnit_Selenium`
* Download [Selenium server](http://seleniumhq.org/download/)
* Testing with Chromium? `sudo ln -s /usr/bin/chromium-browser /usr/bin/google-chrome`

Launch `java -jar selenium-server-standalone-2.28.0.jar` in the folder
with downloaded jar (file version might be different)

As alternative, place jar file in `/usr/local/bin` with this bash script:

```bash
#!/bin/bash
java -jar /usr/local/bin/selenium-server-standalone-2.28.0.jar
```

Save as `selenium-server`. Be sure file has executable permission and `/usr/local/bin` is in your $PATH variable,
then you can run `selenium-server` system wide.

## Photos Alias
Since photos path is not directly reachable from apache, you must create an alias in your apache configuration file, like this:

```bash
Alias /photos/ "D:\photos\"
```

## Installing Ruby on windows

* Download ruby 1.9.3 from this site (section "RubyInstallers"): http://rubyinstaller.org/downloads/
* Install (NO SPACE IN PATH DIRECTORY
  * When asked, check "Add Ruby executables to your path" and "associate rb and rbw files to ruby installation"
* Reboot
* Donwload DevelopmentKit (`DevKit-tdm-32.blahblah.sfx.exe`) from this site (section "Other Useful Downloads - Development Kit"): http://rubyinstaller.org/downloads/
* Extract exe file inside your root directory, `C:\RubyDevKit` for instance (NO SPACE IN PATH)
* Link devkit to your ruby installation
  * Open windows console and go to `C:\RubyDevKit`
  * Run the following comands:
    * `ruby dk.rb init`
    * `ruby dk.rb install`
  * If something goes wrong: read https://github.com/oneclick/rubyinstaller/wiki/Development-Kit#quick-start
* Download and install a javascript engine, for example Nodejs: http://nodejs.org/
* Reboot
* Open windows console and go to kria website folder, run:
  * `gem install bundler`
  * `bundle install`
  * if something goes wrong with SSL certificates https://gist.github.com/luislavena/f064211759ee0f806c88

Now your environment should be ready.
Every time you work on kria event server, open a windows console and run `bundle exec guard` inside kria eventserver folder
Sass and Coffee files will be automagically compiled in css and js
