#= require ./behavior

class ServiceSummary
  constructor: (containerSelector) ->
    container = $(containerSelector)

    $.get(settings.baseUrl+'/service/summary')
      .success (html) ->
        container.html(html)
      .error (html) ->
        container.html("Error loading service summary")

class Service
  basicUrl: settings.baseUrl+'/service/'

  constructor: (@serviceId, @nuclearService) ->
    @serviceRow = $("#service-"+@serviceId)

  updateServiceRow: (sender, action, message) ->
    $(sender).attr('disabled', 'disabled')

    $.ajax
      type: 'POST'
      url: @basicUrl+action+'/'+@serviceId
      success: (html) =>
        @serviceRow.replaceWith(html)
        @nuclearService.nuclearifyAll()
        new FlashMessage('success', message).show()
        new ServiceSummary('#services-summary')

      error: (e) ->
        new FlashMessage('error', e.responseText).show()
        new ServiceSummary('#services-summary')
        $(sender).removeAttribute('disabled')

  updateServiceStatus: ->

    $.ajax
      type: 'POST'
      url: @basicUrl+'getStatus/'+@serviceId
      success: (html) =>
        @serviceRow.replaceWith(html)
        console.log("nuclear all");
        @nuclearService.nuclearifyAll()
        console.log("update ok");
        
      error: (e) ->
        console.log(e.responseText)   

  takeCharge: (sender) ->
    @updateServiceRow(sender, 'takeCharge', 'Preso in carico')

  releaseCharge: (sender) ->
    @updateServiceRow(sender, 'releaseCharge', 'Rilasciato')

  toEvaluate: (sender) ->
    @updateServiceRow(sender, 'setReadyToEvaluate', 'Rilasciato')


class window.NuclearService extends window.Behavior
  init: ->
    @nuclearifyAll()
    @operatorTooltip()
    @releaseAll()
    @autoUpdate() 
    

  nuclearifyAll: ->
    @nuclearifyButton('take-charge', 'takeCharge')
    @nuclearifyButton('release-charge', 'releaseCharge')
    @nuclearifyButton('to-evaluate', 'toEvaluate')

  nuclearifyButton: (buttonClass, action) ->
    self = @
    $(".#{buttonClass}[data-nuclear-botton!=nuclear]").each ->
      button = $(this)
      button.nuclear
        alertText: button.data('confirm-text')
        delay: 0
        useOnce: true
        onClick: ->
          new Service(button.data('service-id'), self)[action]()

  operatorTooltip: ->
    $('.assigned-operator').tooltip
      placement: 'left'
      trigger: 'click'


  releaseAll: -> 
    $("#release-all").nuclear
      alertText: $("#release-all").data('confirm-text') 
      onClick: ->
        releaseUrl = settings.baseUrl + '/service/releaseAllPerUser'
        successUrl = settings.baseUrl + '/service'

        $.ajax
          type: "POST"
          url: releaseUrl
          success: ->
            window.location.replace(successUrl)

            
  updateServiceStatus: ->
    self = @
    console.log("updateServiceStatus")
    $(".service-not-manageable").each ->
      serEl = $(this)
      $ser = new Service(serEl.data('service-id'), self)
      $ser.updateServiceStatus()
    @nuclearifyAll()
      
            
  autoUpdate: ->
    @updateServiceStatus()
        
    setInterval =>
      @updateServiceStatus()
    , 10000
    
            
            
