<?php

class StatsController extends Controller
{
  public function getRecentTransitsDay()
  {
    return $this->getRecentTransits(DateHelper::ensureObjectEx()->getToday());  
  }
  
  public function getRecentTransitsWeek()
  {
    return $this->getRecentTransits(DateHelper::ensureObjectEx()->getFirstDayOfWeek());  
  }
  
  public function getRecentTransitsMonth()
  {
    return $this->getRecentTransits(DateHelper::ensureObjectEx()->getFirstDayOfMonth());  
  }
  
  public function getRecentTransits($date)
  {
    $result = query('SELECT SUM(Counter) AS cnt FROM statstable IGNORE INDEX(Index_gate) WHERE StartDateTime >= :tm', array(':tm'=>$date));
    if(is_numeric($result->cnt))
      return $result->cnt;
    else
      return 0;
  }
  
  protected function beforeAction($event)
  {
    return parent::beforeAction($event);
  }
  
  public function actionStatusBox()
  { 
    return $this->renderPartial('statusBox');
  }
  
  public function actionIndex()
  {
    access_denied_check("statistics");
    $gates = Gate::getAllGates();
    $this->render('index', array('gates' => $gates));
  }

  public function actionDangerousGoods()
  {
    access_denied_check("statistics");
    $gates = Gate::getAllGates();
  	$this->render('dangerousGoods/index', array('gates' => $gates));
  }
  
  
  public function actionFilter(array $gates, array $vehiclesClass, $startTimestamp, $endTimestamp, $minSpeed, $maxSpeed, $granularity, $startTime, $endTime)
  {
    access_denied_check("statistics");
    $statsQuery = new StatsQuery();
    $dataProvider = $statsQuery->getStatsData(
      array(
        'vehiclesClass' => $vehiclesClass,
        'gates'         => $gates,
        'startTimestamp' => $startTimestamp,
        'endTimestamp'   => $endTimestamp,
      	'minSpeed'      => $minSpeed,
        'maxSpeed'      => $maxSpeed,
        'granularity'   => $granularity,
  					'startTime' 		 => $startTime,
  					'endTime'   		 => $endTime,
      )
    );

    $graphData = VehicleStatGraphEncoder::encode($dataProvider->getData(), 'StartDateTime', 'Counter', $granularity);
    $this->renderPartial('_results', array('dataProvider' => $dataProvider, 'graphData' => $graphData));
  }
  
  public function actionExport(array $gates, array $vehiclesClass, $startTimestamp, $endTimestamp, $minSpeed, $maxSpeed, $granularity, $startTime, $endTime)
  {
    access_denied_check("statistics");
    header('Set-Cookie: fileDownload=true; path=/');

  	$statsQuery = new StatsQuery();
  	$dataProvider = $statsQuery->getStatsData(
  			array(
  					'vehiclesClass' => $vehiclesClass,
  					'gates'         => $gates,
  					'startTimestamp' => $startTimestamp,
  					'endTimestamp'   => $endTimestamp,
  					'minSpeed'      => $minSpeed,
  					'maxSpeed'      => $maxSpeed,
  					'granularity'   => $granularity,
  					'useJoin'				=> true,
  					'startTime' 		 => $startTime,
  					'endTime'   		 => $endTime,
  			)
  	);
  	
  	$csv = new ECSVExport($dataProvider);
  	$content = $csv->toCSV();
		
  	$startDateTime = new DateTime();
  	$startDateTime->setTimestamp($startTimestamp);
  	
  	$endDateTime = new DateTime();
  	$endDateTime->setTimestamp($endTimestamp);
  	 
  	$startTimeStr = str_replace(":", "_", $startTime);
  	$endTimeStr = str_replace(":", "_", $endTime);
  	 
  	$fileName = "Stats_from_".$startDateTime->format("Y_m_d")."_".$startTimeStr."_to_".$endDateTime->format("Y_m_d")."_".$endTimeStr.".csv";
  	  	
  	Yii::app()->getRequest()->sendFile($fileName, $content, "text/csv", false);
		
		
		exit();
	}
    
	public function actionExportDetailed(array $gates, array $vehiclesClass, $startTimestamp, $endTimestamp, $minSpeed, $maxSpeed, $granularity, $startTime, $endTime)
	{	
    access_denied_check("statistics");
	  header('Set-Cookie: fileDownload=true; path=/');
	
		$statsQuery = new StatsQuery();
		$dataProvider = $statsQuery->getStatsData(
				array(
						'vehiclesClass' => $vehiclesClass,
						'gates'         => $gates,
						'startTimestamp' => $startTimestamp,
						'endTimestamp'   => $endTimestamp,
						'minSpeed'      => $minSpeed,
						'maxSpeed'      => $maxSpeed,
						'granularity'   => $granularity,
						'splitByGate'		=> true,
						'splitByClass'	=> true,
						'useJoin'				=> true,
  					'startTime' 		 => $startTime,
  					'endTime'   		 => $endTime,
				)
		);
		 
		$csv = new ECSVExport($dataProvider);
		$content = $csv->toCSV();
	
		$startDateTime = new DateTime();
		$startDateTime->setTimestamp($startTimestamp);
		 
		$endDateTime = new DateTime();
		$endDateTime->setTimestamp($endTimestamp);
	
    	$startTimeStr = str_replace(":", "_", $startTime);
    	$endTimeStr = str_replace(":", "_", $endTime);
  	 
    	$fileName = "Stats_from_".$startDateTime->format("Y_m_d")."_".$startTimeStr."_to_".$endDateTime->format("Y_m_d")."_".$endTimeStr.".csv";
				 
		Yii::app()->getRequest()->sendFile($fileName, $content, "text/csv", false);
	

		exit();
	}	
	
  
  public function actionDangerousGoodsFilter(array $gates, $startTimestamp, $endTimestamp, $startTime, $endTime)
  {
    access_denied_check("statistics");
    $statsQuery = new DangerousGoodsFromEventStatsQuery();
  	$dataProvider = $statsQuery->getStatsData(
  			array(
  					'gates'         => $gates,
  					'startTimestamp' => $startTimestamp,
  					'endTimestamp'   => $endTimestamp,
  					'startTime' 		 => $startTime,
  					'endTime'   		 => $endTime,
  			)
  	);
  
  	$graphData = DangerousGoodsStatGraphEncoder::encode($dataProvider->getData(), 'kemler', 'Counter');
  	$this->renderPartial('dangerousGoods/_results', array('dataProvider' => $dataProvider, 'graphData' => $graphData));
  }
  
  public function actionDangerousGoodsExport(array $gates, $startTimestamp, $endTimestamp, $startTime, $endTime)
  {
    header('Set-Cookie: fileDownload=true; path=/');
  	
  	$statsQuery = new DangerousGoodsFromEventStatsQuery();
  	$dataProvider = $statsQuery->getStatsData(
  			array(
  					'gates'         => $gates,
  					'startTimestamp' => $startTimestamp,
  					'endTimestamp'   => $endTimestamp,
  					'startTime' 		 => $startTime,
  					'splitByGate'		=>  true,
  					'useJoin'				=> true,
  			        'endTime'   		 => $endTime,
  					'descriptions'		=>  true,
  			)
  	);
  
	
  	$csv = new ECSVExport($dataProvider);
  	$content = $csv->toCSV();
		
  	$startDateTime = new DateTime();
  	$startDateTime->setTimestamp($startTimestamp);
  	
  	$endDateTime = new DateTime();
  	$endDateTime->setTimestamp($endTimestamp);
  	 
  	$startTimeStr = str_replace(":", "_", $startTime);
  	$endTimeStr = str_replace(":", "_", $endTime);
  	 
  	$fileName = "Stats_from_".$startDateTime->format("Y_m_d")."_".$startTimeStr."_to_".$endDateTime->format("Y_m_d")."_".$endTimeStr.".csv";
  	  	
  	Yii::app()->getRequest()->sendFile($fileName, $content, "text/csv", false);
		
		exit();
  }
  
  public function actionDangerousGoodsExportDetailed(array $gates, $startTimestamp, $endTimestamp, $startTime, $endTime)
  {
    access_denied_check("statistics");
    header('Set-Cookie: fileDownload=true; path=/');
  	
  	$statsQuery = new DangerousGoodsFromEventStatsQuery();
  	$dataProvider = $statsQuery->getStatsData(
  			array(
  					'gates'         => $gates,
  					'startTimestamp' => $startTimestamp,
  					'endTimestamp'   => $endTimestamp,
  					'startTime' 		 => $startTime,
  					'endTime'   		 => $endTime,
  					'descriptions'		=>  true,
  					'splitByGate'		=>  true,
    			    'splitByHour'		=> true,
  					'useJoin'				=> true,
  			)
  	);
  
  	$csv = new ECSVExport($dataProvider);
  	$content = $csv->toCSV();
		
  	$startDateTime = new DateTime();
  	$startDateTime->setTimestamp($startTimestamp);
  	
  	$endDateTime = new DateTime();
  	$endDateTime->setTimestamp($endTimestamp);
  	
  	$startTimeStr = str_replace(":", "_", $startTime);
  	$endTimeStr = str_replace(":", "_", $endTime);
  	 
  	$fileName = "Stats_from_".$startDateTime->format("Y_m_d")."_".$startTimeStr."_to_".$endDateTime->format("Y_m_d")."_".$endTimeStr.".csv";
  	
  	Yii::app()->getRequest()->sendFile($fileName, $content, "text/csv", false);
  	
  	exit();
    }
}
