<?php

class m130422_134838_add_country_mapping_table extends MyDbMigration
{
	public function up()
	{
		if($this->getTable('plate_country'))
			return;
		
    $this->createTable('plate_country',
      array(
        'id' => 'pk',
        'label' => 'string',
        'iso_code' => 'string',
        'format' => 'string',
        'rows' => 'string',
        'comment' => 'string',
      ),
      'ENGINE=MyISAM');
    $this->createIndex('label_index', 'plate_country', 'label', true); #unique

    $rows = array();
    $rows[0]['label'] = 'ITA-Provinciale';
    $rows[0]['iso_code'] = strtoupper('it');
    $rows[0]['format'] = '2+6';
    $rows[0]['rows'] = '1-2';
    $rows[0]['comment'] = 'Targa italiana di tipo vecchio con contesto fine a livello di provincia e ultime targhe emesse';

    $rows[1]['label'] = 'ITA-Normale';
    $rows[1]['iso_code'] = strtoupper('it');
    $rows[1]['format'] = '2+3+2';
    $rows[1]['rows'] = '1-2';
    $rows[1]['comment'] = '"Targa italiana di tipo ""europeo"" di ordine progressivo ed inizio ABCDEFZ"';

    $rows[2]['label'] = 'ITA-Roma';
    $rows[2]['iso_code'] = strtoupper('it');
    $rows[2]['format'] = '1+6';
    $rows[2]['rows'] = '1';
    $rows[2]['comment'] = '"Targa italiana provinciale modello ""Roma"""';

    $rows[3]['label'] = 'ITA-MotoProvinciale';
    $rows[3]['iso_code'] = strtoupper('it');
    $rows[3]['format'] = '2+6';
    $rows[3]['rows'] = '2';
    $rows[3]['comment'] = '"Targa italiana di moto, modello provinciale, solo per alcune provincie ""abbondanti"""';

    $rows[4]['label'] = 'ITA-MotoNormale';
    $rows[4]['iso_code'] = strtoupper('it');
    $rows[4]['format'] = '2+5';
    $rows[4]['rows'] = '2';
    $rows[4]['comment'] = '"Targa italiana di moto, modello ""europeo"""';

    $rows[5]['label'] = 'KEM-Tipo6';
    $rows[5]['iso_code'] = strtoupper('it');
    $rows[5]['format'] = '2+4';
    $rows[5]['rows'] = '2';
    $rows[5]['comment'] = 'Merci pericolose, modello a 6 cifre';

    $rows[6]['label'] = 'KEM-Tipo7';
    $rows[6]['iso_code'] = strtoupper('it');
    $rows[6]['format'] = '3+4';
    $rows[6]['rows'] = '2';
    $rows[6]['comment'] = 'Merci pericolose, modello a 7 cifre';

    $rows[7]['label'] = 'KEM-Tipo8';
    $rows[7]['iso_code'] = strtoupper('it');
    $rows[7]['format'] = '4+4';
    $rows[7]['rows'] = '2';
    $rows[7]['comment'] = 'Merci pericolose, modello a X+7 cifre';

    $rows[8]['label'] = 'ITA-Rimorchio';
    $rows[8]['iso_code'] = strtoupper('it');
    $rows[8]['format'] = '2+5';
    $rows[8]['rows'] = '1';
    $rows[8]['comment'] = 'Codice rimorchio LL-NNNNN';

    $rows[9]['label'] = 'ITA-Motorino';
    $rows[9]['iso_code'] = strtoupper('it');
    $rows[9]['format'] = '6';
    $rows[9]['rows'] = '2';
    $rows[9]['comment'] = 'Targa motorino a 6 simboli a base 8+20';

    $rows[10]['label'] = 'ITA-CroceRossa';
    $rows[10]['iso_code'] = strtoupper('it');
    $rows[10]['format'] = '';
    $rows[10]['rows'] = '';
    $rows[10]['comment'] = '';

    $rows[11]['label'] = 'ITA-Esercito';
    $rows[11]['iso_code'] = strtoupper('it');
    $rows[11]['format'] = '';
    $rows[11]['rows'] = '';
    $rows[11]['comment'] = '';

    $rows[12]['label'] = 'ITA-VigiliFuoco';
    $rows[12]['iso_code'] = strtoupper('it');
    $rows[12]['format'] = '';
    $rows[12]['rows'] = '';
    $rows[12]['comment'] = '';

    $rows[13]['label'] = 'ITA-Forestale';
    $rows[13]['iso_code'] = strtoupper('it');
    $rows[13]['format'] = '';
    $rows[13]['rows'] = '';
    $rows[13]['comment'] = 'solo Aosta…';

    $rows[14]['label'] = 'CH-Tipo8';
    $rows[14]['iso_code'] = strtoupper('ch');
    $rows[14]['format'] = '2+6';
    $rows[14]['rows'] = '1-2';
    $rows[14]['comment'] = 'Targa svizzera con 6 numeri dopo la sigla cantonale';

    $rows[15]['label'] = 'CH-Tipo7';
    $rows[15]['iso_code'] = strtoupper('ch');
    $rows[15]['format'] = '2+5';
    $rows[15]['rows'] = '1-2';
    $rows[15]['comment'] = 'Targa svizzera con 5 numeri dopo la sigla cantonale';

    $rows[16]['label'] = 'CH-Tipo6';
    $rows[16]['iso_code'] = strtoupper('ch');
    $rows[16]['format'] = '2+4';
    $rows[16]['rows'] = '1-2';
    $rows[16]['comment'] = 'Targa svizzera con 4 numeri dopo la sigla cantonale';

    $rows[17]['label'] = 'ESP-TipoEuropeo';
    $rows[17]['iso_code'] = strtoupper('es');
    $rows[17]['format'] = '4+3';
    $rows[17]['rows'] = '1-2';
    $rows[17]['comment'] = '"Targa spagnola di tipo ""europeo"" NNNN-LLL"';

    $rows[18]['label'] = 'ESP-Tipo142-1';
    $rows[18]['iso_code'] = strtoupper('es');
    $rows[18]['format'] = '1+4+2';
    $rows[18]['rows'] = '1';
    $rows[18]['comment'] = 'Targa spagnola di tipo vecchio L-NNNN-LL su 1 riga';

    $rows[19]['label'] = 'ESP-Tipo142-2';
    $rows[19]['iso_code'] = strtoupper('es');
    $rows[19]['format'] = '1+4+2';
    $rows[19]['rows'] = '2';
    $rows[19]['comment'] = 'Targa spagnola di tipo vecchio L-NNNN-LL su 2 righe';

    $rows[20]['label'] = 'ESP-Tipo141-1';
    $rows[20]['iso_code'] = strtoupper('es');
    $rows[20]['format'] = '1+4+1';
    $rows[20]['rows'] = '1';
    $rows[20]['comment'] = 'Targa spagnola di tipo vecchio L-NNNN-L su 1 riga';

    $rows[21]['label'] = 'ESP-Tipo141-2';
    $rows[21]['iso_code'] = strtoupper('es');
    $rows[21]['format'] = '1+4+1';
    $rows[21]['rows'] = '2';
    $rows[21]['comment'] = 'Targa spagnola di tipo vecchio L-NNNN-L su 2 righe';

    $rows[22]['label'] = 'ESP-Tipo241-1';
    $rows[22]['iso_code'] = strtoupper('es');
    $rows[22]['format'] = '2+4+1';
    $rows[22]['rows'] = '1';
    $rows[22]['comment'] = 'Targa spagnola di tipo vecchio LL-NNNN-L su 1 riga';

    $rows[23]['label'] = 'ESP-Tipo241-2';
    $rows[23]['iso_code'] = strtoupper('es');
    $rows[23]['format'] = '2+4+1';
    $rows[23]['rows'] = '2';
    $rows[23]['comment'] = 'Targa spagnola di tipo vecchio LL-NNNN-L su 2 righe';

    $rows[24]['label'] = 'ESP-Tipo242-1';
    $rows[24]['iso_code'] = strtoupper('es');
    $rows[24]['format'] = '2+4+2';
    $rows[24]['rows'] = '1';
    $rows[24]['comment'] = 'Targa spagnola di tipo vecchio LL-NNNN-LL su 1 riga';

    $rows[25]['label'] = 'UK-Tipo7';
    $rows[25]['iso_code'] = strtoupper('gb');
    $rows[25]['format'] = '2+2+3';
    $rows[25]['rows'] = '1-2';
    $rows[25]['comment'] = 'Targa inglese LL-NN-LLL';

    $rows[26]['label'] = 'UK-Tipo6';
    $rows[26]['iso_code'] = strtoupper('gb');
    $rows[26]['format'] = '1+2+3';
    $rows[26]['rows'] = '1-2';
    $rows[26]['comment'] = 'Targa inglese L-NN-LLL';

    $rows[27]['label'] = 'AUS-Wien1';
    $rows[27]['iso_code'] = strtoupper('at');
    $rows[27]['format'] = '1+5+1';
    $rows[27]['rows'] = '1';
    $rows[27]['comment'] = 'Targa austriaca speciale L-NNNNN-L (Vienna )';

    $rows[28]['label'] = 'AUS-Wien2';
    $rows[28]['iso_code'] = strtoupper('at');
    $rows[28]['format'] = '1+4+2';
    $rows[28]['rows'] = '1';
    $rows[28]['comment'] = 'Targa austriaca speciale L-NNNN-LL (Vienna e città grandi)';

    $rows[29]['label'] = 'AUS-Euro2';
    $rows[29]['iso_code'] = strtoupper('at');
    $rows[29]['format'] = '2+3+2';
    $rows[29]['rows'] = '1';
    $rows[29]['comment'] = 'Targa austriaca di tipo Europeo LL-NNN-LL';

    $rows[30]['label'] = 'AUS-Euro1';
    $rows[30]['iso_code'] = strtoupper('at');
    $rows[30]['format'] = '1+3+2';
    $rows[30]['rows'] = '1';
    $rows[30]['comment'] = 'Targa austriaca di tipo Europeo L-NNN-LL';

    $rows[31]['label'] = 'AUS-Special1';
    $rows[31]['iso_code'] = strtoupper('at');
    $rows[31]['format'] = '2+5';
    $rows[31]['rows'] = '1';
    $rows[31]['comment'] = 'Targa austriaca speciale polizia e similari LL-NNNNN';

    $rows[32]['label'] = 'AUS-Special2';
    $rows[32]['iso_code'] = strtoupper('at');
    $rows[32]['format'] = '2+4';
    $rows[32]['rows'] = '1';
    $rows[32]['comment'] = 'Targa austriaca speciale polizia e similari LL-NNNN (to do)';

    $rows[33]['label'] = 'GER-Tipo4-4';
    $rows[33]['iso_code'] = strtoupper('de');
    $rows[33]['format'] = '4+4';
    $rows[33]['rows'] = '1';
    $rows[33]['comment'] = 'Targa tedesca con 4 lettere e 4 numeri (LL-LL-NNNN o LLL-L-NNNN)';

    $rows[34]['label'] = 'GER-Tipo5-3';
    $rows[34]['iso_code'] = strtoupper('de');
    $rows[34]['format'] = '5+3';
    $rows[34]['rows'] = '1';
    $rows[34]['comment'] = 'Targa tedesca con 5 lettere e 3 numeri (LLL+LL+NNN)';

    $rows[35]['label'] = 'GER-Tipo3-4';
    $rows[35]['iso_code'] = strtoupper('de');
    $rows[35]['format'] = '3+4';
    $rows[35]['rows'] = '1';
    $rows[35]['comment'] = 'Targa tedesca con 3 lettere e 4 numeri (LL+L+NNNN o L-LL-NNNN)';

    $rows[36]['label'] = 'GER-Tipo4-3';
    $rows[36]['iso_code'] = strtoupper('de');
    $rows[36]['format'] = '4+3';
    $rows[36]['rows'] = '1';
    $rows[36]['comment'] = 'Targa tedesca con 4 lettere e 3 numeri (LL+LL+NNN o LLL-L-NNN)';

    $rows[37]['label'] = 'GER-Tipo5-2';
    $rows[37]['iso_code'] = strtoupper('de');
    $rows[37]['format'] = '5+2';
    $rows[37]['rows'] = '1';
    $rows[37]['comment'] = 'Targa tedesca con 5 lettere e 2 numeri (LLL-LL-NN)';

    $rows[38]['label'] = 'GER-Tipo2-4';
    $rows[38]['iso_code'] = strtoupper('de');
    $rows[38]['format'] = '2+4';
    $rows[38]['rows'] = '1';
    $rows[38]['comment'] = 'Targa tedesca con 2 lettere e 4 numeri (L-L-NNNN)';

    $rows[39]['label'] = 'GER-Tipo3-3';
    $rows[39]['iso_code'] = strtoupper('de');
    $rows[39]['format'] = '3+3';
    $rows[39]['rows'] = '1';
    $rows[39]['comment'] = 'Targa tedesca con 3 lettere e 3 numeri (LL-L-NNN o L-LL-NNN)';

    $rows[40]['label'] = 'GER-Tipo4-2';
    $rows[40]['iso_code'] = strtoupper('de');
    $rows[40]['format'] = '4+2';
    $rows[40]['rows'] = '1';
    $rows[40]['comment'] = 'Targa tedesca con 4 lettere e 2 numeri (LL-LL-NN o LLL-L-NN)';

    $rows[41]['label'] = 'FIN-Tipo6';
    $rows[41]['iso_code'] = strtoupper('fi');
    $rows[41]['format'] = '3+3';
    $rows[41]['rows'] = '1';
    $rows[41]['comment'] = 'Targa finlandese con 3 lettere e 3 numeri (LLL-NNN) su 1 riga';

    $rows[42]['label'] = 'FIN-Tipo5A';
    $rows[42]['iso_code'] = strtoupper('fi');
    $rows[42]['format'] = '3+2';
    $rows[42]['rows'] = '1';
    $rows[42]['comment'] = 'Targa finlandese con 3 lettere e 2 numeri (LLL-NN) su 1 riga';

    $rows[43]['label'] = 'FIN-Tipo5B';
    $rows[43]['iso_code'] = strtoupper('fi');
    $rows[43]['format'] = '2+3';
    $rows[43]['rows'] = '1';
    $rows[43]['comment'] = 'Targa finlandese con 2 lettere e 3 numeri (LL-NNN) su 1 riga';

    $rows[44]['label'] = 'UCR-Tipo8';
    $rows[44]['iso_code'] = strtoupper('ua');
    $rows[44]['format'] = '2+4+2';
    $rows[44]['rows'] = '1';
    $rows[44]['comment'] = 'Targa ucraina di tipo LL-NNNN-LL';

    $rows[45]['label'] = 'UCR-Tipo7';
    $rows[45]['iso_code'] = strtoupper('ua');
    $rows[45]['format'] = '5+2';
    $rows[45]['rows'] = '1';
    $rows[45]['comment'] = 'Targa ucraina di tipo NNN-NN-LL';

    $rows[46]['label'] = 'FRA-Tipo422';
    $rows[46]['iso_code'] = strtoupper('fr');
    $rows[46]['format'] = '4+2+2';
    $rows[46]['rows'] = '1';
    $rows[46]['comment'] = 'Targa francese vecchio tipo a 8 caratteri (NNNN-LL-NN)';

    $rows[47]['label'] = 'FRA-Tipo332';
    $rows[47]['iso_code'] = strtoupper('fr');
    $rows[47]['format'] = '3+3+2';
    $rows[47]['rows'] = '1';
    $rows[47]['comment'] = 'Targa francese vecchio tipo a 7 caratteri (NNN-LLL-NN)';

    $rows[48]['label'] = 'FRA-TipoItalia';
    $rows[48]['iso_code'] = strtoupper('fr');
    $rows[48]['format'] = '2+3+2';
    $rows[48]['rows'] = '1';
    $rows[48]['comment'] = 'Targa francese uguale a quella italiana';

    $rows[49]['label'] = 'MON';
    $rows[49]['iso_code'] = strtoupper('mc');
    $rows[49]['format'] = '4';
    $rows[49]['rows'] = '1';
    $rows[49]['comment'] = 'Targa monegasca';

    $rows[50]['label'] = 'ICE';
    $rows[50]['iso_code'] = strtoupper('is');
    $rows[50]['format'] = '2+3';
    $rows[50]['rows'] = '2';
    $rows[50]['comment'] = 'Targa islandese';

    $rows[51]['label'] = 'VIE-8';
    $rows[51]['iso_code'] = strtoupper('vn');
    $rows[51]['format'] = '2+2+4';
    $rows[51]['rows'] = '1-2';
    $rows[51]['comment'] = 'Targa vietnamita di tipo NN-LL-NNNN';

    $rows[52]['label'] = 'VIE-7';
    $rows[52]['iso_code'] = strtoupper('vn');
    $rows[52]['format'] = '2+1+4';
    $rows[52]['rows'] = '1-2';
    $rows[52]['comment'] = 'Targa vietnamita di tipo NN-L-NNNN';

    $rows[53]['label'] = 'VIE-8M';
    $rows[53]['iso_code'] = strtoupper('vn');
    $rows[53]['format'] = '2+1+1+4';
    $rows[53]['rows'] = '2';
    $rows[53]['comment'] = 'Targa vietnamita di tipo NN-LN-NNNN (solo moto)';

    $rows[54]['label'] = 'IND-10';
    $rows[54]['iso_code'] = strtoupper('in');
    $rows[54]['format'] = '2+2+2+4';
    $rows[54]['rows'] = '1';
    $rows[54]['comment'] = 'Targa indiana base tipo LL-NN-LL-NNNN';

    $rows[55]['label'] = 'IND-9';
    $rows[55]['iso_code'] = strtoupper('in');
    $rows[55]['format'] = '2+2+1+4';
    $rows[55]['rows'] = '1';
    $rows[55]['comment'] = 'Targa indiana derivata tipo LL-NN-L-NNNN';

    $rows[56]['label'] = 'SIN';
    $rows[56]['iso_code'] = strtoupper('sg');
    $rows[56]['format'] = '';
    $rows[56]['rows'] = '';
    $rows[56]['comment'] = '';

    $rows[57]['label'] = 'USA-MA6';
    $rows[57]['iso_code'] = strtoupper('us');
    $rows[57]['format'] = '3+3';
    $rows[57]['rows'] = '1';
    $rows[57]['comment'] = 'Targa Maryland NLL-LNN oppure LLL-NNN';

    $rows[58]['label'] = 'USA-MA7';
    $rows[58]['iso_code'] = strtoupper('us');
    $rows[58]['format'] = '7';
    $rows[58]['rows'] = '1';
    $rows[58]['comment'] = 'Targa Maryland NNNNNNN (ma con 1 lettera M)';

    $rows[59]['label'] = 'USA-NYLiberty';
    $rows[59]['iso_code'] = strtoupper('us');
    $rows[59]['format'] = '3+3';
    $rows[59]['rows'] = '1';
    $rows[59]['comment'] = 'Targa New York Liberty';

    $rows[60]['label'] = 'USA-NYEmpire';
    $rows[60]['iso_code'] = strtoupper('us');
    $rows[60]['format'] = '3+4';
    $rows[60]['rows'] = '1';
    $rows[60]['comment'] = 'Targa New York Empire';

    $rows[61]['label'] = 'USA-NYSpecial';
    $rows[61]['iso_code'] = strtoupper('us');
    $rows[61]['format'] = '3+3';
    $rows[61]['rows'] = '1';
    $rows[61]['comment'] = 'Targa New York Special';

    $rows[62]['label'] = 'USA-NYComm';
    $rows[62]['iso_code'] = strtoupper('us');
    $rows[62]['format'] = '5+2';
    $rows[62]['rows'] = '1';
    $rows[62]['comment'] = 'Targa New York Commerciale';

    $rows[63]['label'] = 'USA-NYTaxi';
    $rows[63]['iso_code'] = strtoupper('us');
    $rows[63]['format'] = '8';
    $rows[63]['rows'] = '1';
    $rows[63]['comment'] = 'Targa New York Taxi';

    $rows[64]['label'] = 'USA-Generic';
    $rows[64]['iso_code'] = strtoupper('us');
    $rows[64]['format'] = '3+4';
    $rows[64]['rows'] = '1';
    $rows[64]['comment'] = 'Targa Generica LLL-NNNN';

    $rows[65]['label'] = 'CAN-AL6';
    $rows[65]['iso_code'] = strtoupper('ca');
    $rows[65]['format'] = '3+3';
    $rows[65]['rows'] = '1';
    $rows[65]['comment'] = 'Targa Alberta LLL-NNN';

    $rows[66]['label'] = 'CAN-AL7';
    $rows[66]['iso_code'] = strtoupper('ca');
    $rows[66]['format'] = '3+4';
    $rows[66]['rows'] = '1';
    $rows[66]['comment'] = 'Targa Alberta LLL-NNNN';

    $rows[67]['label'] = 'CAN-AlbComm';
    $rows[67]['iso_code'] = strtoupper('ca');
    $rows[67]['format'] = '';
    $rows[67]['rows'] = '';
    $rows[67]['comment'] = '';

    $rows[68]['label'] = 'CAN-AlbFleet';
    $rows[68]['iso_code'] = strtoupper('ca');
    $rows[68]['format'] = '';
    $rows[68]['rows'] = '';
    $rows[68]['comment'] = '';

    $rows[69]['label'] = 'CAN-ON';
    $rows[69]['iso_code'] = strtoupper('ca');
    $rows[69]['format'] = '4+3';
    $rows[69]['rows'] = '1';
    $rows[69]['comment'] = 'Targa Ontario LLLL-NNN';

    $rows[70]['label'] = 'CAN-BC';
    $rows[70]['iso_code'] = strtoupper('ca');
    $rows[70]['format'] = '3+3';
    $rows[70]['rows'] = '';
    $rows[70]['comment'] = 'Targa British Columbia NNN-LLL';

    $rows[71]['label'] = 'SUD-CW8';
    $rows[71]['iso_code'] = strtoupper('za');
    $rows[71]['format'] = '2+6';
    $rows[71]['rows'] = '2';
    $rows[71]['comment'] = 'Targa sudafricana Cape Western LL-NNNNNN';

    $rows[72]['label'] = 'SUD-GP8';
    $rows[72]['iso_code'] = strtoupper('za');
    $rows[72]['format'] = '3+3+2';
    $rows[72]['rows'] = '1';
    $rows[72]['comment'] = 'Targa sudafricana Gauteng';

    $rows[73]['label'] = 'SUD-CW7';
    $rows[73]['iso_code'] = strtoupper('za');
    $rows[73]['format'] = '2+5';
    $rows[73]['rows'] = '1';
    $rows[73]['comment'] = 'Targa sudafricana Cape Western LL-NNNNN';

    $rows[74]['label'] = 'COLO-6';
    $rows[74]['iso_code'] = strtoupper('co');
    $rows[74]['format'] = '3+3';
    $rows[74]['rows'] = '1';
    $rows[74]['comment'] = 'Targa colombiana LLL-NNN';

    $rows[75]['label'] = 'PERU-6';
    $rows[75]['iso_code'] = strtoupper('pe');
    $rows[75]['format'] = '3+3';
    $rows[75]['rows'] = '1';
    $rows[75]['comment'] = 'Targa peruviana LLL-NNN';

    $rows[76]['label'] = 'PERU-5';
    $rows[76]['iso_code'] = strtoupper('pe');
    $rows[76]['format'] = '2+3';
    $rows[76]['rows'] = '1';
    $rows[76]['comment'] = 'Targa peruviana LL-NNN';

    $rows[77]['label'] = 'MACAU-6';
    $rows[77]['iso_code'] = strtoupper('mo');
    $rows[77]['format'] = '2+4';
    $rows[77]['rows'] = '1-2';
    $rows[77]['comment'] = 'Targa Macau LL-NN-NN (inizia con M)';

    $rows[78]['label'] = 'MACAU-5';
    $rows[78]['iso_code'] = strtoupper('mo');
    $rows[78]['format'] = '1+4';
    $rows[78]['rows'] = '1-2';
    $rows[78]['comment'] = 'Targa Macau L-NN-NN';

    $rows[79]['label'] = 'MACAU-Moto';
    $rows[79]['iso_code'] = strtoupper('mo');
    $rows[79]['format'] = '2+4';
    $rows[79]['rows'] = '1-2';
    $rows[79]['comment'] = 'Targa Macau moto (inizia con CM)';

    $rows[80]['label'] = 'TKM-Private7';
    $rows[80]['iso_code'] = strtoupper('tm');
    $rows[80]['format'] = '1+4+2';
    $rows[80]['rows'] = '1';
    $rows[80]['comment'] = 'Targa turkmena privata L-NNNN-LL';

    $rows[81]['label'] = 'TKM-Private8';
    $rows[81]['iso_code'] = strtoupper('tm');
    $rows[81]['format'] = '2+4+2';
    $rows[81]['rows'] = '1';
    $rows[81]['comment'] = 'Targa turkmena privata LL-NNNN-LL';

    $rows[82]['label'] = 'TKM-Govern';
    $rows[82]['iso_code'] = strtoupper('tm');
    $rows[82]['format'] = '2+2+3';
    $rows[82]['rows'] = '1';
    $rows[82]['comment'] = 'Targa turkmena governativa NNNN-LLL';

    $rows[83]['label'] = 'TKM-Military';
    $rows[83]['iso_code'] = strtoupper('tm');
    $rows[83]['format'] = '2+2+2';
    $rows[83]['rows'] = '1';
    $rows[83]['comment'] = 'Targa turkmena militare NNNN-LL';

    $rows[84]['label'] = 'TKM-Foreign';
    $rows[84]['iso_code'] = strtoupper('tm');
    $rows[84]['format'] = '1+1+5';
    $rows[84]['rows'] = '1';
    $rows[84]['comment'] = 'Targa turkmena straniera N-L-NNNNN';

    $rows[85]['label'] = 'TKM-Diplomatic';
    $rows[85]['iso_code'] = strtoupper('tm');
    $rows[85]['format'] = '2+2+3';
    $rows[85]['rows'] = '1';
    $rows[85]['comment'] = 'Targa turkmena diplomatica NN-LL-NNN';

    $rows[86]['label'] = 'ISR-Tipo7';
    $rows[86]['iso_code'] = strtoupper('il');
    $rows[86]['format'] = '2+3+2';
    $rows[86]['rows'] = '1';
    $rows[86]['comment'] = 'Targa israeliana base NN-NNN-NN';

    $rows[87]['label'] = 'ISR-Police5';
    $rows[87]['iso_code'] = strtoupper('il');
    $rows[87]['format'] = '2+3+1';
    $rows[87]['rows'] = '1';
    $rows[87]['comment'] = 'Targa israeliana polizia NN-NNN';

    $rows[88]['label'] = 'ISR-Military';
    $rows[88]['iso_code'] = strtoupper('il');
    $rows[88]['format'] = '5+1';
    $rows[88]['rows'] = '1';
    $rows[88]['comment'] = 'Targa israeliana militare';

    $rows[89]['label'] = 'ISR-Police4';
    $rows[89]['iso_code'] = strtoupper('il');
    $rows[89]['format'] = '4+1';
    $rows[89]['rows'] = '1';
    $rows[89]['comment'] = 'Targa israeliana polizia NNNN';

    $rows[90]['label'] = 'ISR-PM3';
    $rows[90]['iso_code'] = strtoupper('il');
    $rows[90]['format'] = '3+2';
    $rows[90]['rows'] = '1';
    $rows[90]['comment'] = 'Targa israeliana polizia militare';

    foreach($rows as $row)
      $this->insert('plate_country', $row);
	}

	public function down()
	{
    $this->dropTable('plate_country');
	}

}
