<?php

/**
 * This is the model class for table "crossing_times".
 *
 * The followings are the available columns in table 'crossing_times':
 * @property integer $id
 * @property string $epoch
 * @property string $timestamp
 * @property double $range
 * @property integer $id_gate_start
 * @property integer $id_gate_end
 * @property integer $ref_section
 * @property double $duration_avg
 * @property double $duration_stddev
 * @property double $duration_min
 * @property double $duration_max
 * @property double $duration_count
 * @property integer $done
 * @property integer $result_code
 * @property string $result_message
 * @property string $source
 */
class CrossingTime extends ActiveRecord
{

  const DONE_NO = 0;

  const DONE_YES = 1;

  const RESPONSE_CODE_UNKNOWN = - 1;

  const RESPONSE_CODE_SUCCESS = 0;

  const RESPONSE_CODE_ERROR = 1;

  /**
   * Returns the static model of the specified AR class.
   *
   * @param string $className
   *          active record class name.
   * @return CrossingTime the static model class
   */
  public static function model($className = __CLASS__)
  {
    return parent::model ( $className );
  }

  /**
   *
   * @return string the associated database table name
   */
  public function tableName()
  {
    return 'crossing_times';
  }

  /**
   *
   * @return array validation rules for model attributes.
   */
  public function rules()
  {
    // NOTE: you should only define rules for those attributes that
    // will receive user inputs.
    return array (
        array (
            'timestamp, id_gate_start, id_gate_end, done, result_code',
            'required' 
        ),
        array (
            'id_gate_start, id_gate_end, ref_section, done, result_code',
            'numerical',
            'integerOnly' => true 
        ),
        array (
            'range, duration_avg, duration_stddev, duration_min, duration_max, duration_count',
            'numerical' 
        ),
        array (
            'result_message, source',
            'length',
            'max' => 256 
        ),
        array (
            'epoch',
            'safe' 
        ),
        // The following rule is used by search().
        // Please remove those attributes that should not be searched.
        array (
            'id, epoch, timestamp, range, id_gate_start, id_gate_end, ref_section, duration_avg, duration_stddev, duration_min, duration_max, duration_count, done, result_code, result_message, source',
            'safe',
            'on' => 'search' 
        ) 
    );
  }

  /**
   *
   * @return array relational rules.
   */
  public function relations()
  {
    // NOTE: you may need to adjust the relation name and the related
    // class name for the relations automatically generated below.
    return array ();
  }

  /**
   *
   * @return array customized attribute labels (name=>label)
   */
  public function myAttributeLabels()
  {
    return array (
        'id' => 'ID',
        'epoch' => 'Epoch',
        'timestamp' => 'Timestamp',
        'range' => 'Range',
        'id_gate_start' => 'Id Gate Start',
        'id_gate_end' => 'Id Gate End',
        'ref_section' => 'Ref Section',
        'duration_avg' => 'Duration Avg',
        'duration_stddev' => 'Duration Stddev',
        'duration_min' => 'Duration Min',
        'duration_max' => 'Duration Max',
        'duration_count' => 'Duration Count',
        'done' => 'Done',
        'result_code' => 'Result Code',
        'result_message' => 'Result Message',
        'source' => 'Source' 
    );
  }

  /**
   * Retrieves a list of models based on the current search/filter conditions.
   *
   * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
   */
  public function search()
  {
    // Warning: Please modify the following code to remove attributes that
    // should not be searched.
    $criteria = new CDbCriteria ();
    
    $criteria->compare ( 'id', $this->id );
    $criteria->compare ( 'epoch', $this->epoch, true );
    $criteria->compare ( 'timestamp', $this->timestamp, true );
    $criteria->compare ( 'range', $this->range );
    $criteria->compare ( 'id_gate_start', $this->id_gate_start );
    $criteria->compare ( 'id_gate_end', $this->id_gate_end );
    $criteria->compare ( 'ref_section', $this->ref_section );
    $criteria->compare ( 'duration_avg', $this->duration_avg );
    $criteria->compare ( 'duration_stddev', $this->duration_stddev );
    $criteria->compare ( 'duration_min', $this->duration_min );
    $criteria->compare ( 'duration_max', $this->duration_max );
    $criteria->compare ( 'duration_count', $this->duration_count );
    $criteria->compare ( 'done', $this->done );
    $criteria->compare ( 'result_code', $this->result_code );
    $criteria->compare ( 'result_message', $this->result_message, true );
    $criteria->compare ( 'source', $this->source, true );
    
    return new CActiveDataProvider ( $this, array (
        'criteria' => $criteria 
    ) );
  }
}