<?php


class DangerousGoodsFrequencyByCode extends ActiveRecord
{
	public $Counter;
	public $Hour;
	public $adr;
	public $onu;
	
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }

  public function tableName()
  {
    return 'storicotable';
  }
  
  public function defaultScope()
  {
  	return array(
  			'condition'=>"Kemler is not null and Kemler != ''",
  	);
  }

  public function relations()
  {
  	return array(
  			'myGate'    => array(self::BELONGS_TO , 'Gate' , array('Gate'      => 'Gate')),
  	);
  }  
  
  public function behaviors()
  {
    return array('edatetimebehavior' => array('class' => 'ext.EDateTimeBehavior'));
  }

  public function byGate($gates)
  {
    if(!is_array($gates))
      $gates = array($gates);

    $this->getDbCriteria()->addInCondition('t.Gate', $gates);

    return $this;
  }

  public function byVehicleClass($vehiclesClass)
  {
    if (!is_array($vehiclesClass))
      $vehiclesClass = array($vehiclesClass);

    $this->getDbCriteria()->addInCondition('Classe', $vehiclesClass);
    return $this;
  }

  public function startingFromDate(DateTime $startDate)
  {
    $this->getDbCriteria()->mergeWith(
      array(
        'condition' => 'StartTime >= :datestart',
        'params' => array(
          ':datestart' => DateHelper::formatISO9075DateTime($startDate),
        ),
      )
    );
    return $this;
  }

  public function endingAtDate(DateTime $endDate)
  {
    $this->getDbCriteria()->mergeWith(
      array(
        'condition' => 'StartTime <= :dateend',
        'params' => array(
          ':dateend' => DateHelper::formatISO9075DateTime($endDate),
        ),
      )
    );
    return $this;
  }

  public function startingFromTime(DateTime $startTime)
  {
  	$this->getDbCriteria()->mergeWith(
  			array(
  					'condition' => 'TIME(StartTime) >= :timestart',
  					'params' => array(
  							':timestart' => DateHelper::formatISO9075Time($startTime),
  					),
  			)
  	);
  	return $this;
  }
  
  public function endingAtTime(DateTime $endTime)
  {
  	$this->getDbCriteria()->mergeWith(
  			array(
  					'condition' => 'TIME(StartTime) <= :timeend',
  					'params' => array(
  							':timeend' => DateHelper::formatISO9075Time($endTime),
  					),
  			)
  	);
  	return $this;
  }
  
  public function groupByGate()
  {
  	$this->getDbCriteria()->mergeWith(
  			array('group' => 'Gate')
  	);
  	 
  	return $this;
  }  
  
  public function groupByHour()
  {
  	$this->getDbCriteria()->mergeWith(
  			array('group' => 'HOUR(StartTime)')
  	);
  
  	return $this;
  }
  

  public function withGates($useJoin = false)
  {
    $crit = new CDbCriteria();
    if($useJoin)
    		$crit->join = "LEFT JOIN GateTable as myGate ON myGate.Gate = t.Gate";
    else
    {
    		$crit->with = array('myGate');
    		$this->getDbCriteria()->together = true;
    }
  
    $this->getDbCriteria()->mergeWith($crit);
  
    return $this;
  }

  public function withDescriptions()
  {
    $crit = new CDbCriteria();
    
    $crit->join  = "LEFT JOIN adr_code as adrt on substring(t.kemler,1, char_length(t.Kemler)-4)=adrt.code ";
    $crit->join .= "LEFT JOIN onu_code as onut on substring(t.kemler,char_length(t.Kemler)-3)=onut.code";
    
    $this->getDbCriteria()->mergeWith($crit);
  
    return $this;
  }
  
  public function getKemler()
  {
  	$Kem = $this->getAttribute('Kemler');
  	if(strlen($Kem) <= 0)
  		return '';
  
  	$pos = strrpos($Kem, ";");
  	if ($pos === false)
  	{
  		$pos = strrpos($Kem, "-");
  		if ($pos === false)
  		{
  			$offset = strlen($Kem) - 4;
  			$part1 = substr($Kem, 0, $offset);
  			$part2 = substr($Kem, $offset);
  
  			$part1 = $part1 . "-";
  			$whole = $part1 . $part2;
  
  			return $whole;
  		}
  	}
  
  
  	return str_replace(';', '-', $Kem);
  } 
  
}
