<?php
/**
 * This is the model class for table "event_reporting".
 *
 * The followings are the available columns in table 'event_reporting':
 * @property integer $id
 * @property datetime $export_time
 * @property integer $exported_events
 * @property integer $deleted_events
 * @property integer $plate_changes
 * @property integer $validated_events
 * @property string $min_ext_code
 * @property string $max_ext_code
 * @property string $user_name
 * @property integer $id_event_server
 * @property string $user_name
 * @property string $gate_sn
 * @property string $gate_type
 * @property string $gate_description
 * @property integer $id_work_period
 
  
 */
class ExportedEvents extends RegActiveRecord 
{
 
	public $year;
	public $month;
	public $exported;
	public $deleted;
  /**
   * 
   * @param system $className
   * @return Alert alert's model
   */
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }

  public function tableName()
  {
    return 'exported_events';
  }

  public function rules()
  {
    return array(
     );
  }

  public function defaultScope()
  {
  	$alias = $this->getTableAlias ( false, false );
  	
  	return array (
  			'order' => "$alias.export_time ASC"
  	);
  }
  
  public function relations()
  {
	 return array (
	        'eventServer' => array (
	            self::BELONGS_TO,
	            'EventServerRegistration',
	            array (
	                'id_event_server' => 'id' 
	            ) 
	        ),
	       
	    );
  }

  public function scopes()
  {
    return array(
    );
  }

  public function behaviors()
  {

    return array('edatetimebehavior' => array('class' => 'ext.EDateTimeBehavior'));
  	
  }

  public function byServer($idServer)
  {
  	$this->getDbCriteria()->mergeWith(array(
  			'condition' => 'id_event_server = :server',
  			'params' => array(':server' => $idServer),
  	));
  	return $this;
  }
  
  public function byGate($gateSn)
  {
  	$this->getDbCriteria()->mergeWith(array(
  			'condition' => 'gate_sn = :gatesn',
  			'params' => array(':gatesn' => $gateSn),
  	));
  	return $this;
  }
  
  public function byWorkPeriod($idWorkPeriod)
  {
  	$this->getDbCriteria()->mergeWith(array(
  			'condition' => 'id_work_period = :wperiod',
  			'params' => array(':wperiod' => $idWorkPeriod),
  	));
  	return $this;
  }

  
  public function byInterval($dateStart, $dateEnd)
  {
  
  	$startDT = DateHelper::formatISO9075DateTime ( $dateStart );
  	$endDT   = DateHelper::formatISO9075DateTime ( $dateEnd );
  
  
  	$this->getDbCriteria()->addCondition ( "t.export_time >= '$startDT'" );
  	$this->getDbCriteria()->addCondition ( "t.export_time < '$endDT'"    );
    
  	return $this;
  }
  
  public function sumInTimeInterval($dateStart, $dateEnd, $groupByGate)
  {
  	$this->byInterval($dateStart, $dateEnd);

    if($groupByGate)
   		$this->getDbCriteria()->mergeWith(array('group' => 'gate_sn, year(export_time), month(export_time)'));
    else
    	$this->getDbCriteria()->mergeWith(array('group' => 'id_event_server, year(export_time), month(export_time)'));
    	 
  	$selectColumns[] = "sum(exported_events) as exported";
  	$selectColumns[] = "sum(deleted_events) as deleted";
  	$selectColumns[] = "year(export_time) as year";
  	$selectColumns[] = "month(export_time) as month";
  	
  	if($groupByGate)  	
  		$selectColumns[] = "gate_sn";
  	else
  		$selectColumns[] = "id_event_server";
  	
  	$this->getDbCriteria()->mergeWith(array('select' => $selectColumns));
  	
  	return $this;
  }
  
  public function getGates()
  {
    	 
  	$selectColumns[] = "DISTINCT(gate_sn) as gate_sn";
  	 
  	$this->getDbCriteria()->select = "DISTINCT(gate_sn) as gate_sn";
  	 
  	return $this;
  }
  
  
}
