<?php

class PlateCountry extends ActiveRecord
{

	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public function tableName()
	{
		return 'plate_country';
	}

	public function byLabel($labels)
	{
		if(!is_array($labels))
			$labels = array($labels);
	
		$this->getDbCriteria()->addInCondition('label', $labels);
	
		return $this;
	}
	
	public function byIsoCode($isoCode)
	{
		if(!is_array($isoCode))
			$isoCode = array($isoCode);
	
		$this->getDbCriteria()->addInCondition('iso_code', $isoCode);
	
		return $this;
	}
	
	static public function getNationListFromLabels($labels)
	{
		$iso_codes = PlateCountry::model()->byLabel($labels)->findAll(array('select'=>'iso_code', 'distinct'=> true));
		if(is_null($iso_codes))
			return null;
			
		if(!is_array($iso_codes))
			$iso_codes = array($iso_codes);
		
		$arr = array();
		foreach($iso_codes as $iCode)
			$arr[] = $iCode->iso_code;
		
		return $arr;
	}
	
	static public function getPossibleTag($iso_code)
	{
		$labels = PlateCountry::model()->byIsoCode($iso_code)->findAll(array('select'=>'label', 'distinct'=> true));
		if(is_null($labels ))
			return null;
				
		if(!is_array($labels))
			$labels = array($labels);
	
		$arr = array();
		foreach($labels as $lb)
			$arr[] = $lb->label;
		
		return $arr;
	}

	
	
}
