<?php $app = Yii::app(); ?>
<?php $user = $app->user; ?>
<?php $homeUrl = $app->homeUrl; ?>
<?php $controller = $app->controller; ?>
<?php $userUpdateUrl = 'user/update/'.$user->id; ?>
<nav class="navbar navbar-fixed-top">
  <div class="navbar-menu navbar-inner">
    <div class="container">
      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'brand'), array('href', $homeUrl)), 'html5', 'UTF-8'); ?>>
        <?php echo htmlspecialchars(Yii::app()->name,ENT_QUOTES,'UTF-8'); ?>
      </a>
      <ul class="nav">
        <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof DashboardController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $homeUrl)), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(onNull(paramdeep('menuTitles','dashboard'),Yii::t("app", "Home")),ENT_QUOTES,'UTF-8'); ?></a>
        </li>
        <?php if (user()->checkAccess('view_gates_status')) { ?>
          <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof GatesStatusController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('gatesStatus')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(onNull(paramdeep('menuTitles','gateStatus'),Yii::t("app", 'Gates Status')),ENT_QUOTES,'UTF-8'); ?></a>
          </li>
        <?php } ?>
        <?php if (user()->checkAccess('view_alerts')) { ?>
          <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof AlertController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('alert/search')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(onNull(paramdeep('menuTitles','alerts'),Yii::t('app', 'Alerts')),ENT_QUOTES,'UTF-8'); ?></a>
          </li>
        <?php } ?>
        <?php if (user()->checkAccess('view_map')) { ?>
          <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof CartographyController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('cartography')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(onNull(paramdeep('menuTitles','map'),Yii::t('app', 'Maps')),ENT_QUOTES,'UTF-8'); ?></a>
          </li>
        <?php } ?>
        <?php if (user()->checkAccess('view_live')) { ?>
          <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof LiveController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('live')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(onNull(paramdeep('menuTitles','live'),Yii::t('app', 'Live')),ENT_QUOTES,'UTF-8'); ?></a>
          </li>
        <?php } ?>
        <?php if (user()->checkAccess('verify_events') || user()->checkAccess('check_events_data') || user()->checkAccess('verify_all_events_view')|| user()->checkAccess('view_task_status')) { ?>
          <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof ServiceController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('service')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(onNull(paramdeep('menuTitles','services'),Yii::t('app', 'Tasks')),ENT_QUOTES,'UTF-8'); ?></a>
          </li>
        <?php } ?>
        <?php if (user()->checkAccess('search_violations') || user()->checkAccess('search_violations_advanced') || user()->checkAccess('search_transits')) { ?>
          <li class="dropdown">
            <a class="dropdown-toggle" data-toggle="dropdown" href="#"><?php echo htmlspecialchars(onNull(paramdeep('menuTitles','search'),Yii::t('app', 'Search')),ENT_QUOTES,'UTF-8'); ?></a>
            <ul class="dropdown-menu">
              <?php if (user()->checkAccess('search_violations')) { ?>
                <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof SearchController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('search')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(Yii::t('app', 'Events - Fast search'),ENT_QUOTES,'UTF-8'); ?></a>
                </li>
              <?php } ?>
              <?php if (user()->checkAccess('search_violations_advanced')) { ?>
                <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof EventController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('event/admin')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(Yii::t('app', 'Events - Advanced search'),ENT_QUOTES,'UTF-8'); ?></a>
                </li>
              <?php } ?>
              <?php if (user()->checkAccess('search_transits')) { ?>
                <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof VehicleTraceController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('vehicleTrace/admin')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(Yii::t('app', 'Transits'),ENT_QUOTES,'UTF-8'); ?></a>
                </li>
              <?php } ?>
            </ul>
          </li>
        <?php } ?>
        <?php if($user->checkAccess('statistics')) { ?>
          <li class="dropdown">
            <a class="dropdown-toggle" data-toggle="dropdown" href="#"><?php echo htmlspecialchars(onNull(paramdeep('menuTitles','stats'),Yii::t('app', 'Stats')),ENT_QUOTES,'UTF-8'); ?></a>
            <ul class="dropdown-menu">
              <li>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('stats')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(Yii::t('app', 'Vehicles'),ENT_QUOTES,'UTF-8'); ?></a>
              </li>
              <li>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('stats/DangerousGoods')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(Yii::t('app', 'Dangerous Goods'),ENT_QUOTES,'UTF-8'); ?></a>
              </li>
            </ul>
          </li>
        <?php } ?>
        <?php if(paramdeep('ztl','active') && user()->checkAccess('ztl_view')) { ?>
          <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', (($controller instanceof ZtlController || $controller instanceof ZtlEditorController) ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('ztl/index')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(onNull(paramdeep('menuTitles','ztl'),Yii::t('app', paramdeep('ztl','name'))),ENT_QUOTES,'UTF-8'); ?></a>
          </li>
        <?php } ?>
        <?php if($user->checkAccessLike('plate_list_*') || user()->checkAccess('plate_list_view')) { ?>
          <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof PlateAuthorizationController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('plateAuthorization')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(getBWListsLabels(paramdeep('menuTitles','plateAuthorizationWL'),paramdeep('menuTitles','plateAuthorizationBL'),paramdeep('menuTitles','plateAuthorizationBWL')),ENT_QUOTES,'UTF-8'); ?></a>
          </li>
        <?php } ?>
        <?php if($user->checkAccess('diagnostic')) { ?>
          <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof DiagnosticController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('diagnostic/search')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(onNull(paramdeep('menuTitles','diagnostic'),Yii::t('app', 'Diagnostics')),ENT_QUOTES,'UTF-8'); ?></a>
          </li>
        <?php } ?>
        <?php if($user->checkAccess('manage_gates') || $user->checkAccess('manage_auth') || $user->checkAccess('manage_users') || $user->checkAccess('manage_special_day') || $user->checkAccess('manage_time_schedule') || $user->checkAccess('export_history_report')) { ?>
          <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof AdminController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('admin')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(onNull(paramdeep('menuTitles','admin'),Yii::t('app', 'Admin')),ENT_QUOTES,'UTF-8'); ?></a>
          </li>
        <?php } ?>
        <?php if((user()->isGuest && paramdeep('support','visible_to_guest')) || (!user()->isGuest && paramdeep('support','visible_to_user')))  { ?>
          <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof SupportController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('title', (t('Support'))), array('href', ($app->createUrl('support')))), 'html5', 'UTF-8'); ?>>
              <div class="icon-question-sign"></div>
            </a>
          </li>
        <?php } ?>
      </ul>
      <ul class="nav pull-right">
        <?php if ($user->isGuest) { ?>
          <li>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('session/login')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(Yii::t('app', 'Login'),ENT_QUOTES,'UTF-8'); ?></a>
          </li>
        <?php } else { ?>
          <li>
            <?php $noetbc = EventController::getNumOfEventsToBeClosed(); ?>
            <?php if($noetbc > 0) { ?>
              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'action-logout'), array('href', ($app->createUrl('session/logout'))), array('onclick', ('return confirm(\'' . (t('There are unconfirmed events, exit anyway?')) . '\')'))), 'html5', 'UTF-8'); ?>>
                <?php echo htmlspecialchars(Yii::t('app', 'Logout'),ENT_QUOTES,'UTF-8'); ?>
              </a>
            <?php } else { ?>
              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'action-logout'), array('href', ($app->createUrl('session/logout')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(Yii::t('app', 'Logout'),ENT_QUOTES,'UTF-8'); ?></a>
            <?php } ?>
          </li>
        <?php } ?>
      </ul>
    </div>
  </div>
  <div class="navbar-status">
    <div class="container">
      <?php if (!user()->isGuest) { ?>
        <?php if(paramdeep('statusBar','showPoweredBy')) { ?>
          <ul class="unstyled inline pull-left powered-by">
            <li>
              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', 'http://www.kria.biz'), array('target', ('_blank'))), 'html5', 'UTF-8'); ?>>
                <?php echo htmlspecialchars(t("powered by KRIA"),ENT_QUOTES,'UTF-8'); ?>
              </a>
            </li>
          </ul>
        <?php } ?>
        <div class="system-status-box">
          <ul class="unstyled inline span7">
            <?php if(paramdeep('statusBar','showAlerts') && user()->checkAccess('status_bar_view_alerts') && user()->checkAccess('view_alerts')) { ?>
              <li>
                <div id="alert-summary-bar"></div>
              </li>
            <?php } ?>
            <?php if(paramdeep('statusBar','showViolations') && user()->checkAccess('status_bar_view_violations')) { ?>
              <li>
                <div id="violation-status-bar"></div>
              </li>
            <?php } ?>
            <?php if(paramdeep('statusBar','showTransits') && user()->checkAccess('status_bar_view_transits')) { ?>
              <li>
                <div id="stats-status-bar"></div>
              </li>
            <?php } ?>
            <?php if(paramdeep('statusBar','showSystemStatus') && user()->checkAccess('status_bar_view_status')) { ?>
              <li>
                <div id="system-status-bar"></div>
              </li>
            <?php } ?>
          </ul>
        </div>
        <ul class="unstyled inline pull-right">
          <?php if(paramdeep('statusBar','showClock') && user()->checkAccess('status_bar_view_clock')) { ?>
            <li>
              <span>
                <div id="clock-bar">
                  <?php echo htmlspecialchars(new DateTimeEx(),ENT_QUOTES,'UTF-8'); ?>
                </div>
              </span>
            </li>
          <?php } ?>
          <li>
            <span>
              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl($userUpdateUrl)))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars($user->name,ENT_QUOTES,'UTF-8'); ?></a>
              <?php if(user()->checkAccess('manage_auth')) { ?>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'icon-key'), array('title', (t('Assignments'))), array('href', (url('auth/fastassign/user/user/'.$user->id)))), 'html5', 'UTF-8'); ?>></a>
              <?php } ?>
              <?php if(DebugController::isInDebugMode()) { ?>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug'))), array('title', (t('Debug')))), 'html5', 'UTF-8'); ?>>
                  <div class="icon-bug"></div>
                </a>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/runtime_config'))), array('title', (t('Runtime configuration')))), 'html5', 'UTF-8'); ?>>
                  <div class="icon-wrench"></div>
                </a>
              <?php } ?>
            </span>
          </li>
          <li>
            <span>
              <?php if(user()->checkAccess('create_events_report') || user()->checkAccess('show_sessions_details')) { ?>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createAbsoluteUrl('workPeriod/index')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(Yii::t('app', 'Session #'),ENT_QUOTES,'UTF-8'); ?>
                  <?php echo htmlspecialchars(Yii::app()->currentWorkPeriod->id,ENT_QUOTES,'UTF-8'); ?>
                </a>
              <?php } else { ?>
                <?php echo htmlspecialchars(Yii::t('app', 'Session #'),ENT_QUOTES,'UTF-8'); ?>
                <?php echo htmlspecialchars(Yii::app()->currentWorkPeriod->id,ENT_QUOTES,'UTF-8'); ?>
              <?php } ?>
            </span>
          </li>
        </ul>
      <?php } ?>
    </div>
  </div>
</nav>
