<?php

define('TEST_BASE_URL','http://kria.local/index-test.php/');
use FactoryGirl\Factory as FactoryGirl;

class WebTestCase extends CWebTestCase
{

	protected function setUp()
	{
		parent::setUp();
		$this->setBrowserUrl(TEST_BASE_URL);
	}

  protected function loginAs($username, $password='') {
    FactoryGirl::build('User', array(), $username);
    $this->open('');
    $this->clickAndWait('link=Login');
    $this->type('//input[@name="LoginForm[username]"]', $username);
    $this->type('//input[@name="LoginForm[password]"]', $password != '' ? $password : $username);
    $this->clickAndWait('//button[@type="submit"]');
  }

  protected function loginAsAdmin() {
    self::loginAs("admin");
  }

}
