<?php

use FactoryGirl\Factory as FactoryGirl;

class EventBehaviorTest extends DbTestCase
{
  public function testViolationCodePresenceSuccess()
  {
    $eventBehavior = FactoryGirl::create('EventBehavior', array(), 'approved');
    $eventBehavior->validate();

    $this->assertArrayNotHasKey('violation_code', $eventBehavior->errors);
  }

  public function testViolationCodePresenceFailure()
  {
    $eventBehavior = FactoryGirl::build('EventBehavior', array('violation_code' => ''), 'approved');
    $eventBehavior->validate();

    $this->assertArrayHasKey('violation_code', $eventBehavior->errors);
    $this->assertContains('Violation Code cannot be blank.', $eventBehavior->errors['violation_code']);
  }
}
