$ ->

  opts =
    lines: 13
    length: 7
    width: 4
    radius: 10
    corners: 1 
    rotate: 0
    color: '#000'
    speed: 1
    trail: 60
    shadow: false
    hwaccel: false
    className: 'spinner'
    zIndex: 2e9
    top: 5
    left: 'auto'

  if ($('#search-page').length > 0)

    $('.date-picker').datepicker()

    $(".icon-calendar").click ->
      $(@).siblings('.date-picker').datepicker('show')

    delay = (->
      timer = 0
      (callback, ms) ->
        clearTimeout timer
        timer = setTimeout(callback, ms)
    )()

    findEvents = ->
      if document.searchParameters.query.length > -1
        spinner = new Spinner(opts).spin($("#spinner").get(0))
        $.ajax
          type: "GET"
          url: settings.baseUrl+"/search/find"
          data: $.param(document.searchParameters)
          success: (html) ->
            spinner.stop()
            $("#find-results").html(html)
          error: (message) ->
            spinner.stop()

    refreshGatesArray = (origin, state) ->
      document.searchParameters.gates = new Array()
      if origin == null
          for gate in $("#gates button")
            if $(gate).hasClass("active")
              document.searchParameters.gates.push $(gate).data("gateid")
      else
        if (state)
          document.searchParameters.gates.push  $(origin).data("gateid")
        for gate in $(origin).siblings()
          if $(gate).hasClass("active")
            document.searchParameters.gates.push $(gate).data("gateid")
        if document.searchParameters.gates.length == 0
          $("#all-gates").click()
          $(origin).button('toggle')

    toggleGate = (origin) ->
      state = false
      if !$(origin).hasClass('active')
        state = true
      refreshGatesArray(origin, state)
      findEvents()

    toggleAllGates = ->
      document.searchParameters.gates = new Array()
      if !$("#all-gates").hasClass('active')
        $("#gates button").removeClass('active')
        document.searchParameters.gates.push $(gate).data("gateid") for gate in $("#gates button")
      else
        $("#gates button:first").addClass('active')
        refreshGatesArray(null,false)
      $("#all-gates").button('toggle')
      findEvents()

    setupDatePickers = ->
      $(".date-picker").change ->
        $("#when-buttons button").removeClass('active')
        document.searchParameters.startTimestamp = moment($("#start-date").datepicker('getDate')).startOf("day").unix()
        document.searchParameters.endTimestamp = moment($("#end-date").datepicker('getDate')).endOf("day").unix()
        findEvents()

    toggleMonth = ->
      document.searchParameters.startTimestamp = moment().subtract('months', 1).startOf('day').unix()
      document.searchParameters.endTimestamp = moment().endOf('day').unix()
      refreshDateFields()

    toggleWeek = ->
      document.searchParameters.startTimestamp = moment().subtract('weeks', 1).startOf('day').unix()
      document.searchParameters.endTimestamp = moment().endOf('day').unix()
      refreshDateFields()

    refreshDateFields = ->
      $("#start-date").datepicker('setDate', moment.unix(document.searchParameters.startTimestamp).toDate())
      $("#end-date").datepicker('setDate', moment.unix(document.searchParameters.endTimestamp).toDate())
      findEvents()

    document.searchParameters =
      startTimestamp: 0
      endTimestamp: 0
      gates: new Array()
      query: ""

    setupDatePickers()

    $("#this-week-button").button('toggle')

    $("#this-week-button").click ->
      toggleWeek()

    $("#this-month-button").click ->
      toggleMonth()

    $("#all-gates").click ->
      toggleAllGates()

    $("#gates button").click ->
      $("#all-gates").removeClass('active')
      toggleGate(this)

    $("#all-gates").click()
    toggleWeek()

    $("#searchbar").keypress (e) ->
      if (e.keyCode == 13)
        e.preventDefault()
        return false
      true

    $("#searchbar").keyup (e) ->
      if (e.keyCode == 13) 
        return false
      searchbar = $(this)
      delay (->
        document.searchParameters.query = searchbar.val()
        findEvents()
      ), 500

    $("#searchbar").focus()
