<?php

class P3PhpMessageSource extends CPhpMessageSource
{
  public $mappings = array();

  protected function translateMessage($category,$message,$language)
  {
    if(paramdeep('translator','enabled'))
    {
      // skip int double dates or anything that is not a string
      if(!is_string($message))
        return $message;

      $l = new LanguageInfo($language);

      // custom translation
      $result = $l->getMessageType('custom', $category, $message);
      if($result === null)
      {
        // translate standard
        $result = parent::translateMessage($category, $message, $language);
      }

      // has been translated?
      $isTranslated = ($result != $message);

      if(!$isTranslated)// no
      if(!$l->isMessageType('ignored', $category, $message))// not in ignored list
      {
        // if number/whitespace/symbols must skip
        if(!is_numeric($message) && !isEmptyOrWhitespace($message) && !strIsPunct($message))
          $l->addMessageType('untranslated', $category, $message);// add to untranslated
        //else logLine("TRANSLATION SKIPPED [$message]");
      }

      return $result;
    }
    else
    {
      return parent::translateMessage($category, $message, $language);
    }
  }

  protected function loadMessages($category,$language)
  {
    $messageFile=$this->getMessageFile($category,$language);

    if($this->cachingDuration>0 && $this->cacheID!==false && ($cache=Yii::app()->getComponent($this->cacheID))!==null)
    {
      $key=self::CACHE_KEY_PREFIX . $messageFile;
      if(($data=$cache->get($key))!==false)
        return unserialize($data);
    }

    if(is_file($messageFile))
    {
      $messages=include($messageFile);
      if(!is_array($messages))
        $messages=array();
       
      if (isset($this->mappings[$language]))
      {
        // find file according to mapping
        $messageFileMap = parent::getMessageFile($category, $this->mappings[$language]);
        $messagesMap=include($messageFileMap);
        if(!is_array($messagesMap))
          $messagesMap=array();

        $messages = $messagesMap + $messages;
      }
       
      if(isset($cache))
      {
        $dependency=new CFileCacheDependency($messageFile);
        $cache->set($key,serialize($messages),$this->cachingDuration,$dependency);
      }
      return $messages;
    }
    else if (isset($this->mappings[$language]))
    {
      // find file according to mapping
      $messageFileMap = parent::getMessageFile($category, $this->mappings[$language]);
      $messagesMap=include($messageFileMap);
      if(!is_array($messagesMap))
        $messagesMap=array();
       
      if(isset($cache))
      {
        $dependency=new CFileCacheDependency($messageFile);
        $cache->set($key,serialize($messagesMap),$this->cachingDuration,$dependency);
      }

      return $messagesMap;
       
    }
    else
      return array();
  }

}