<?php

class CrossingTimeController extends Controller
{

  public $layout = '//layouts/column2';

  /**
   * Displays a particular model.
   *
   * @param integer $id
   *          the ID of the model to be displayed
   */
  public function actionView($id)
  {
    access_denied_check ( 'crossing_time_view' );
    $this->render ( 'view', array (
        'model' => $this->loadModel ( $id ) 
    ) );
  }

  public function actionSwitchDone($id)
  {
    access_denied_check ( 'crossing_time_update' );
    $model = $this->loadModel ( $id );
    $model->done = $model->done == CrossingTime::DONE_YES ? CrossingTime::DONE_NO : CrossingTime::DONE_YES;
    $model->save ();
    $this->redirectTo ( 'crossingTime/admin' );
  }

  /**
   * Creates a new model.
   * If creation is successful, the browser will be redirected to the 'view' page.
   */
  public function actionCreate()
  {
    access_denied_check ( 'crossing_time_create' );
    $model = new CrossingTime ();
    
    // Uncomment the following line if AJAX validation is needed
    // $this->performAjaxValidation($model);
    
    if (isset ( $_POST ['CrossingTime'] ))
    {
      $model->attributes = $_POST ['CrossingTime'];
      
      $model->timestamp = DateTimeEx::now ();
      $model->epoch = DateTimeEx::now ();
      $model->result_code = CrossingTime::RESPONSE_CODE_UNKNOWN;
      $model->done = 0;
      
      if ($model->save ())
        $this->redirect ( array (
            'view',
            'id' => $model->id 
        ) );
    }
    
    $this->render ( 'create', array (
        'model' => $model 
    ) );
  }

  /**
   * Updates a particular model.
   * If update is successful, the browser will be redirected to the 'view' page.
   *
   * @param integer $id
   *          the ID of the model to be updated
   */
  public function actionUpdate($id)
  {
    access_denied_check ( 'crossing_time_update' );
    $model = $this->loadModel ( $id );
    
    // Uncomment the following line if AJAX validation is needed
    // $this->performAjaxValidation($model);
    
    if (isset ( $_POST ['CrossingTime'] ))
    {
      $model->attributes = $_POST ['CrossingTime'];
      if ($model->save ())
        $this->redirect ( array (
            'view',
            'id' => $model->id 
        ) );
    }
    
    $this->render ( 'update', array (
        'model' => $model 
    ) );
  }

  /**
   * Deletes a particular model.
   * If deletion is successful, the browser will be redirected to the 'admin' page.
   *
   * @param integer $id
   *          the ID of the model to be deleted
   */
  public function actionDelete($id)
  {
    access_denied_check ( 'crossing_time_delete' );
    $this->loadModel ( $id )
      ->delete ();
    $this->redirectTo ( 'CrossingTime/admin' );
  }

  /**
   * Lists all models.
   */
  public function actionIndex()
  {
    $this->redirectTo ( 'CrossingTime/admin' );
  }

  /**
   * Manages all models.
   */
  public function actionAdmin()
  {
    access_denied_check ( 'crossing_time_manage' );
    
    $model = new CrossingTime ( 'search' );
    $model->unsetAttributes (); // clear any default values
    if (isset ( $_GET ['CrossingTime'] ))
      $model->attributes = $_GET ['CrossingTime'];
    
    $this->render ( 'admin', array (
        'model' => $model 
    ) );
  }

  /**
   * Returns the data model based on the primary key given in the GET variable.
   * If the data model is not found, an HTTP exception will be raised.
   *
   * @param
   *          integer the ID of the model to be loaded
   * @return CrossingTime the model found
   */
  public function loadModel($id)
  {
    $model = CrossingTime::model ()->findByPk ( $id );
    if ($model === null)
      throw new CHttpException ( 404, 'The requested page does not exist.' );
    return $model;
  }
}
