<?php

class CountryList
{
  public static function getGuiLang()
  {
    $lang = strtoupper(app()->language);
    $countries = CountryList::localized();
    if(array_key_exists($lang, $countries))
      return $lang;
    return null;
  }

  static public function localized($isoCode = null)
  {
    $isoCode = trim(strtolower($isoCode ? $isoCode : Yii::app()->language));

    $localeFile = __DIR__.'/../lib/countries/country_'.$isoCode.'.php';
    if (!file_exists($localeFile))
      throw new CException("Cannot find $localeFile.");

    return include $localeFile;
  }

  static public function getCountryName($isoCode)
  {
    $countries = CountryList::localized();

    if(!is_array($isoCode))
    {
      if(isset($countries[$isoCode]))
        return $countries[$isoCode];
      else
        return $isoCode;
    }

    $res = array();
     
    foreach($isoCode as $iCode)
    {
      if(strlen($iCode) <= 0)
        continue;

      if(isset($countries[$iCode]))
      {
        $res[] = array('iso_code' => $iCode, 'nation' => $countries[$iCode]);
      }
      else
        $res[] = array('iso_code' => $iCode, 'nation' => $iCode);


    }
     
    $res_nation = array();
    foreach($res as $rn)
      $res_nation[] = $rn['nation'];
     
    array_multisort($res_nation, SORT_ASC, $res);
     
    return $res;
  }
}
