<?php

class m131030_095559_full_text_indexs extends MyDbMigration
{
	public function up()
	{
		if(!$this->indexExist('vehicleid_fulltext_index', 'vehicletracetable'))
			$this->execute("CREATE FULLTEXT INDEX `vehicleid_fulltext_index` ON vehicletracetable (VehicleID)");
		
		if(!$this->indexExist('plate_fulltext_index', 'StoricoTable'))
			$this->execute("CREATE FULLTEXT INDEX `plate_fulltext_index` ON StoricoTable (Plate)");
		
		if(!$this->indexExist('targa_fulltext_index', 'vehicletable'))
			$this->execute("CREATE FULLTEXT INDEX `targa_fulltext_index` ON vehicletable (Targa)");
	}

	public function down()
	{
		try {
		
			$this->dropIndex('vehicleid_fulltext_index', 'vehicletracetable');
		
		} catch (Exception $e) {
		}
		
		try {
		
			$this->dropIndex('plate_fulltext_index', 'StoricoTable');
		
		} catch (Exception $e) {
		}

		try {
		
			$this->dropIndex('targa_fulltext_index', 'vehicletable');
		
		} catch (Exception $e) {
		}		
		
		return true;
	}

	/*
	// Use safeUp/safeDown to do migration with transaction
	public function safeUp()
	{
	}

	public function safeDown()
	{
	}
	*/
}