<?php

/**
 * This is the model class for table "gate_behavior".
 *
 * The followings are the available columns in table 'gate_behavior':
 * @property string $ID
 * @property string $id_gate
 * @property string $id_behavior
 * @property integer $validate
 * @property integer $generate_alarm
 * @property integer $to_ignore
 * @property string $epoch
 * @property integer $transfer_from_vt
 * @property integer $transfer_from_event
 * @property integer $transfer_empty_plates
 * @property integer $is_whitelist
 * @property Behavior behavior
 */
class GateBehavior extends ActiveRecord
{

  /**
   * Returns the static model of the specified AR class.
   *
   * @param string $className
   *          active record class name.
   * @return GateBehavior the static model class
   */
  public static function model($className = __CLASS__)
  {
    return parent::model ( $className );
  }

  /**
   *
   * @return string the associated database table name
   */
  public function tableName()
  {
    return 'gate_behavior';
  }

  /**
   *
   * @return array validation rules for model attributes.
   */
  public function rules()
  {
    // NOTE: you should only define rules for those attributes that
    // will receive user inputs.
    return array (
        
        array (
            'id_gate, id_behavior',
            'required' 
        ),
        
        array (
            'validate, to_ignore, transfer_from_vt, transfer_from_event, transfer_empty_plates, is_whitelist',
            'boolean' 
        ),
        
        array (
            'id_gate, id_behavior, generate_alarm',
            'numerical' 
        ),
        
        // The following rule is used by search().
        // Please remove those attributes that should not be searched.
        array (
            'ID, id_gate, id_behavior, epoch, validate, generate_alarm, to_ignore, transfer_from_vt, transfer_from_event, transfer_empty_plates, is_whitelist',
            'safe' 
        ) 
    );
  }

  /**
   *
   * @return array relational rules.
   */
  public function relations()
  {
    // NOTE: you may need to adjust the relation name and the related
    // class name for the relations automatically generated below.
    return array (
        'behavior' => array (
            self::BELONGS_TO,
            'Behavior',
            'id_behavior' 
        ),
        'gate' => array (
            self::BELONGS_TO,
            'Gate',
            array (
                'id_gate' => 'Gate' 
            ) 
        ) 
    );
  }

  /**
   *
   * @return array customized attribute labels (name=>label)
   */
  public function myAttributeLabels()
  {
    return array (
        'ID' => 'ID',
        'id_gate' => t ( 'Gate' ),
        'id_behavior' => t ( 'Behavior' ),
        'validate' => t ( 'Validate' ),
        'generate_alarm' => t ( 'Alerts' ),
        'to_ignore' => t ( 'Ignore' ),
        'epoch' => t ( 'Epoch' ),
        'transfer_from_vt' => t ( 'Traces' ),
        'transfer_from_event' => t ( 'Events' ),
        'transfer_empty_plates' => t ( 'Empty plates' ),
        'is_whitelist' => t ( 'Whitelist gate' ) 
    );
  }

  /**
   * Retrieves a list of models based on the current search/filter conditions.
   *
   * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
   */
  public function search()
  {
    // Warning: Please modify the following code to remove attributes that
    // should not be searched.
    $criteria = new CDbCriteria ();
    
    $criteria->compare ( 'ID', $this->ID, true );
    $criteria->compare ( 'id_gate', $this->id_gate, true );
    $criteria->compare ( 'id_behavior', $this->id_behavior, true );
    $criteria->compare ( 'validate', $this->validate );
    $criteria->compare ( 'generate_alarm', $this->generate_alarm );
    $criteria->compare ( 'to_ignore', $this->to_ignore );
    $criteria->compare ( 'epoch', $this->epoch, true );
    $criteria->compare ( 'transfer_from_vt', $this->transfer_from_vt );
    $criteria->compare ( 'transfer_from_event', $this->transfer_from_event );
    $criteria->compare ( 'transfer_empty_plates', $this->transfer_empty_plates );
    $criteria->compare ( 'is_whitelist', $this->is_whitelist );
    
    $adp = new CActiveDataProvider ( $this, array (
        'criteria' => $criteria,         
    ) );
    
    $adp->pagination->setPageSize(30);
    
    return $adp;
  }

  /**
   *
   * @param boolean $exludeMyself          
   * @return string the number of rows satisfying the specified query condition. Note: type is string to keep max. precision.
   */
  public function countClones($exludeMyself = true)
  {
    if ($exludeMyself)
      return GateBehavior::model ()->count ( "id_gate=:g AND id_behavior=:b AND ID<>:me", array (
          ':g' => $this->id_gate,
          ':b' => $this->id_behavior,
          ':me' => $this->ID 
      ) );
    else
      return GateBehavior::model ()->count ( "id_gate=:g AND id_behavior=:b", array (
          ':g' => $this->id_gate,
          ':b' => $this->id_behavior 
      ) );
  }

  /**
   *
   * @param boolean $exludeMyself          
   * @return string the number of rows satisfying the specified query condition. Note: type is string to keep max. precision.
   */
  public function getClones($exludeMyself = true)
  {
    if ($exludeMyself)
      return GateBehavior::model ()->findAll ( "id_gate=:g AND id_behavior=:b AND ID<>:me", array (
          ':g' => $this->id_gate,
          ':b' => $this->id_behavior,
          ':me' => $this->ID 
      ) );
    else
      return GateBehavior::model ()->findAll ( "id_gate=:g AND id_behavior=:b", array (
          ':g' => $this->id_gate,
          ':b' => $this->id_behavior 
      ) );
  }

  /**
   *
   * @param int $id_gate          
   * @param int $id_behavior          
   * @return GateBehavior
   */
  public static function findGB($id_gate, $id_behavior)
  {
    return GateBehavior::model ()->find ( "id_gate=:g AND id_behavior=:b", array (
        ':g' => $id_gate,
        ':b' => $id_behavior 
    ) );
  }
}
