<div class="page-header">
  <h2>
    <?php echo htmlspecialchars(Yii::t("app", "Translations"),ENT_QUOTES,'UTF-8'); ?>
  </h2>
</div>
<table class="table table-condensed">
  <thead>
    <tr>
      <th><?php echo htmlspecialchars(t('Language'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Parent language'),ENT_QUOTES,'UTF-8'); ?></th>
    </tr>
  </thead>
  <tbody>
    <?php foreach($langs as $l) { ?>
      <tr>
        <td>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/translate',array('language'=>$l->language))))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(strtoupper($l),ENT_QUOTES,'UTF-8'); ?></a>
        </td>
        <td><?php echo htmlspecialchars(strtoupper($l->parent),ENT_QUOTES,'UTF-8'); ?></td>
      </tr>
    <?php } ?>
  </tbody>
</table>
<?php var_dump_html(LanguageInfo::getAllSources()); ?>
