<?php $DIMENSIONE_IMMAGINI = 250; ?>
<?php $FATTORE_ZOOM = 6; ?>
<?php $ZOOM_SPEED = 0.3; ?>
<?php $OCR_PRECISION = 0; ?>
<?php $isWhitelist = false; ?>
<?php $isRed = false; ?>
<?php if($gateBehaviors != null && is_array($gateBehaviors)) { ?>
  <?php foreach ($gateBehaviors as $index => $gateBehavior) { ?>
    <?php if($gateBehavior->is_whitelist) { ?>
      <?php $isWhitelist = true; ?>
    <?php } ?>
  <?php } ?>
<?php } ?>
<?php if($isWhitelist) { ?>
  <?php $plateAjaxUrl = CController::createUrl('event/ajaxWhitelistSmartTips'); ?>
  <?php $plateAjax = array('type' =>'POST','url' => $plateAjaxUrl,'update' => '#whitelist-smart-tips');; ?>
<?php } ?>
<?php $platesClass = paramdeep('validation','plate','alphanumeric') ? 'alphanumeric' : ''; ?>
<?php $nextEvent = $queue->getNextEvent ( $event );; ?>
<?php $previousEvent = $queue->getPreviousEvent ( $event );; ?>
<?php $ocrQualityClassHTML = ""; { ?>
  <?php if (!$event->hasCorrectedPlate()) { ?>
    <?php if (!is_null($event->ocrQuality)) { ?>
      <?php $ocrQualityRate = round($event->ocrQuality, $OCR_PRECISION) . '%';; ?>
      <?php $ocrQualityClass = $event->ocrQualityClass;; ?>
      <?php $ocrQualityClassHTML = "ocrQuality" . ucfirst($ocrQualityClass);; ?>
      <?php $ocrQualityClassHTML .= " ocrQualityTooltip";; ?>
    <?php } else { ?>
      <?php $ocrQualityRate = Yii::t('app', "Not Available");; ?>
      <?php $ocrQualityClassHTML = "ocrQualityTooltip";; ?>
    <?php } ?>
  <?php } ?>
<?php } ?>
<div id="event-page">
  <div class="page-header">
    <h2>
      <?php echo htmlspecialchars(Yii::t('app', 'Event #'),ENT_QUOTES,'UTF-8'); ?>
      <?php echo htmlspecialchars($event->ID,ENT_QUOTES,'UTF-8'); ?>
      <small>
        <?php if (isset($event->service)) { ?>
          <?php echo htmlspecialchars(Yii::t('app', 'Task'),ENT_QUOTES,'UTF-8'); ?>
          <?php echo htmlspecialchars($event->service->ID,ENT_QUOTES,'UTF-8'); ?>
        <?php } ?>
      </small>
      <small>
        <?php echo htmlspecialchars(($queue->getEventIndex($event) + 1),ENT_QUOTES,'UTF-8'); ?>
        <?php echo htmlspecialchars(Yii::t('app', 'of'),ENT_QUOTES,'UTF-8'); ?>
        <?php echo htmlspecialchars(($queue->getEventsCount()),ENT_QUOTES,'UTF-8'); ?>
      </small>
      <?php if ($event->isExamined()) { ?>
        <span class="label"><?php echo htmlspecialchars(Yii::t('app', 'Examined'),ENT_QUOTES,'UTF-8'); ?></span>
      <?php } ?>
      <?php if ($event->isValidated()) { ?>
        <span class="label"><?php echo htmlspecialchars(Yii::t('app', 'Validated'),ENT_QUOTES,'UTF-8'); ?></span>
      <?php } ?>
      <?php if (Yii::app()->user->checkAccess('edit_event_behaviors')) { ?>
        <div class="btn-group pull-right" style="font-weight: initial;">
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('href', (Yii::app()->createAbsoluteUrl('event/indexFilter', array('service' => $service, 'scope' => $scope))))), 'html5', 'UTF-8'); ?>>
            <?php echo htmlspecialchars(Yii::t("app", "All"),ENT_QUOTES,'UTF-8'); ?>
          </a>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('href', (Yii::app()->createAbsoluteUrl('event/indexFilter', array('service' => $service, 'scope' => $scope, 'toValidateOnly' => true))))), 'html5', 'UTF-8'); ?>>
            <?php echo htmlspecialchars(Yii::t("app", "to be Validated"),ENT_QUOTES,'UTF-8'); ?>
          </a>
        </div>
      <?php } ?>
    </h2>
  </div>
  <?php $form = $this->beginWidget('bootstrap.widgets.TbActiveForm',      array('type' => 'horizontal','action' => array('/event/update/'.$event->ID),'htmlOptions' => array('id' => 'event-form','data-event-id' => $event->ID,),)); ?>
  <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'internal_gate'), array('value', ($event->Gate))), 'html5', 'UTF-8'); ?> />
  <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'internal_timestamp'), array('value', (tts($event->StartTime)))), 'html5', 'UTF-8'); ?> />
  <table style="width: 100%;">
    <?php if(Yii::app()->user->checkAccess('media_view_photo') || Yii::app()->user->checkAccess('media_view_video')) { ?>
      <?php $mainMediaCount = 3; ?>
      <?php $mainMediaColumnSize = 33; ?>
      <tr>
        <?php if(user()->checkAccess('media_view_photo')) { ?>
          <?php $photoBW = $event->PreviewPhoto; ?>
          <?php $photoCOL= $event->PreviewColorPhoto; ?>
          <?php $extraPhotos = $event->PreviewExtraCameraPhoto;; ?>
          <td <?php echo MtHaml\Runtime::renderAttributes(array(array('style', ('width: ' . $mainMediaColumnSize . 'px;'))), 'html5', 'UTF-8'); ?>>
            <?php if($photoBW!=null) { ?>
              <center>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($photoBW->UrlEnhanced)), array('data-lightbox', ('alert-preview-' . ($event->ID)))), 'html5', 'UTF-8'); ?>>
                  <?php $plateRect = $photoBW->getPlateRectangle(); ?>
                  <?php if($plateRect!=null) { ?>
                    <?php $point = $plateRect->center; ?>
                    <?php $scala = $photoBW->width/$plateRect->width; ?>
                    <?php $scala /= 1.75; ?>
                    <?php $this->printAutozoomReverseImageScaleByHeight($photoBW->UrlEnhanced, $photoBW->width, $photoBW->height, $DIMENSIONE_IMMAGINI, $point->X, $point->Y, $scala, $ZOOM_SPEED); ?>
                  <?php } else { ?>
                    <?php $this->renderHtml("<div style=\"margin: 1px; border: 1px solid black; height: {$DIMENSIONE_IMMAGINI}px;\"><img src=\"$photoBW->UrlEnhanced\" style=\"height: {$DIMENSIONE_IMMAGINI}px;\" alt=\"\"></div>"); ?>
                  <?php } ?>
                </a>
              </center>
            <?php } ?>
          </td>
          <td <?php echo MtHaml\Runtime::renderAttributes(array(array('style', ('width: ' . $mainMediaColumnSize . 'px;'))), 'html5', 'UTF-8'); ?>>
            <?php $photosBWCOL = array(); ?>
            <?php if($photoCOL!=null) { ?>
              <?php $photosBWCOL[] = $photoCOL->getUrl(true); ?>
            <?php } ?>
            <?php if($photoBW!=null) { ?>
              <?php $photosBWCOL[] = $photoBW->getUrl(true); ?>
            <?php } ?>
            <?php foreach($extraPhotos as $extPhoto)       { ?>
              <?php $photosBWCOL[] = $extPhoto->getUrl(true); ?>
            <?php } ?>
            <?php if(count($photosBWCOL)>0) { ?>
              <?php $this->dragonImage($photosBWCOL, "100%", $DIMENSIONE_IMMAGINI."px"); ?>
            <?php } ?>
          </td>
        <?php } ?>
        <?php if(user()->checkAccess('media_view_video')) { ?>
          <?php $video = $event->video_col; ?>
          <?php if($video==null) { ?>
            <?php $video = $event->video_bw; ?>
          <?php } ?>
          <?php if($video==null) { ?>
            <?php $video = array_first($event->videos); ?>
          <?php } ?>
          <?php if($video!=null) { ?>
            <td <?php echo MtHaml\Runtime::renderAttributes(array(array('style', ('width: ' . $mainMediaColumnSize . 'px;'))), 'html5', 'UTF-8'); ?>>
              <center>
                <?php $this->renderVideo($video->url, null, $DIMENSIONE_IMMAGINI); ?>
              </center>
            </td>
          <?php } ?>
        <?php } ?>
      </tr>
    <?php } ?>
    <tr>
      <td colspan="3">
        <table style="width: 100%; background-color: #efefef; border-radius: 5px; padding: 10px; margin: 5px;">
          <tr>
            <td style="text-align: center; width: 25%;">
              <strong><?php echo htmlspecialchars(t('Date Time'),ENT_QUOTES,'UTF-8'); ?></strong>
              <?php echo htmlspecialchars(DateHelper::formatShort($event->StartTime),ENT_QUOTES,'UTF-8'); ?>
            </td>
            <td style="text-align: center; width: 50%;">
              <strong><?php echo htmlspecialchars(t('Gate'),ENT_QUOTES,'UTF-8'); ?></strong>
              <?php echo htmlspecialchars($event->GateDescription,ENT_QUOTES,'UTF-8'); ?>
            </td>
            <td style="text-align: center; width: 25%;">
              <strong><?php echo htmlspecialchars(t('Device ID'),ENT_QUOTES,'UTF-8'); ?></strong>
              <?php echo htmlspecialchars($event->gate->Gate        ,ENT_QUOTES,'UTF-8'); ?>
            </td>
          </tr>
        </table>
      </td>
    </tr>
    <tr>
      <td style="width: 33%;">
        <div class="plate-info-container">
          <?php if($isWhitelist) { ?>
            <?php echo $form->textFieldRow($event, 'Plate', array('class' => "touppercase span2 {$platesClass} platefield plate-white-list {$ocrQualityClassHTML}", 'id'=>'Plate', 'data-title' => Yii::t('app', 'Accuracy: ') . $ocrQualityRate)); ?>
          <?php } else { ?>
            <?php echo $form->textFieldRow($event, 'Plate', array('class' => "touppercase span2 {$platesClass} platefield {$ocrQualityClassHTML}", 'data-title' => Yii::t('app', 'Accuracy: ') . $ocrQualityRate)); ?>
          <?php } ?>
          <?php if(paramdeep('validation','plate','suggestions')) { ?>
            <?php $this->addPlateSuggestionsJS($event); ?>
          <?php } ?>
        </div>
      </td>
      <td style="width: 33%;">
        <?php if($isWhitelist) { ?>
          <?php echo $form->dropDownListRow($event, 'custom_nationality', array_merge(array('' => ''), CountryList::localized()), array('class' => 'span2 chzn-select', 'data-placeholder' => Yii::t('app', 'Country...'))); ?>
        <?php } else { ?>
          <?php echo $form->dropDownListRow($event, 'custom_nationality', array_merge(array('' => ''), CountryList::localized()), array('class' => 'span2 chzn-select', 'data-placeholder' => Yii::t('app', 'Country...'))); ?>
        <?php } ?>
      </td>
      <td style="width: 33%;" rowspan="3">
        <?php if($isWhitelist) { ?>
          <?php $this->renderPartial("_eventBehavior_WhiteList_SmartTips", array('event' => $event, 'plate' => $event->Plate, 'nationality' => $event->custom_nationality, 'timestamp' => $event->StartTime, 'gate'=>$event->gate->Gate)); ?>
        <?php } ?>
      </td>
    </tr>
    <tr>
      <td style="width: 33%;">
        <?php echo $form->dropDownListRow($event, 'custom_vehicle_type', array_merge(array('' => ''), VehicleTypes::localizedForValidation()), array('class' => 'span2 chzn-select', 'data-placeholder' => Yii::t('app', 'Class...'))); ?>
      </td>
      <td style="width: 33%;">
        <?php echo $form->dropDownListRow($event, 'custom_plate_type',  array_merge(array('' => ''), CHtml::listData(CustomPlateType::model()->findAll(), 'type', 'label')), array('class' => 'span2 chzn-select', 'data-placeholder' => Yii::t('app', 'Plate Type...'))); ?>
      </td>
    </tr>
    <tr>
      <td style="width: 33%;">
        <?php echo $form->dropDownListRow($event, 'custom_property_type', array_merge(array('' => ''), CHtml::listData(CustomPropertyType::model()->findAll(), 'type', 'label')), array('class' => 'span2 chzn-select', 'data-placeholder' => Yii::t('app', 'Custom Property...'))); ?>
      </td>
      <td style="width: 33%;">
        <center>
          <div class="control-group input-append">
            <?php echo $form->textField($event, 'Kemler', array('class'=>'span2')); ?>
            <div class="btn-group">
              <button class="btn dropdown-toggle" type="button" data-toggle="dropdown">
                <?php echo htmlspecialchars(t('Kemler-ONU'),ENT_QUOTES,'UTF-8'); ?>
                <span class="caret"></span>
              </button>
              <ul class="dropdown-menu">
                <li>
                  <a href="#" data-set-value="" data-set-target="#Event_Kemler">
                    <?php echo htmlspecialchars(t('None'),ENT_QUOTES,'UTF-8'); ?>
                  </a>
                </li>
                <li>
                  <a href="#" data-set-value="GENERIC" data-set-target="#Event_Kemler">
                    <?php echo htmlspecialchars(t('Generic'),ENT_QUOTES,'UTF-8'); ?>
                  </a>
                </li>
                <li class="divider"></li>
                <li>
                  <a id="kemler-toggle" href="#">
                    <?php echo htmlspecialchars(t('Search Kemler-ONU'),ENT_QUOTES,'UTF-8'); ?>
                  </a>
                </li>
              </ul>
            </div>
          </div>
        </center>
      </td>
    </tr>
  </table>
  <div id="event-behaviors" style="width: 100%;">
    <?php if (Yii::app()->user->checkAccess('edit_event_behaviors')) { ?>
      <div>
        <h5></h5>
        <?php echo htmlspecialchars(Yii::t('app', 'Violations'),ENT_QUOTES,'UTF-8'); ?>
        <?php if(user()->checkAccess('event_behavior_create')) { ?>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'icon-plus'), array('href', (url('EventBehavior/create', array('id_event'=>$event->ID))))), 'html5', 'UTF-8'); ?>></a>
        <?php } ?>
        <ul class="zebra unstyled">
          <?php foreach ($eventBehaviors as $index => $eventBehavior) { ?>
            <li class="zebra-item">
              <?php $this->renderPartial("_eventBehavior", array('eventBehavior' => $eventBehavior, 'event' => $event, 'form' => $form, 'index' => $index, 'suggestedCodes' => $suggestedCodes[$eventBehavior->behavior->tag])); ?>
            </li>
          <?php } ?>
        </ul>
      </div>
    <?php } ?>
  </div>
  <?php $this->endWidget(); ?>
  <footer class="row">
    <div class="span12 gray-box">
      <div class="row">
        <div class="event-navigation span3">
          <?php $previousLink = Yii::app()->createUrl('event/edit', array('id' => $previousEvent->ID, 'service' => $service, 'scope' => $scope, 'toValidateOnly' => $toValidateOnly)); ?>
          <?php $nextLink = Yii::app()->createUrl('event/edit', array('id' => $nextEvent->ID, 'service' => $service, 'scope' => $scope, 'toValidateOnly' => $toValidateOnly)); ?>
          <?php if ($queue->isFirst($event)) { ?>
            <a class="btn btn-large disabled">
              <i class="icon-circle-arrow-left"></i>
            </a>
          <?php } else { ?>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-large' . ' ' . 'cacheIgnore')), array('href', $previousLink)), 'html5', 'UTF-8'); ?>>
              <i class="icon-circle-arrow-left"></i>
            </a>
          <?php } ?>
          <?php if($queue->isLast($event)) { ?>
            <a class="btn btn-large disabled">
              <i class="icon-circle-arrow-right"></i>
            </a>
          <?php } else { ?>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-large' . ' ' . 'cacheIgnore')), array('href', $nextLink)), 'html5', 'UTF-8'); ?>>
              <i class="icon-circle-arrow-right"></i>
            </a>
          <?php } ?>
        </div>
        <div class="event-buttons span5 pull-right">
          <?php if (!Yii::app()->user->checkAccess('edit_event_behaviors')) { ?>
            <button <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'suspend-btn'), array('class', 'btn'), array('type', 'button'), array('data-confirm-text', (Yii::t('app', 'Confirm'))), array('data-form-action', (Yii::app()->createUrl('event/suspend', array('id' => $event->ID, 'service' => $service, 'scope' => $scope, 'toValidateOnly' => $toValidateOnly)))), array('data-target', '#event-form')), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(Yii::t('app', 'Suspend'),ENT_QUOTES,'UTF-8'); ?></button>
          <?php } ?>
          <button <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'save-btn'), array('class', 'btn'), array('type', 'button'), array('data-confirm-text', (Yii::t('app', 'Confirm'))), array('data-form-action', (Yii::app()->createUrl('event/update', array('id' => $event->ID, 'service' => $service, 'scope' => $scope, 'toValidateOnly' => $toValidateOnly)))), array('data-target', '#event-form')), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(Yii::t('app', 'Save & Next'),ENT_QUOTES,'UTF-8'); ?></button>
          <?php if(paramdeep('validation','showSaveAndReleaseButton')) { ?>
            <button <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'save-release-btn'), array('class', 'btn'), array('type', 'button'), array('data-confirm-text', (Yii::t('app', 'Confirm'))), array('data-form-action', (Yii::app()->createUrl('event/updateRelease', array('id' => $event->ID, 'service' => $service, 'scope' => $scope, 'toValidateOnly' => $toValidateOnly)))), array('data-target', '#event-form')), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(Yii::t('app', 'Save & Release'),ENT_QUOTES,'UTF-8'); ?></button>
          <?php } ?>
        </div>
      </div>
    </div>
  </footer>
  <div id="overlay">
    <div id="modal-image"></div>
  </div>
  <div id="kemler-modal" class="modal hide fade" tabindex="-1"></div>
  <div id="whitelist-import-modal" class="modal hide fade" tabindex="-1">
    <p>
      hallo!
    </p>
  </div>
</div>
<div id="modal-alert-photo-preview"></div>
