<div class="tableContainer pagination-data-container gate-behavior-table span6">
  <table class="table table-condensed">
    <thead>
      <tr></tr>
      <tr>
        <th><?php echo htmlspecialchars(t('Behavior'),ENT_QUOTES,'UTF-8'); ?></th>
        <th><?php echo htmlspecialchars(t('Validate'),ENT_QUOTES,'UTF-8'); ?></th>
        <th><?php echo htmlspecialchars(t('Alert'),ENT_QUOTES,'UTF-8'); ?></th>
        <th><?php echo htmlspecialchars(t('Ignore'),ENT_QUOTES,'UTF-8'); ?></th>
        <th>
          <span class="icon-arrow-right"></span>
          <?php echo htmlspecialchars(t('Traces'),ENT_QUOTES,'UTF-8'); ?>
        </th>
        <th>
          <span class="icon-arrow-right"></span>
          <?php echo htmlspecialchars(t('Events'),ENT_QUOTES,'UTF-8'); ?>
        </th>
        <th>
          <span class="icon-arrow-right"></span>
          <?php echo htmlspecialchars(t ( 'Empty plates' ),ENT_QUOTES,'UTF-8'); ?>
        </th>
        <th><?php echo htmlspecialchars(t ( 'Whitelist gate' ) ,ENT_QUOTES,'UTF-8'); ?></th>
      </tr>
    </thead>
    <tbody>
      <?php foreach($gate->gateBehavior as $gB) { ?>
        <?php $model = $gB; ?>
        <?php if (! user ()->checkAccess ( "gate_behavior_update" ) && ! user ()->checkAccess ( "gate_behavior_switch" ) ) { ?>
          <tr>
            <td>
              <?php echo htmlspecialchars(t($gB->behavior->name),ENT_QUOTES,'UTF-8'); ?>
            </td>
            <td>
              <?php if($gB->validate) { ?>
                <div class="icon-circle"></div>
              <?php } else { ?>
                <div class="icon-circle-blank"></div>
              <?php } ?>
            </td>
            <td>
              <?php if($gB->generate_alarm >= 3) { ?>
                <div class="icon-exclamation-sign alarm alarm-icon"></div>
              <?php } else if($gB->generate_alarm >= 2) { ?>
                <div class="icon-warning-sign alarm warning-icon"></div>
              <?php } else if($gB->generate_alarm >= 1) { ?>
                <div class="icon-info-sign alarm info-icon"></div>
              <?php } else { ?>
                <div class="icon-cirlce-empty"></div>
              <?php } ?>
            </td>
            <td>
              <?php if($gB->to_ignore) { ?>
                <div class="icon-circle"></div>
              <?php } else { ?>
                <div class="icon-circle-blank"></div>
              <?php } ?>
            </td>
            <td>
              <?php if($gB->transfer_from_vt) { ?>
                <div class="icon-circle"></div>
              <?php } else { ?>
                <div class="icon-circle-blank"></div>
              <?php } ?>
            </td>
            <td>
              <?php if($gB->transfer_from_event) { ?>
                <div class="icon-circle"></div>
              <?php } else { ?>
                <div class="icon-circle-blank"></div>
              <?php } ?>
            </td>
            <td>
              <?php if($gB->transfer_empty_plates) { ?>
                <div class="icon-circle"></div>
              <?php } else { ?>
                <div class="icon-circle-blank"></div>
              <?php } ?>
            </td>
            <td>
              <?php if($gB->is_whitelist) { ?>
                <div class="icon-circle"></div>
              <?php } else { ?>
                <div class="icon-circle-blank"></div>
              <?php } ?>
            </td>
          </tr>
        <?php } else { ?>
          <tr>
            <td>
              <?php echo htmlspecialchars(t($gB->behavior->name),ENT_QUOTES,'UTF-8'); ?>
            </td>
            <td>
              <?php echo SystemInfoHelper::getFullSwitchButtonLabel("gateBehavior", "switchValidate", $model->ID, $model->validate, "Yes","No","green","red",app()->controller->getAbsoluteUrl(),"icon-refresh")              ; ?>
            </td>
            <td>
              <?php echo SystemInfoHelper::trafficEventSelector($model->ID, $model->generate_alarm, "gateBehavior", "switchGenerateAlarm", "value", app()->controller->getAbsoluteUrl()); ?>
            </td>
            <td>
              <?php echo SystemInfoHelper::getFullSwitchButtonLabel("gateBehavior", "switchToIgnore", $model->ID, $model->to_ignore, "Yes","No","green","red",app()->controller->getAbsoluteUrl(),"icon-refresh"); ?>
            </td>
            <td>
              <?php echo SystemInfoHelper::getFullSwitchButtonLabel("gateBehavior", "switchTransVt", $model->ID, $model->transfer_from_vt, "Yes","No","green","red",app()->controller->getAbsoluteUrl(),"icon-refresh"); ?>
            </td>
            <td>
              <?php echo SystemInfoHelper::getFullSwitchButtonLabel("gateBehavior", "switchtransEv", $model->ID, $model->transfer_from_event, "Yes","No","green","red",app()->controller->getAbsoluteUrl(),"icon-refresh"); ?>
            </td>
            <td>
              <?php echo SystemInfoHelper::getFullSwitchButtonLabel("gateBehavior", "switchTransEp", $model->ID, $model->transfer_empty_plates, "Yes","No","green","red",app()->controller->getAbsoluteUrl(),"icon-refresh"); ?>
            </td>
            <td>
              <?php echo SystemInfoHelper::getFullSwitchButtonLabel("gateBehavior", "switchIsWhitelist", $model->ID, $model->is_whitelist, "Yes","No","green","red",app()->controller->getAbsoluteUrl(),"icon-refresh"); ?>
            </td>
          </tr>
        <?php } ?>
      <?php } ?>
    </tbody>
  </table>
</div>
