<?php $preferences = param('gateStatus'); ?>
<?php $lastViolationMinutes = $preferences['lastViolationMinutes'];; ?>
<?php $hours = $lastViolationMinutes / 60; ?>
<?php $days = $hours / 24; ?>
<h3>
  <?php echo htmlspecialchars(t('Gates'),ENT_QUOTES,'UTF-8'); ?>
  <small>
    <?php if($days >= 1) { ?>
      <?php echo htmlspecialchars(t('Last {qty_days} days summary', array('{qty_days}' => $days)),ENT_QUOTES,'UTF-8'); ?>
    <?php } else { ?>
      <?php echo htmlspecialchars(t('Last {qty_hours} hours summary', array('{qty_hours}' => $hours)),ENT_QUOTES,'UTF-8'); ?>
    <?php } ?>
  </small>
</h3>
<div class="gate-list-update-info">
  <span>
    <?php echo htmlspecialchars(t('Updated at:'),ENT_QUOTES,'UTF-8'); ?>
    <?php echo htmlspecialchars(DateHelper::formatLocalDateTime(),ENT_QUOTES,'UTF-8'); ?>
  </span>
</div>
<div id="gates-container">
  <?php foreach($gateGroups as $gateGroup) { ?>
    <?php $gateGroup = new GateGroupPresenter($gateGroup); ?>
    <div class="gate-group-all">
      <div class="gate-group-all-name">
        <span <?php echo MtHaml\Runtime::renderAttributes(array(array('title', (t('Gate group')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars($gateGroup->name,ENT_QUOTES,'UTF-8'); ?></span>
      </div>
      <?php $gates = $gateGroup->gates; ?>
      <?php foreach($gates as $gate) { ?>
        <?php $gate = new GatePresenter($gate); ?>
        <?php $this->renderPartial('gates/_gateBox', array('gate' => $gate, 'gateGroup' => $gateGroup, 'viewMode' => $viewMode)); ?>
      <?php } ?>
    </div>
  <?php } ?>
</div>
